/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.core.memory.MemorySegmentWritable;
import org.apache.flink.runtime.memory.AbstractPagedInputView;
import org.apache.flink.runtime.memory.AbstractPagedOutputView;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.runtime.typeutils.AbstractRowSerializer;
import org.apache.flink.table.runtime.util.SegmentsUtil;
import org.apache.flink.util.Preconditions;

public class BinaryRowSerializer
extends AbstractRowSerializer<BinaryRow> {
    private static final long serialVersionUID = 1L;
    public static final int LENGTH_SIZE_IN_BYTES = 4;
    private final int numFields;
    private final int fixedLengthPartSize;

    public BinaryRowSerializer(int numFields) {
        this.numFields = numFields;
        this.fixedLengthPartSize = BinaryRow.calculateFixPartSizeInBytes(numFields);
    }

    public boolean isImmutableType() {
        return false;
    }

    public TypeSerializer<BinaryRow> duplicate() {
        return new BinaryRowSerializer(this.numFields);
    }

    public BinaryRow createInstance() {
        return new BinaryRow(this.numFields);
    }

    public BinaryRow copy(BinaryRow from) {
        return this.copy(from, new BinaryRow(this.numFields));
    }

    public BinaryRow copy(BinaryRow from, BinaryRow reuse) {
        return from.copy(reuse);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(BinaryRow record, DataOutputView target) throws IOException {
        target.writeInt(record.getSizeInBytes());
        if (target instanceof MemorySegmentWritable) {
            BinaryRowSerializer.serializeWithoutLength(record, (MemorySegmentWritable)target);
        } else {
            SegmentsUtil.copyToView(record.getSegments(), record.getOffset(), record.getSizeInBytes(), target);
        }
    }

    public BinaryRow deserialize(DataInputView source) throws IOException {
        BinaryRow row = new BinaryRow(this.numFields);
        int length = source.readInt();
        byte[] bytes = new byte[length];
        source.readFully(bytes);
        row.pointTo(MemorySegmentFactory.wrap((byte[])bytes), 0, length);
        return row;
    }

    public BinaryRow deserialize(BinaryRow reuse, DataInputView source) throws IOException {
        MemorySegment[] segments = reuse.getSegments();
        Preconditions.checkArgument((segments == null || segments.length == 1 && reuse.getOffset() == 0 ? 1 : 0) != 0, (Object)"Reuse BinaryRow should have no segments or only one segment and offset start at 0.");
        int length = source.readInt();
        if (segments == null || segments[0].size() < length) {
            segments = new MemorySegment[]{MemorySegmentFactory.wrap((byte[])new byte[length])};
        }
        source.readFully(segments[0].getArray(), 0, length);
        reuse.pointTo(segments, 0, length);
        return reuse;
    }

    @Override
    public int getArity() {
        return this.numFields;
    }

    @Override
    public BinaryRow toBinaryRow(BinaryRow baseRow) throws IOException {
        return baseRow;
    }

    @Override
    public int serializeToPages(BinaryRow record, AbstractPagedOutputView headerLessView) throws IOException {
        Preconditions.checkArgument((headerLessView.getHeaderLength() == 0 ? 1 : 0) != 0);
        int skip = this.checkSkipWriteForFixLengthPart(headerLessView);
        headerLessView.writeInt(record.getSizeInBytes());
        BinaryRowSerializer.serializeWithoutLength(record, (MemorySegmentWritable)headerLessView);
        return skip;
    }

    private static void serializeWithoutLength(BinaryRow record, MemorySegmentWritable writable) throws IOException {
        if (record.getSegments().length == 1) {
            writable.write(record.getSegments()[0], record.getOffset(), record.getSizeInBytes());
        } else {
            BinaryRowSerializer.serializeWithoutLengthSlow(record, writable);
        }
    }

    public static void serializeWithoutLengthSlow(BinaryRow record, MemorySegmentWritable out) throws IOException {
        int remainSize = record.getSizeInBytes();
        int posInSegOfRecord = record.getOffset();
        int segmentSize = record.getSegments()[0].size();
        for (MemorySegment segOfRecord : record.getSegments()) {
            int nWrite = Math.min(segmentSize - posInSegOfRecord, remainSize);
            assert (nWrite > 0);
            out.write(segOfRecord, posInSegOfRecord, nWrite);
            posInSegOfRecord = 0;
            if ((remainSize -= nWrite) == 0) break;
        }
        Preconditions.checkArgument((remainSize == 0 ? 1 : 0) != 0);
    }

    @Override
    public BinaryRow deserializeFromPages(AbstractPagedInputView headerLessView) throws IOException {
        return this.deserializeFromPages(this.createInstance(), headerLessView);
    }

    @Override
    public BinaryRow deserializeFromPages(BinaryRow reuse, AbstractPagedInputView headerLessView) throws IOException {
        Preconditions.checkArgument((headerLessView.getHeaderLength() == 0 ? 1 : 0) != 0);
        this.checkSkipReadForFixLengthPart(headerLessView);
        return this.deserialize(reuse, (DataInputView)headerLessView);
    }

    @Override
    public BinaryRow mapFromPages(AbstractPagedInputView headerLessView) throws IOException {
        return this.mapFromPages(this.createInstance(), headerLessView);
    }

    @Override
    public BinaryRow mapFromPages(BinaryRow reuse, AbstractPagedInputView headerLessView) throws IOException {
        Preconditions.checkArgument((headerLessView.getHeaderLength() == 0 ? 1 : 0) != 0);
        this.checkSkipReadForFixLengthPart(headerLessView);
        this.pointTo(headerLessView.readInt(), reuse, headerLessView);
        return reuse;
    }

    public void copyFromPagesToView(AbstractPagedInputView source, DataOutputView target) throws IOException {
        this.checkSkipReadForFixLengthPart(source);
        int length = source.readInt();
        target.writeInt(length);
        target.write((DataInputView)source, length);
    }

    public void pointTo(int length, BinaryRow reuse, AbstractPagedInputView headerLessView) throws IOException {
        Preconditions.checkArgument((headerLessView.getHeaderLength() == 0 ? 1 : 0) != 0);
        if (length < 0) {
            throw new IOException(String.format("Read unexpected bytes in source of positionInSegment[%d] and limitInSegment[%d]", headerLessView.getCurrentPositionInSegment(), headerLessView.getCurrentSegmentLimit()));
        }
        int remainInSegment = headerLessView.getCurrentSegmentLimit() - headerLessView.getCurrentPositionInSegment();
        MemorySegment currSeg = headerLessView.getCurrentSegment();
        int currPosInSeg = headerLessView.getCurrentPositionInSegment();
        if (remainInSegment >= length) {
            reuse.pointTo(currSeg, currPosInSeg, length);
            headerLessView.skipBytesToRead(length);
        } else {
            this.pointToMultiSegments(reuse, headerLessView, length, length - remainInSegment, currSeg, currPosInSeg);
        }
    }

    private void pointToMultiSegments(BinaryRow reuse, AbstractPagedInputView source, int sizeInBytes, int remainLength, MemorySegment currSeg, int currPosInSeg) throws IOException {
        int div;
        int segmentSize = currSeg.size();
        int remainder = remainLength - segmentSize * (div = remainLength / segmentSize);
        int varSegSize = remainder == 0 ? div : div + 1;
        MemorySegment[] segments = new MemorySegment[varSegSize + 1];
        segments[0] = currSeg;
        for (int i = 1; i <= varSegSize; ++i) {
            source.advance();
            segments[i] = source.getCurrentSegment();
        }
        int remainLenInLastSeg = remainder == 0 ? segmentSize : remainder;
        source.skipBytesToRead(remainLenInLastSeg);
        reuse.pointTo(segments, currPosInSeg, sizeInBytes);
    }

    private int checkSkipWriteForFixLengthPart(AbstractPagedOutputView out) throws IOException {
        int available = out.getSegmentSize() - out.getCurrentPositionInSegment();
        if (available < this.getSerializedRowFixedPartLength()) {
            out.advance();
            return available;
        }
        return 0;
    }

    public void checkSkipReadForFixLengthPart(AbstractPagedInputView source) throws IOException {
        int available = source.getCurrentSegmentLimit() - source.getCurrentPositionInSegment();
        if (available < this.getSerializedRowFixedPartLength()) {
            source.advance();
        }
    }

    public int getSerializedRowFixedPartLength() {
        return this.getFixedLengthPartSize() + 4;
    }

    public int getFixedLengthPartSize() {
        return this.fixedLengthPartSize;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int length = source.readInt();
        target.writeInt(length);
        target.write(source, length);
    }

    public boolean equals(Object obj) {
        return obj instanceof BinaryRowSerializer && this.numFields == ((BinaryRowSerializer)((Object)obj)).numFields;
    }

    public int hashCode() {
        return Integer.hashCode(this.numFields);
    }

    public TypeSerializerSnapshot<BinaryRow> snapshotConfiguration() {
        return new BinaryRowSerializerSnapshot(this.numFields);
    }

    public static final class BinaryRowSerializerSnapshot
    implements TypeSerializerSnapshot<BinaryRow> {
        private static final int CURRENT_VERSION = 3;
        private int previousNumFields;

        public BinaryRowSerializerSnapshot() {
        }

        BinaryRowSerializerSnapshot(int numFields) {
            this.previousNumFields = numFields;
        }

        public int getCurrentVersion() {
            return 3;
        }

        public void writeSnapshot(DataOutputView out) throws IOException {
            out.writeInt(this.previousNumFields);
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            this.previousNumFields = in.readInt();
        }

        public TypeSerializer<BinaryRow> restoreSerializer() {
            return new BinaryRowSerializer(this.previousNumFields);
        }

        public TypeSerializerSchemaCompatibility<BinaryRow> resolveSchemaCompatibility(TypeSerializer<BinaryRow> newSerializer) {
            if (!(newSerializer instanceof BinaryRowSerializer)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            BinaryRowSerializer newBinaryRowSerializer = (BinaryRowSerializer)newSerializer;
            if (this.previousNumFields != newBinaryRowSerializer.numFields) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            return TypeSerializerSchemaCompatibility.compatibleAsIs();
        }
    }
}

