/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.partitioner;

import java.util.Arrays;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.generated.GeneratedHashFunction;
import org.apache.flink.table.runtime.generated.HashFunction;
import org.apache.flink.util.MathUtils;

public class BinaryHashPartitioner
extends StreamPartitioner<BaseRow> {
    private GeneratedHashFunction genHashFunc;
    private transient HashFunction hashFunc;
    private String[] hashFieldNames;

    public BinaryHashPartitioner(GeneratedHashFunction genHashFunc, String[] hashFieldNames) {
        this.genHashFunc = genHashFunc;
        this.hashFieldNames = hashFieldNames;
    }

    public StreamPartitioner<BaseRow> copy() {
        return this;
    }

    public int selectChannel(SerializationDelegate<StreamRecord<BaseRow>> record) {
        return MathUtils.murmurHash((int)this.getHashFunc().hashCode((BaseRow)((StreamRecord)record.getInstance()).getValue())) % this.numberOfChannels;
    }

    private HashFunction getHashFunc() {
        if (this.hashFunc == null) {
            try {
                this.hashFunc = (HashFunction)this.genHashFunc.newInstance(Thread.currentThread().getContextClassLoader());
                this.genHashFunc = null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.hashFunc;
    }

    public String toString() {
        return "HASH" + Arrays.toString(this.hashFieldNames);
    }
}

