/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.wmassigners;

import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.generated.GeneratedWatermarkGenerator;
import org.apache.flink.table.runtime.generated.WatermarkGenerator;
import org.apache.flink.table.runtime.operators.wmassigners.WatermarkAssignerOperator;

public class WatermarkAssignerOperatorFactory
implements OneInputStreamOperatorFactory<BaseRow, BaseRow> {
    private static final long serialVersionUID = 1L;
    private final int rowtimeFieldIndex;
    private final long idleTimeout;
    private final GeneratedWatermarkGenerator generatedWatermarkGenerator;
    private ChainingStrategy strategy = ChainingStrategy.ALWAYS;

    public WatermarkAssignerOperatorFactory(int rowtimeFieldIndex, long idleTimeout, GeneratedWatermarkGenerator generatedWatermarkGenerator) {
        this.rowtimeFieldIndex = rowtimeFieldIndex;
        this.idleTimeout = idleTimeout;
        this.generatedWatermarkGenerator = generatedWatermarkGenerator;
    }

    public StreamOperator createStreamOperator(StreamTask containingTask, StreamConfig config, Output output) {
        WatermarkGenerator watermarkGenerator = (WatermarkGenerator)((Object)this.generatedWatermarkGenerator.newInstance(containingTask.getUserCodeClassLoader()));
        WatermarkAssignerOperator operator = new WatermarkAssignerOperator(this.rowtimeFieldIndex, watermarkGenerator, this.idleTimeout);
        operator.setup(containingTask, config, output);
        return operator;
    }

    public void setChainingStrategy(ChainingStrategy strategy) {
        this.strategy = strategy;
    }

    public ChainingStrategy getChainingStrategy() {
        return this.strategy;
    }

    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
        return WatermarkAssignerOperator.class;
    }
}

