/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.JoinedRow;
import org.apache.flink.table.runtime.dataview.PerKeyStateDataViewStore;
import org.apache.flink.table.runtime.functions.KeyedProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.typeutils.BaseRowTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcTimeRangeBoundedPrecedingFunction<K>
extends KeyedProcessFunctionWithCleanupState<K, BaseRow, BaseRow> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ProcTimeRangeBoundedPrecedingFunction.class);
    private final GeneratedAggsHandleFunction genAggsHandler;
    private final LogicalType[] accTypes;
    private final LogicalType[] inputFieldTypes;
    private final long precedingTimeBoundary;
    private transient ValueState<BaseRow> accState;
    private transient MapState<Long, List<BaseRow>> inputState;
    private transient AggsHandleFunction function;
    private transient JoinedRow output;

    public ProcTimeRangeBoundedPrecedingFunction(long minRetentionTime, long maxRetentionTime, GeneratedAggsHandleFunction genAggsHandler, LogicalType[] accTypes, LogicalType[] inputFieldTypes, long precedingTimeBoundary) {
        super(minRetentionTime, maxRetentionTime);
        this.genAggsHandler = genAggsHandler;
        this.accTypes = accTypes;
        this.inputFieldTypes = inputFieldTypes;
        this.precedingTimeBoundary = precedingTimeBoundary;
    }

    public void open(Configuration parameters) throws Exception {
        this.function = (AggsHandleFunction)this.genAggsHandler.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        this.function.open(new PerKeyStateDataViewStore(this.getRuntimeContext()));
        this.output = new JoinedRow();
        BaseRowTypeInfo inputType = new BaseRowTypeInfo(this.inputFieldTypes);
        ListTypeInfo rowListTypeInfo = new ListTypeInfo((TypeInformation)inputType);
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("inputState", (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, (TypeInformation)rowListTypeInfo);
        this.inputState = this.getRuntimeContext().getMapState(mapStateDescriptor);
        BaseRowTypeInfo accTypeInfo = new BaseRowTypeInfo(this.accTypes);
        ValueStateDescriptor stateDescriptor = new ValueStateDescriptor("accState", (TypeInformation)accTypeInfo);
        this.accState = this.getRuntimeContext().getState(stateDescriptor);
        this.initCleanupTimeState("ProcTimeBoundedRangeOverCleanupTime");
    }

    public void processElement(BaseRow input, KeyedProcessFunction.Context ctx, Collector<BaseRow> out) throws Exception {
        long currentTime = ctx.timerService().currentProcessingTime();
        this.registerProcessingCleanupTimer(ctx, currentTime);
        ArrayList<BaseRow> rowList = (ArrayList<BaseRow>)this.inputState.get((Object)currentTime);
        if (rowList == null) {
            rowList = new ArrayList<BaseRow>();
            ctx.timerService().registerProcessingTimeTimer(currentTime + 1L);
        }
        rowList.add(input);
        this.inputState.put((Object)currentTime, rowList);
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<BaseRow> out) throws Exception {
        int iElemenets;
        if (this.needToCleanupState(timestamp).booleanValue()) {
            this.cleanupState(new State[]{this.inputState, this.accState});
            this.function.cleanup();
            return;
        }
        ((TimestampedCollector)out).eraseTimestamp();
        long currentTime = timestamp - 1L;
        List currentElements = (List)this.inputState.get((Object)currentTime);
        if (null == currentElements) {
            return;
        }
        BaseRow accumulators = (BaseRow)this.accState.value();
        if (null == accumulators) {
            accumulators = this.function.createAccumulators();
        }
        this.function.setAccumulators(accumulators);
        long limit = currentTime - this.precedingTimeBoundary;
        Iterator iter = this.inputState.keys().iterator();
        ArrayList<Long> markToRemove = new ArrayList<Long>();
        while (iter.hasNext()) {
            Long elementKey = (Long)iter.next();
            if (elementKey >= limit) continue;
            List elementsRemove = (List)this.inputState.get((Object)elementKey);
            if (elementsRemove != null) {
                for (int iRemove = 0; iRemove < elementsRemove.size(); ++iRemove) {
                    BaseRow retractRow = (BaseRow)elementsRemove.get(iRemove);
                    this.function.retract(retractRow);
                }
            } else {
                LOG.warn("The state is cleared because of state ttl. This will result in incorrect result. You can increase the state ttl to avoid this.");
            }
            markToRemove.add(elementKey);
        }
        for (int i = 0; i < markToRemove.size(); ++i) {
            this.inputState.remove(markToRemove.get(i));
        }
        for (iElemenets = 0; iElemenets < currentElements.size(); ++iElemenets) {
            BaseRow input = (BaseRow)currentElements.get(iElemenets);
            this.function.accumulate(input);
        }
        BaseRow aggValue = this.function.getValue();
        for (iElemenets = 0; iElemenets < currentElements.size(); ++iElemenets) {
            BaseRow input = (BaseRow)currentElements.get(iElemenets);
            this.output.replace(input, aggValue);
            out.collect((Object)this.output);
        }
        accumulators = this.function.getAccumulators();
        this.accState.update((Object)accumulators);
    }

    public void close() throws Exception {
        if (null != this.function) {
            this.function.close();
        }
    }
}

