/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.stream;

import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.util.BaseRowUtil;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.operators.join.stream.AbstractStreamingJoinOperator;
import org.apache.flink.table.runtime.operators.join.stream.state.JoinInputSideSpec;
import org.apache.flink.table.runtime.operators.join.stream.state.JoinRecordStateView;
import org.apache.flink.table.runtime.operators.join.stream.state.JoinRecordStateViews;
import org.apache.flink.table.runtime.operators.join.stream.state.OuterJoinRecordStateView;
import org.apache.flink.table.runtime.operators.join.stream.state.OuterJoinRecordStateViews;
import org.apache.flink.table.runtime.typeutils.BaseRowTypeInfo;

public class StreamingSemiAntiJoinOperator
extends AbstractStreamingJoinOperator {
    private static final long serialVersionUID = -3135772379944924519L;
    private final boolean isAntiJoin;
    private transient OuterJoinRecordStateView leftRecordStateView;
    private transient JoinRecordStateView rightRecordStateView;

    public StreamingSemiAntiJoinOperator(boolean isAntiJoin, BaseRowTypeInfo leftType, BaseRowTypeInfo rightType, GeneratedJoinCondition generatedJoinCondition, JoinInputSideSpec leftInputSideSpec, JoinInputSideSpec rightInputSideSpec, boolean[] filterNullKeys, long minRetentionTime) {
        super(leftType, rightType, generatedJoinCondition, leftInputSideSpec, rightInputSideSpec, filterNullKeys, minRetentionTime);
        this.isAntiJoin = isAntiJoin;
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.leftRecordStateView = OuterJoinRecordStateViews.create((RuntimeContext)this.getRuntimeContext(), "left-records", this.leftInputSideSpec, this.leftType, this.minRetentionTime, this.stateCleaningEnabled);
        this.rightRecordStateView = JoinRecordStateViews.create((RuntimeContext)this.getRuntimeContext(), "right-records", this.rightInputSideSpec, this.rightType, this.minRetentionTime, this.stateCleaningEnabled);
    }

    public void processElement1(StreamRecord<BaseRow> element) throws Exception {
        BaseRow input = (BaseRow)element.getValue();
        AbstractStreamingJoinOperator.AssociatedRecords associatedRecords = AbstractStreamingJoinOperator.AssociatedRecords.of(input, true, this.rightRecordStateView, this.joinCondition);
        if (associatedRecords.isEmpty()) {
            if (this.isAntiJoin) {
                this.collector.collect((Object)input);
            }
        } else if (!this.isAntiJoin) {
            this.collector.collect((Object)input);
        }
        if (BaseRowUtil.isAccumulateMsg(input)) {
            this.leftRecordStateView.addRecord(input, associatedRecords.size());
        } else {
            input.setHeader((byte)0);
            this.leftRecordStateView.retractRecord(input);
        }
    }

    public void processElement2(StreamRecord<BaseRow> element) throws Exception {
        block10: {
            AbstractStreamingJoinOperator.AssociatedRecords associatedRecords;
            BaseRow input;
            block9: {
                input = (BaseRow)element.getValue();
                associatedRecords = AbstractStreamingJoinOperator.AssociatedRecords.of(input, false, this.leftRecordStateView, this.joinCondition);
                if (!BaseRowUtil.isAccumulateMsg(input)) break block9;
                this.rightRecordStateView.addRecord(input);
                if (associatedRecords.isEmpty()) break block10;
                for (AbstractStreamingJoinOperator.OuterRecord outerRecord : associatedRecords.getOuterRecords()) {
                    BaseRow other = outerRecord.record;
                    if (outerRecord.numOfAssociations == 0) {
                        if (this.isAntiJoin) {
                            other.setHeader((byte)1);
                            this.collector.collect((Object)other);
                            other.setHeader((byte)0);
                        } else {
                            this.collector.collect((Object)other);
                        }
                    }
                    this.leftRecordStateView.updateNumOfAssociations(other, outerRecord.numOfAssociations + 1);
                }
                break block10;
            }
            input.setHeader((byte)0);
            this.rightRecordStateView.retractRecord(input);
            if (!associatedRecords.isEmpty()) {
                for (AbstractStreamingJoinOperator.OuterRecord outerRecord : associatedRecords.getOuterRecords()) {
                    BaseRow other = outerRecord.record;
                    if (outerRecord.numOfAssociations == 1) {
                        if (!this.isAntiJoin) {
                            other.setHeader((byte)1);
                            this.collector.collect((Object)other);
                            other.setHeader((byte)0);
                        } else {
                            this.collector.collect((Object)other);
                        }
                    }
                    this.leftRecordStateView.updateNumOfAssociations(other, outerRecord.numOfAssociations - 1);
                }
            }
        }
    }
}

