/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.lookup;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.dataformat.JoinedRow;
import org.apache.flink.table.runtime.collector.TableFunctionCollector;
import org.apache.flink.table.runtime.generated.GeneratedCollector;
import org.apache.flink.table.runtime.generated.GeneratedFunction;
import org.apache.flink.util.Collector;

public class LookupJoinRunner
extends ProcessFunction<BaseRow, BaseRow> {
    private static final long serialVersionUID = -4521543015709964733L;
    private final GeneratedFunction<FlatMapFunction<BaseRow, BaseRow>> generatedFetcher;
    private final GeneratedCollector<TableFunctionCollector<BaseRow>> generatedCollector;
    private final boolean isLeftOuterJoin;
    private final int tableFieldsCount;
    private transient FlatMapFunction<BaseRow, BaseRow> fetcher;
    protected transient TableFunctionCollector<BaseRow> collector;
    private transient GenericRow nullRow;
    private transient JoinedRow outRow;

    public LookupJoinRunner(GeneratedFunction<FlatMapFunction<BaseRow, BaseRow>> generatedFetcher, GeneratedCollector<TableFunctionCollector<BaseRow>> generatedCollector, boolean isLeftOuterJoin, int tableFieldsCount) {
        this.generatedFetcher = generatedFetcher;
        this.generatedCollector = generatedCollector;
        this.isLeftOuterJoin = isLeftOuterJoin;
        this.tableFieldsCount = tableFieldsCount;
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.fetcher = (FlatMapFunction)this.generatedFetcher.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        this.collector = (TableFunctionCollector)((Object)this.generatedCollector.newInstance(this.getRuntimeContext().getUserCodeClassLoader()));
        FunctionUtils.setFunctionRuntimeContext(this.fetcher, (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.setFunctionRuntimeContext(this.collector, (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.openFunction(this.fetcher, (Configuration)parameters);
        FunctionUtils.openFunction(this.collector, (Configuration)parameters);
        this.nullRow = new GenericRow(this.tableFieldsCount);
        this.outRow = new JoinedRow();
    }

    public void processElement(BaseRow in, ProcessFunction.Context ctx, Collector<BaseRow> out) throws Exception {
        this.collector.setCollector(out);
        this.collector.setInput(in);
        this.collector.reset();
        this.fetcher.flatMap((Object)in, this.getFetcherCollector());
        if (this.isLeftOuterJoin && !this.collector.isCollected()) {
            this.outRow.replace(in, this.nullRow);
            this.outRow.setHeader(in.getHeader());
            out.collect((Object)this.outRow);
        }
    }

    public Collector<BaseRow> getFetcherCollector() {
        return this.collector;
    }

    public void close() throws Exception {
        super.close();
        if (this.fetcher != null) {
            FunctionUtils.closeFunction(this.fetcher);
        }
        if (this.collector != null) {
            FunctionUtils.closeFunction(this.collector);
        }
    }
}

