/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join;

import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.streaming.api.functions.co.CoProcessFunction;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.generated.GeneratedFunction;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.TimeBoundedStreamJoin;
import org.apache.flink.table.runtime.typeutils.BaseRowTypeInfo;

public final class RowTimeBoundedStreamJoin
extends TimeBoundedStreamJoin {
    private static final long serialVersionUID = -2923709329817468698L;
    private final int leftTimeIdx;
    private final int rightTimeIdx;

    public RowTimeBoundedStreamJoin(FlinkJoinType joinType, long leftLowerBound, long leftUpperBound, long allowedLateness, BaseRowTypeInfo leftType, BaseRowTypeInfo rightType, GeneratedFunction<FlatJoinFunction<BaseRow, BaseRow, BaseRow>> genJoinFunc, int leftTimeIdx, int rightTimeIdx) {
        super(joinType, leftLowerBound, leftUpperBound, allowedLateness, leftType, rightType, genJoinFunc);
        this.leftTimeIdx = leftTimeIdx;
        this.rightTimeIdx = rightTimeIdx;
    }

    public long getMaxOutputDelay() {
        return Math.max(this.leftRelativeSize, this.rightRelativeSize) + this.allowedLateness;
    }

    @Override
    void updateOperatorTime(CoProcessFunction.Context ctx) {
        this.rightOperatorTime = this.leftOperatorTime = ctx.timerService().currentWatermark() > 0L ? ctx.timerService().currentWatermark() : 0L;
    }

    @Override
    long getTimeForLeftStream(CoProcessFunction.Context ctx, BaseRow row) {
        return row.getLong(this.leftTimeIdx);
    }

    @Override
    long getTimeForRightStream(CoProcessFunction.Context ctx, BaseRow row) {
        return row.getLong(this.rightTimeIdx);
    }

    @Override
    void registerTimer(CoProcessFunction.Context ctx, long cleanupTime) {
        ctx.timerService().registerEventTimeTimer(cleanupTime);
    }
}

