/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate;

import java.util.List;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.runtime.util.MemorySegmentPool;

public class BytesHashMapSpillMemorySegmentPool
implements MemorySegmentPool {
    private final List<MemorySegment> segments;
    private final int pageSize;
    private int allocated;

    public BytesHashMapSpillMemorySegmentPool(List<MemorySegment> memorySegments) {
        this.segments = memorySegments;
        this.pageSize = memorySegments.get(0).size();
        this.allocated = 0;
    }

    public MemorySegment nextSegment() {
        ++this.allocated;
        if (this.allocated <= this.segments.size()) {
            return this.segments.get(this.allocated - 1);
        }
        return MemorySegmentFactory.wrap((byte[])new byte[this.pageSize()]);
    }

    @Override
    public void returnAll(List<MemorySegment> memory) {
        throw new UnsupportedOperationException("not support!");
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }
}

