/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators;

import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.table.runtime.generated.GeneratedClass;

public class CodeGenOperatorFactory<OUT>
implements StreamOperatorFactory<OUT> {
    private final GeneratedClass<? extends StreamOperator<OUT>> generatedClass;
    private ChainingStrategy strategy = ChainingStrategy.ALWAYS;

    public CodeGenOperatorFactory(GeneratedClass<? extends StreamOperator<OUT>> generatedClass) {
        this.generatedClass = generatedClass;
    }

    public <T extends StreamOperator<OUT>> T createStreamOperator(StreamTask<?, ?> containingTask, StreamConfig config, Output<StreamRecord<OUT>> output) {
        return (T)this.generatedClass.newInstance(containingTask.getUserCodeClassLoader(), this.generatedClass.getReferences(), containingTask, config, output);
    }

    public void setChainingStrategy(ChainingStrategy strategy) {
        this.strategy = strategy;
    }

    public ChainingStrategy getChainingStrategy() {
        return this.strategy;
    }

    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
        return this.generatedClass.getClass(classLoader);
    }

    public GeneratedClass<? extends StreamOperator<OUT>> getGeneratedClass() {
        return this.generatedClass;
    }
}

