/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.io;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.ChannelReaderInputView;
import org.apache.flink.runtime.memory.AbstractPagedInputView;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.runtime.typeutils.BinaryRowSerializer;
import org.apache.flink.util.MutableObjectIterator;

public class BinaryRowChannelInputViewIterator
implements MutableObjectIterator<BinaryRow> {
    private final ChannelReaderInputView inView;
    private final BinaryRowSerializer serializer;
    private final List<MemorySegment> freeMemTarget;

    public BinaryRowChannelInputViewIterator(ChannelReaderInputView inView, BinaryRowSerializer serializer) {
        this(inView, new ArrayList<MemorySegment>(), serializer);
    }

    public BinaryRowChannelInputViewIterator(ChannelReaderInputView inView, List<MemorySegment> freeMemTarget, BinaryRowSerializer serializer) {
        this.inView = inView;
        this.freeMemTarget = freeMemTarget;
        this.serializer = serializer;
    }

    public BinaryRow next(BinaryRow reuse) throws IOException {
        try {
            return this.serializer.deserializeFromPages(reuse, (AbstractPagedInputView)this.inView);
        }
        catch (EOFException eofex) {
            List freeMem = this.inView.close();
            if (this.freeMemTarget != null) {
                this.freeMemTarget.addAll(freeMem);
            }
            return null;
        }
    }

    public BinaryRow next() throws IOException {
        throw new UnsupportedOperationException("This method is disabled due to performance issue!");
    }
}

