/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.hashtable;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentSource;
import org.apache.flink.core.memory.SeekableDataInputView;
import org.apache.flink.runtime.io.compression.BlockCompressionFactory;
import org.apache.flink.runtime.io.disk.RandomAccessInputView;
import org.apache.flink.runtime.io.disk.iomanager.AbstractChannelWriterOutputView;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelWriter;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.memory.AbstractPagedInputView;
import org.apache.flink.runtime.memory.AbstractPagedOutputView;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.runtime.hashtable.BinaryHashBucketArea;
import org.apache.flink.table.runtime.hashtable.HashTableBloomFilter;
import org.apache.flink.table.runtime.typeutils.BinaryRowSerializer;
import org.apache.flink.table.runtime.util.FileChannelUtil;
import org.apache.flink.table.runtime.util.MemorySegmentPool;
import org.apache.flink.table.runtime.util.RowIterator;
import org.apache.flink.util.MathUtils;

public class BinaryHashPartition
extends AbstractPagedInputView
implements SeekableDataInputView {
    private final BinaryRowSerializer buildSideSerializer;
    private final BinaryRowSerializer probeSideSerializer;
    private final int segmentSizeBits;
    private boolean compressionEnable;
    private BlockCompressionFactory compressionCodecFactory;
    private int compressionBlockSize;
    private final int memorySegmentSize;
    final int partitionNumber;
    long probeSideRecordCounter;
    private MemorySegment[] partitionBuffers;
    private int currentBufferNum;
    private int finalBufferLimit;
    private BuildSideBuffer buildSideWriteBuffer;
    AbstractChannelWriterOutputView probeSideBuffer;
    private long buildSideRecordCounter;
    private int recursionLevel;
    private BlockChannelWriter<MemorySegment> buildSideChannel;
    BinaryHashBucketArea bucketArea;
    HashTableBloomFilter bloomFilter;
    private MemorySegmentPool memPool;
    int probeNumBytesInLastSeg;

    BinaryHashPartition(BinaryHashBucketArea bucketArea, BinaryRowSerializer buildSideAccessors, BinaryRowSerializer probeSideAccessors, int partitionNumber, int recursionLevel, MemorySegment initialBuffer, MemorySegmentPool memPool, int segmentSize, boolean compressionEnable, BlockCompressionFactory compressionCodecFactory, int compressionBlockSize) {
        super(0);
        this.bucketArea = bucketArea;
        this.buildSideSerializer = buildSideAccessors;
        this.probeSideSerializer = probeSideAccessors;
        this.partitionNumber = partitionNumber;
        this.recursionLevel = recursionLevel;
        this.memorySegmentSize = segmentSize;
        this.segmentSizeBits = MathUtils.log2strict((int)segmentSize);
        this.compressionEnable = compressionEnable;
        this.compressionCodecFactory = compressionCodecFactory;
        this.compressionBlockSize = compressionBlockSize;
        this.buildSideWriteBuffer = new BuildSideBuffer(initialBuffer, memPool);
        this.memPool = memPool;
    }

    BinaryHashPartition(BinaryHashBucketArea area, BinaryRowSerializer buildSideAccessors, BinaryRowSerializer probeSideAccessors, int partitionNumber, int recursionLevel, List<MemorySegment> buffers, long buildSideRecordCounter, int segmentSize, int lastSegmentLimit) {
        super(0);
        this.buildSideSerializer = buildSideAccessors;
        this.probeSideSerializer = probeSideAccessors;
        this.partitionNumber = partitionNumber;
        this.recursionLevel = recursionLevel;
        this.memorySegmentSize = segmentSize;
        this.segmentSizeBits = MathUtils.log2strict((int)segmentSize);
        this.finalBufferLimit = lastSegmentLimit;
        this.partitionBuffers = buffers.toArray(new MemorySegment[buffers.size()]);
        this.buildSideRecordCounter = buildSideRecordCounter;
        this.bucketArea = area;
    }

    int getPartitionNumber() {
        return this.partitionNumber;
    }

    int getRecursionLevel() {
        return this.recursionLevel;
    }

    final boolean isInMemory() {
        return this.buildSideChannel == null;
    }

    int getNumOccupiedMemorySegments() {
        int numPartitionBuffers = this.partitionBuffers != null ? this.partitionBuffers.length : this.buildSideWriteBuffer.getNumOccupiedMemorySegments();
        return numPartitionBuffers + this.bucketArea.buckets.length + this.bucketArea.numOverflowSegments;
    }

    int getBuildSideBlockCount() {
        return this.partitionBuffers == null ? this.buildSideWriteBuffer.getBlockCount() : this.partitionBuffers.length;
    }

    RandomAccessInputView getBuildStateInputView() {
        return this.buildSideWriteBuffer.getBuildStageInputView();
    }

    int getProbeSideBlockCount() {
        return this.probeSideBuffer == null ? -1 : this.probeSideBuffer.getBlockCount();
    }

    long getBuildSideRecordCount() {
        return this.buildSideRecordCounter;
    }

    BlockChannelWriter<MemorySegment> getBuildSideChannel() {
        return this.buildSideChannel;
    }

    boolean testHashBloomFilter(int hash) {
        return this.bloomFilter == null || this.bloomFilter.testHash(hash);
    }

    private void freeBloomFilter() {
        this.memPool.returnAll(Arrays.asList(this.bloomFilter.getBuffers()));
        this.bloomFilter = null;
    }

    void addHashBloomFilter(int hash) {
        if (this.bloomFilter != null && !this.bloomFilter.addHash(hash)) {
            this.freeBloomFilter();
        }
    }

    final int insertIntoBuildBuffer(BinaryRow record) throws IOException {
        ++this.buildSideRecordCounter;
        if (this.isInMemory()) {
            long pointer = this.buildSideWriteBuffer.getCurrentPointer();
            int skip = this.buildSideSerializer.serializeToPages(record, (AbstractPagedOutputView)this.buildSideWriteBuffer);
            if (this.isInMemory()) {
                long ret = pointer + (long)skip;
                if (ret > Integer.MAX_VALUE) {
                    throw new RuntimeException("Too more data in this partition: " + ret);
                }
                return (int)ret;
            }
            return -1;
        }
        this.buildSideSerializer.serializeToPages(record, (AbstractPagedOutputView)this.buildSideWriteBuffer);
        return -1;
    }

    final void insertIntoProbeBuffer(BinaryRow record) throws IOException {
        this.probeSideSerializer.serialize(record, (DataOutputView)this.probeSideBuffer);
        ++this.probeSideRecordCounter;
    }

    int spillPartition(IOManager ioAccess, FileIOChannel.ID targetChannel, LinkedBlockingQueue<MemorySegment> bufferReturnQueue) throws IOException {
        if (!this.isInMemory()) {
            throw new RuntimeException("Bug in Hybrid Hash Join: Request to spill a partition that has already been spilled.");
        }
        if (this.getNumOccupiedMemorySegments() < 2) {
            throw new RuntimeException("Bug in Hybrid Hash Join: Request to spill a partition with less than two buffers.");
        }
        this.buildSideChannel = FileChannelUtil.createBlockChannelWriter(ioAccess, targetChannel, bufferReturnQueue, this.compressionEnable, this.compressionCodecFactory, this.compressionBlockSize, this.memorySegmentSize);
        return this.buildSideWriteBuffer.spill(this.buildSideChannel);
    }

    void buildBloomFilterAndFreeBucket() {
        if (this.bucketArea != null) {
            this.bucketArea.buildBloomFilterAndFree();
            this.bucketArea = null;
        }
    }

    int finalizeBuildPhase(IOManager ioAccess, FileIOChannel.Enumerator probeChannelEnumerator) throws IOException {
        this.finalBufferLimit = this.buildSideWriteBuffer.getCurrentPositionInSegment();
        this.partitionBuffers = this.buildSideWriteBuffer.close();
        if (!this.isInMemory()) {
            this.buildSideChannel.close();
            this.probeSideBuffer = FileChannelUtil.createOutputView(ioAccess, probeChannelEnumerator.next(), this.compressionEnable, this.compressionCodecFactory, this.compressionBlockSize, this.memorySegmentSize);
            return 1;
        }
        return 0;
    }

    void finalizeProbePhase(List<MemorySegment> freeMemory, List<BinaryHashPartition> spilledPartitions, boolean keepUnprobedSpilledPartitions) throws IOException {
        if (this.isInMemory()) {
            this.bucketArea.returnMemory(freeMemory);
            this.bucketArea = null;
            Collections.addAll(freeMemory, this.partitionBuffers);
            this.partitionBuffers = null;
        } else {
            if (this.bloomFilter != null) {
                this.freeBloomFilter();
            }
            if (this.probeSideRecordCounter == 0L && !keepUnprobedSpilledPartitions) {
                this.probeSideBuffer.close();
                this.buildSideChannel.deleteChannel();
                this.probeSideBuffer.getChannel().deleteChannel();
            } else {
                this.probeNumBytesInLastSeg = this.probeSideBuffer.close();
                spilledPartitions.add(this);
            }
        }
    }

    void clearAllMemory(List<MemorySegment> target) {
        if (this.buildSideWriteBuffer != null) {
            if (this.buildSideWriteBuffer.getCurrentSegment() != null) {
                target.add(this.buildSideWriteBuffer.getCurrentSegment());
            }
            target.addAll(this.buildSideWriteBuffer.targetList);
            this.buildSideWriteBuffer.targetList.clear();
            this.buildSideWriteBuffer = null;
        }
        if (this.bucketArea != null) {
            this.bucketArea.returnMemory(target);
        }
        if (this.bloomFilter != null) {
            this.freeBloomFilter();
        }
        if (this.partitionBuffers != null) {
            Collections.addAll(target, this.partitionBuffers);
            this.partitionBuffers = null;
        }
        try {
            if (this.buildSideChannel != null) {
                this.buildSideChannel.close();
                this.buildSideChannel.deleteChannel();
            }
            if (this.probeSideBuffer != null) {
                this.probeSideBuffer.close();
                this.probeSideBuffer.getChannel().deleteChannel();
                this.probeSideBuffer = null;
            }
        }
        catch (IOException ioex) {
            throw new RuntimeException("Error deleting the partition files. Some temporary files might not be removed.", ioex);
        }
    }

    final PartitionIterator newPartitionIterator() {
        return new PartitionIterator();
    }

    final int getLastSegmentLimit() {
        return this.finalBufferLimit;
    }

    public void setReadPosition(long pointer) {
        int bufferNum = (int)(pointer >>> this.segmentSizeBits);
        int offset = (int)(pointer & (long)(this.memorySegmentSize - 1));
        this.currentBufferNum = bufferNum;
        this.seekInput(this.partitionBuffers[bufferNum], offset, bufferNum < this.partitionBuffers.length - 1 ? this.memorySegmentSize : this.finalBufferLimit);
    }

    protected MemorySegment nextSegment(MemorySegment current) throws IOException {
        ++this.currentBufferNum;
        if (this.currentBufferNum < this.partitionBuffers.length) {
            return this.partitionBuffers[this.currentBufferNum];
        }
        throw new EOFException();
    }

    protected int getLimitForSegment(MemorySegment segment) {
        return segment == this.partitionBuffers[this.partitionBuffers.length - 1] ? this.finalBufferLimit : this.memorySegmentSize;
    }

    final class PartitionIterator
    implements RowIterator<BinaryRow> {
        private long currentPointer;
        private BinaryRow reuse;

        private PartitionIterator() {
            this.reuse = BinaryHashPartition.this.buildSideSerializer.createInstance();
            BinaryHashPartition.this.setReadPosition(0L);
        }

        @Override
        public boolean advanceNext() {
            int pos = BinaryHashPartition.this.getCurrentPositionInSegment();
            int buffer = BinaryHashPartition.this.currentBufferNum;
            this.currentPointer = ((long)buffer << BinaryHashPartition.this.segmentSizeBits) + (long)pos;
            try {
                this.reuse = BinaryHashPartition.this.buildSideSerializer.mapFromPages(this.reuse, (AbstractPagedInputView)BinaryHashPartition.this);
                return true;
            }
            catch (EOFException e) {
                return false;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        final long getPointer() {
            return this.currentPointer;
        }

        @Override
        public BinaryRow getRow() {
            return this.reuse;
        }
    }

    protected static final class BuildSideBuffer
    extends AbstractPagedOutputView {
        private final ArrayList<MemorySegment> targetList;
        private final ArrayList<MemorySegment> buildStageSegments;
        private final RandomAccessInputView buildStageInputView;
        private final MemorySegmentSource memSource;
        private final int sizeBits;
        private BlockChannelWriter<MemorySegment> writer;
        private int currentBlockNumber;

        private BuildSideBuffer(MemorySegment initialSegment, MemorySegmentSource memSource) {
            super(initialSegment, initialSegment.size(), 0);
            this.memSource = memSource;
            this.sizeBits = MathUtils.log2strict((int)initialSegment.size());
            this.targetList = new ArrayList();
            this.buildStageSegments = new ArrayList();
            this.buildStageSegments.add(initialSegment);
            this.buildStageInputView = new RandomAccessInputView(this.buildStageSegments, initialSegment.size());
        }

        protected MemorySegment nextSegment(MemorySegment current, int bytesUsed) throws IOException {
            MemorySegment next;
            if (this.writer == null) {
                this.targetList.add(current);
                next = this.memSource.nextSegment();
                this.buildStageSegments.add(next);
            } else {
                this.writer.writeBlock((Object)current);
                try {
                    next = (MemorySegment)this.writer.getReturnQueue().take();
                }
                catch (InterruptedException iex) {
                    throw new IOException("Hash Join Partition was interrupted while grabbing a new write-behind buffer.");
                }
            }
            ++this.currentBlockNumber;
            return next;
        }

        RandomAccessInputView getBuildStageInputView() {
            return this.buildStageInputView;
        }

        long getCurrentPointer() {
            return ((long)this.currentBlockNumber << this.sizeBits) + (long)this.getCurrentPositionInSegment();
        }

        int getBlockCount() {
            return this.currentBlockNumber + 1;
        }

        int getNumOccupiedMemorySegments() {
            return this.targetList.size() + 1;
        }

        int spill(BlockChannelWriter<MemorySegment> writer) throws IOException {
            this.writer = writer;
            int numSegments = this.targetList.size();
            for (MemorySegment segment : this.targetList) {
                this.writer.writeBlock((Object)segment);
            }
            this.targetList.clear();
            return numSegments;
        }

        MemorySegment[] close() throws IOException {
            MemorySegment current = this.getCurrentSegment();
            if (current == null) {
                throw new IllegalStateException("Illegal State in HashPartition: No current buffer when finalizing build side.");
            }
            this.clear();
            if (this.writer == null) {
                this.targetList.add(current);
                MemorySegment[] buffers = this.targetList.toArray(new MemorySegment[this.targetList.size()]);
                this.targetList.clear();
                this.buildStageSegments.clear();
                return buffers;
            }
            this.writer.writeBlock((Object)current);
            return null;
        }
    }
}

