/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.runtime.util.SegmentsUtil;

public class SqlLikeChainChecker {
    private final int minLen;
    private final BinaryString beginPattern;
    private final BinaryString endPattern;
    private final BinaryString[] middlePatterns;
    private final int[] midLens;
    private final int beginLen;
    private final int endLen;

    public SqlLikeChainChecker(String pattern) {
        StringTokenizer tokens = new StringTokenizer(pattern, "%");
        boolean leftAnchor = !pattern.startsWith("%");
        boolean rightAnchor = !pattern.endsWith("%");
        int len = 0;
        BinaryString leftPattern = null;
        BinaryString rightPattern = null;
        int leftLen = 0;
        int rightLen = 0;
        ArrayList<BinaryString> middleCheckers = new ArrayList<BinaryString>(2);
        ArrayList<Integer> lengths = new ArrayList<Integer>(2);
        int i = 0;
        while (tokens.hasMoreTokens()) {
            String chunk = tokens.nextToken();
            if (chunk.length() != 0) {
                len += SqlLikeChainChecker.utf8Length(chunk);
                if (leftAnchor && i == 0) {
                    leftPattern = BinaryString.fromString(chunk);
                    leftLen = SqlLikeChainChecker.utf8Length(chunk);
                } else if (rightAnchor && !tokens.hasMoreTokens()) {
                    rightPattern = BinaryString.fromString(chunk);
                    rightLen = SqlLikeChainChecker.utf8Length(chunk);
                } else {
                    middleCheckers.add(BinaryString.fromString(chunk));
                    lengths.add(SqlLikeChainChecker.utf8Length(chunk));
                }
            }
            ++i;
        }
        this.midLens = ArrayUtils.toPrimitive((Integer[])lengths.toArray(ArrayUtils.EMPTY_INTEGER_OBJECT_ARRAY));
        this.middlePatterns = middleCheckers.toArray(new BinaryString[0]);
        this.minLen = len;
        this.beginPattern = leftPattern;
        this.endPattern = rightPattern;
        this.beginLen = leftLen;
        this.endLen = rightLen;
    }

    public boolean check(BinaryString str) {
        MemorySegment[] segments = str.getSegments();
        int pos = str.getOffset();
        int mark = str.getSizeInBytes();
        if (str.getSizeInBytes() < this.minLen) {
            return false;
        }
        if (this.beginPattern != null && !SqlLikeChainChecker.checkBegin(this.beginPattern, segments, pos, mark)) {
            return false;
        }
        if (this.endPattern != null && !SqlLikeChainChecker.checkEnd(this.endPattern, segments, pos += this.beginLen, mark -= this.beginLen)) {
            return false;
        }
        mark -= this.endLen;
        for (int i = 0; i < this.middlePatterns.length; ++i) {
            int index = SqlLikeChainChecker.indexMiddle(this.middlePatterns[i], segments, pos, mark);
            if (index == -1) {
                return false;
            }
            mark -= index - pos + this.midLens[i];
            pos = index + this.midLens[i];
        }
        return true;
    }

    private static int utf8Length(String chunk) {
        return BinaryString.fromString(chunk).getSizeInBytes();
    }

    private static boolean checkBegin(BinaryString pattern, MemorySegment[] segments, int start, int len) {
        int lenSub = pattern.getSizeInBytes();
        return len >= lenSub && SegmentsUtil.equals(pattern.getSegments(), 0, segments, start, lenSub);
    }

    private static boolean checkEnd(BinaryString pattern, MemorySegment[] segments, int start, int len) {
        int lenSub = pattern.getSizeInBytes();
        return len >= lenSub && SegmentsUtil.equals(pattern.getSegments(), 0, segments, start + len - lenSub, lenSub);
    }

    private static int indexMiddle(BinaryString pattern, MemorySegment[] segments, int start, int len) {
        return SegmentsUtil.find(segments, start, len, pattern.getSegments(), pattern.getOffset(), pattern.getSizeInBytes());
    }
}

