/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.dataformat.BaseMap;
import org.apache.flink.table.dataformat.BinaryArray;
import org.apache.flink.table.dataformat.BinarySection;
import org.apache.flink.table.runtime.types.ClassLogicalTypeConverter;
import org.apache.flink.table.runtime.util.SegmentsUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Preconditions;

public final class BinaryMap
extends BinarySection
implements BaseMap {
    private final BinaryArray keys = new BinaryArray();
    private final BinaryArray values = new BinaryArray();

    @Override
    public int numElements() {
        return this.keys.numElements();
    }

    @Override
    public void pointTo(MemorySegment[] segments, int offset, int sizeInBytes) {
        int keyArrayBytes = SegmentsUtil.getInt(segments, offset);
        assert (keyArrayBytes >= 0) : "keyArraySize (" + keyArrayBytes + ") should >= 0";
        int valueArrayBytes = sizeInBytes - keyArrayBytes - 4;
        assert (valueArrayBytes >= 0) : "valueArraySize (" + valueArrayBytes + ") should >= 0";
        this.keys.pointTo(segments, offset + 4, keyArrayBytes);
        this.values.pointTo(segments, offset + 4 + keyArrayBytes, valueArrayBytes);
        assert (this.keys.numElements() == this.values.numElements());
        this.segments = segments;
        this.offset = offset;
        this.sizeInBytes = sizeInBytes;
    }

    public BinaryArray keyArray() {
        return this.keys;
    }

    public BinaryArray valueArray() {
        return this.values;
    }

    @Override
    public Map<Object, Object> toJavaMap(LogicalType keyType, LogicalType valueType) {
        T[] keyArray = this.keys.toClassArray(keyType, ClassLogicalTypeConverter.getInternalClassForType(keyType));
        T[] valueArray = this.values.toClassArray(valueType, ClassLogicalTypeConverter.getInternalClassForType(valueType));
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < keyArray.length; ++i) {
            map.put(keyArray[i], valueArray[i]);
        }
        return map;
    }

    public BinaryMap copy() {
        return this.copy(new BinaryMap());
    }

    public BinaryMap copy(BinaryMap reuse) {
        byte[] bytes = SegmentsUtil.copyToBytes(this.segments, this.offset, this.sizeInBytes);
        reuse.pointTo(MemorySegmentFactory.wrap((byte[])bytes), 0, this.sizeInBytes);
        return reuse;
    }

    @Override
    public int hashCode() {
        return SegmentsUtil.hashByWords(this.segments, this.offset, this.sizeInBytes);
    }

    public static BinaryMap valueOf(BinaryArray key, BinaryArray value) {
        Preconditions.checkArgument((key.segments.length == 1 && value.getSegments().length == 1 ? 1 : 0) != 0);
        byte[] bytes = new byte[4 + key.sizeInBytes + value.sizeInBytes];
        MemorySegment segment = MemorySegmentFactory.wrap((byte[])bytes);
        segment.putInt(0, key.sizeInBytes);
        key.getSegments()[0].copyTo(key.getOffset(), segment, 4, key.sizeInBytes);
        value.getSegments()[0].copyTo(value.getOffset(), segment, 4 + key.sizeInBytes, value.sizeInBytes);
        BinaryMap map = new BinaryMap();
        map.pointTo(segment, 0, bytes.length);
        return map;
    }

    public static BinaryMap readBinaryMapFieldFromSegments(MemorySegment[] segments, int baseOffset, long offsetAndSize) {
        int size = (int)offsetAndSize;
        int offset = (int)(offsetAndSize >> 32);
        BinaryMap map = new BinaryMap();
        map.pointTo(segments, offset + baseOffset, size);
        return map;
    }
}

