/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical.utils;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.utils.TypeConversions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class LogicalTypeChecksTest {
    @Test
    public void testHasNested() {
        DataType dataType = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING())});
        Assert.assertThat((Object)LogicalTypeChecks.hasNested((LogicalType)dataType.getLogicalType(), t -> LogicalTypeChecks.hasRoot((LogicalType)t, (LogicalTypeRoot)LogicalTypeRoot.VARCHAR)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)LogicalTypeChecks.hasNested((LogicalType)dataType.getLogicalType(), t -> LogicalTypeChecks.hasRoot((LogicalType)t, (LogicalTypeRoot)LogicalTypeRoot.ROW)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)LogicalTypeChecks.hasNested((LogicalType)dataType.getLogicalType(), t -> LogicalTypeChecks.hasRoot((LogicalType)t, (LogicalTypeRoot)LogicalTypeRoot.BOOLEAN)), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testIsCompositeTypeRowType() {
        DataType dataType = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING())});
        boolean isCompositeType = LogicalTypeChecks.isCompositeType((LogicalType)dataType.getLogicalType());
        Assert.assertThat((Object)isCompositeType, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testIsCompositeTypeDistinctType() {
        DataType dataType = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING())});
        DistinctType distinctType = DistinctType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"catalog", (String)"database", (String)"type"), (LogicalType)dataType.getLogicalType()).build();
        boolean isCompositeType = LogicalTypeChecks.isCompositeType((LogicalType)distinctType);
        Assert.assertThat((Object)isCompositeType, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testIsCompositeTypeLegacyCompositeType() {
        DataType dataType = TypeConversions.fromLegacyInfoToDataType((TypeInformation)new RowTypeInfo(new TypeInformation[]{Types.STRING, Types.INT}));
        boolean isCompositeType = LogicalTypeChecks.isCompositeType((LogicalType)dataType.getLogicalType());
        Assert.assertThat((Object)isCompositeType, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testIsCompositeTypeStructuredType() {
        StructuredType logicalType = StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"catalog", (String)"database", (String)"type")).attributes(Arrays.asList(new StructuredType.StructuredAttribute("f0", DataTypes.INT().getLogicalType()), new StructuredType.StructuredAttribute("f1", DataTypes.STRING().getLogicalType()))).build();
        List<DataType> fieldDataTypes = Arrays.asList(DataTypes.INT(), DataTypes.STRING());
        FieldsDataType dataType = new FieldsDataType((LogicalType)logicalType, fieldDataTypes);
        boolean isCompositeType = LogicalTypeChecks.isCompositeType((LogicalType)dataType.getLogicalType());
        Assert.assertThat((Object)isCompositeType, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testIsCompositeTypeLegacySimpleType() {
        DataType dataType = TypeConversions.fromLegacyInfoToDataType((TypeInformation)Types.STRING);
        boolean isCompositeType = LogicalTypeChecks.isCompositeType((LogicalType)dataType.getLogicalType());
        Assert.assertThat((Object)isCompositeType, (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testIsCompositeTypeSimpleType() {
        DataType dataType = DataTypes.TIMESTAMP();
        boolean isCompositeType = LogicalTypeChecks.isCompositeType((LogicalType)dataType.getLogicalType());
        Assert.assertThat((Object)isCompositeType, (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testFieldNameExtraction() {
        DataType dataType = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING())});
        Assert.assertThat((Object)LogicalTypeChecks.getFieldNames((LogicalType)dataType.getLogicalType()), (Matcher)CoreMatchers.is(Arrays.asList("f0", "f1")));
    }

    @Test
    public void testFieldCountExtraction() {
        DataType dataType = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING())});
        Assert.assertThat((Object)LogicalTypeChecks.getFieldCount((LogicalType)dataType.getLogicalType()), (Matcher)CoreMatchers.is((Object)2));
    }
}

