/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.types.LogicalTypesTest;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.TypeInformationRawType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.YearMonthIntervalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LogicalTypeCastsTest {
    @Parameterized.Parameter
    public LogicalType sourceType;
    @Parameterized.Parameter(value=1)
    public LogicalType targetType;
    @Parameterized.Parameter(value=2)
    public boolean supportsImplicit;
    @Parameterized.Parameter(value=3)
    public boolean supportsExplicit;

    @Parameterized.Parameters(name="{index}: [From: {0}, To: {1}, Implicit: {2}, Explicit: {3}]")
    public static List<Object[]> testData() {
        return Arrays.asList({new SmallIntType(), new BigIntType(), true, true}, {new SmallIntType(false), new SmallIntType(), true, true}, {new SmallIntType(), new SmallIntType(false), false, true}, {new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.YEAR), new SmallIntType(), true, true}, {new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.YEAR_TO_MONTH), new SmallIntType(), false, false}, {new IntType(), new DecimalType(5, 5), true, true}, {new FloatType(), new IntType(), false, true}, {new VarCharType(Integer.MAX_VALUE), new FloatType(), false, true}, {new FloatType(), new VarCharType(Integer.MAX_VALUE), false, true}, {new DecimalType(3, 2), new VarCharType(Integer.MAX_VALUE), false, true}, {new TypeInformationRawType(Types.GENERIC(LogicalTypesTest.class)), new TypeInformationRawType(Types.GENERIC(LogicalTypesTest.class)), true, true}, {new TypeInformationRawType(Types.GENERIC(LogicalTypesTest.class)), new TypeInformationRawType(Types.GENERIC(Object.class)), false, false}, {new NullType(), new IntType(), true, true}, {new NullType(), new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new IntType()))), true, true}, {new ArrayType((LogicalType)new IntType()), new ArrayType((LogicalType)new BigIntType()), true, true}, {new ArrayType((LogicalType)new IntType()), new ArrayType((LogicalType)new VarCharType(Integer.MAX_VALUE)), false, true}, {new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new IntType()))), new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new BigIntType()))), true, true}, {new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType(), "description"), new RowType.RowField("f2", (LogicalType)new IntType()))), new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new BigIntType()))), true, true}, {new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new IntType()))), new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new BooleanType()))), false, true}, {new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new IntType()))), new VarCharType(Integer.MAX_VALUE), false, false}, {new TimestampType(9), new TimestampType(9), true, true}, {new LocalZonedTimestampType(9), new LocalZonedTimestampType(9), true, true}, {new TimestampType(3), new LocalZonedTimestampType(3), true, true}, {new LocalZonedTimestampType(3), new TimestampType(3), true, true}, {new TimestampType(3), new LocalZonedTimestampType(6), true, true}, {new LocalZonedTimestampType(3), new TimestampType(6), true, true}, {new TimestampType(false, 3), new LocalZonedTimestampType(6), true, true}, {new LocalZonedTimestampType(false, 3), new TimestampType(6), true, true}, {new TimestampType(6), new LocalZonedTimestampType(3), true, true}, {new LocalZonedTimestampType(6), new TimestampType(3), true, true}, {new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new TimestampType()), new RowType.RowField("f2", (LogicalType)new IntType()))), StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)"User")).attributes(Arrays.asList(new StructuredType.StructuredAttribute("f1", (LogicalType)new TimestampType()), new StructuredType.StructuredAttribute("f2", (LogicalType)new IntType()))).build(), true, true}, {new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new TimestampType()), new RowType.RowField("f2", (LogicalType)new IntType()))), StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)"User")).attributes(Arrays.asList(new StructuredType.StructuredAttribute("f1", (LogicalType)new TimestampType()), new StructuredType.StructuredAttribute("diff", (LogicalType)new IntType()))).build(), true, true}, {new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new TimestampType()), new RowType.RowField("f2", (LogicalType)new IntType()))), StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)"User")).attributes(Arrays.asList(new StructuredType.StructuredAttribute("f1", (LogicalType)new TimestampType()), new StructuredType.StructuredAttribute("diff", (LogicalType)new TinyIntType()))).build(), false, true});
    }

    @Test
    public void testImplicitCasting() {
        Assert.assertThat((Object)LogicalTypeCasts.supportsImplicitCast((LogicalType)this.sourceType, (LogicalType)this.targetType), (Matcher)CoreMatchers.equalTo((Object)this.supportsImplicit));
    }

    @Test
    public void testExplicitCasting() {
        Assert.assertThat((Object)LogicalTypeCasts.supportsExplicitCast((LogicalType)this.sourceType, (LogicalType)this.targetType), (Matcher)CoreMatchers.equalTo((Object)this.supportsExplicit));
    }
}

