/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.operations.CatalogSinkModifyOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.CreateOperation;
import org.apache.flink.table.operations.ddl.CreateTableOperation;

@Internal
public class CreateTableASOperation
implements CreateOperation {
    private final CreateTableOperation createTableOperation;
    private final CatalogSinkModifyOperation insertOperation;

    public CreateTableASOperation(CreateTableOperation createTableOperation, CatalogSinkModifyOperation insertOperation) {
        this.createTableOperation = createTableOperation;
        this.insertOperation = insertOperation;
    }

    public CreateTableOperation getCreateTableOperation() {
        return this.createTableOperation;
    }

    public CatalogSinkModifyOperation getInsertOperation() {
        return this.insertOperation;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("catalogTable", this.getCreateTableOperation().getCatalogTable().toProperties());
        params.put("identifier", this.getCreateTableOperation().getTableIdentifier());
        params.put("ignoreIfExists", this.getCreateTableOperation().isIgnoreIfExists());
        params.put("isTemporary", this.getCreateTableOperation().isTemporary());
        return OperationUtils.formatWithChildren("CREATE TABLE AS", params, Collections.singletonList(this.getInsertOperation().getChild()), Operation::asSummaryString);
    }
}

