/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.flink.table.catalog.FunctionLanguage;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.CreateOperation;

public class CreateTempSystemFunctionOperation
implements CreateOperation {
    private final String functionName;
    private String functionClass;
    private boolean ignoreIfExists;
    private FunctionLanguage functionLanguage;

    public CreateTempSystemFunctionOperation(String functionName, String functionClass, boolean ignoreIfExists, FunctionLanguage functionLanguage) {
        this.functionName = functionName;
        this.functionClass = functionClass;
        this.ignoreIfExists = ignoreIfExists;
        this.functionLanguage = functionLanguage;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getFunctionClass() {
        return this.functionClass;
    }

    public boolean isIgnoreIfExists() {
        return this.ignoreIfExists;
    }

    public FunctionLanguage getFunctionLanguage() {
        return this.functionLanguage;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("functionName", this.functionName);
        params.put("functionClass", this.functionClass);
        params.put("ignoreIfExists", this.ignoreIfExists);
        params.put("functionLanguage", this.functionLanguage);
        return OperationUtils.formatWithChildren("CREATE TEMPORARY SYSTEM FUNCTION", params, Collections.emptyList(), Operation::asSummaryString);
    }
}

