/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Objects;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.util.Preconditions;

@Internal
public final class VaryingStringTypeStrategy
implements TypeStrategy {
    private final TypeStrategy initialStrategy;

    public VaryingStringTypeStrategy(TypeStrategy initialStrategy) {
        this.initialStrategy = (TypeStrategy)Preconditions.checkNotNull((Object)initialStrategy);
    }

    @Override
    public Optional<DataType> inferType(CallContext callContext) {
        return this.initialStrategy.inferType(callContext).map(inferredDataType -> {
            LogicalType inferredType = inferredDataType.getLogicalType();
            switch (inferredType.getTypeRoot()) {
                case CHAR: {
                    int length = LogicalTypeChecks.getLength(inferredType);
                    VarCharType varyingType = length == 0 ? VarCharType.ofEmptyLiteral() : new VarCharType(inferredType.isNullable(), length);
                    return DataTypeUtils.replaceLogicalType(inferredDataType, varyingType);
                }
                case BINARY: {
                    int length = LogicalTypeChecks.getLength(inferredType);
                    VarBinaryType varyingType = length == 0 ? VarBinaryType.ofEmptyLiteral() : new VarBinaryType(inferredType.isNullable(), length);
                    return DataTypeUtils.replaceLogicalType(inferredDataType, varyingType);
                }
            }
            return inferredDataType;
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VaryingStringTypeStrategy that = (VaryingStringTypeStrategy)o;
        return this.initialStrategy.equals(that.initialStrategy);
    }

    public int hashCode() {
        return Objects.hash(this.initialStrategy);
    }
}

