/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories.datagen.types;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.streaming.api.functions.source.datagen.DataGenerator;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;

@Internal
public class RowDataGenerator
implements DataGenerator<RowData> {
    private static final long serialVersionUID = 1L;
    private final DataGenerator<?>[] fieldGenerators;
    private final String[] fieldNames;

    public RowDataGenerator(DataGenerator<?>[] fieldGenerators, String[] fieldNames) {
        this.fieldGenerators = fieldGenerators;
        this.fieldNames = fieldNames;
    }

    public void open(String name, FunctionInitializationContext context, RuntimeContext runtimeContext) throws Exception {
        for (int i = 0; i < this.fieldGenerators.length; ++i) {
            this.fieldGenerators[i].open(this.fieldNames[i], context, runtimeContext);
        }
    }

    public void snapshotState(FunctionSnapshotContext context) throws Exception {
        for (DataGenerator<?> generator : this.fieldGenerators) {
            generator.snapshotState(context);
        }
    }

    public boolean hasNext() {
        for (DataGenerator<?> generator : this.fieldGenerators) {
            if (generator.hasNext()) continue;
            return false;
        }
        return true;
    }

    public RowData next() {
        GenericRowData row = new GenericRowData(this.fieldNames.length);
        for (int i = 0; i < this.fieldGenerators.length; ++i) {
            row.setField(i, this.fieldGenerators[i].next());
        }
        return row;
    }
}

