/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.util;

import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.logging.Log;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.logging.LogFactory;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class NativeCodeLoader {
    private static final Log LOG = LogFactory.getLog(NativeCodeLoader.class);
    private static boolean nativeCodeLoaded = false;

    public static boolean isNativeCodeLoaded() {
        return nativeCodeLoaded;
    }

    public static native boolean buildSupportsSnappy();

    public static native boolean buildSupportsOpenssl();

    public static native String getLibraryName();

    public boolean getLoadNativeLibraries(Configuration conf) {
        return conf.getBoolean("io.native.lib.available", true);
    }

    public void setLoadNativeLibraries(Configuration conf, boolean loadNativeLibraries) {
        conf.setBoolean("io.native.lib.available", loadNativeLibraries);
    }

    static {
        LOG.info("Skipping native-hadoop library for flink-openstack-fs-hadoop's relocated Hadoop... using builtin-java classes where applicable");
    }
}

