/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.util;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.crypto.key.KeyProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class KMSUtil {
    public static final Logger LOG = LoggerFactory.getLogger(KMSUtil.class);

    private KMSUtil() {
    }

    public static KeyProvider createKeyProvider(Configuration conf, String configKeyName) throws IOException {
        URI providerUri;
        LOG.debug("Creating key provider with config key {}", (Object)configKeyName);
        String providerUriStr = conf.getTrimmed(configKeyName, "");
        if (providerUriStr.isEmpty()) {
            return null;
        }
        try {
            providerUri = new URI(providerUriStr);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        KeyProvider keyProvider = KeyProviderFactory.get(providerUri, conf);
        if (keyProvider == null) {
            throw new IOException("Could not instantiate KeyProvider from " + configKeyName + " setting of '" + providerUriStr + "'");
        }
        if (keyProvider.isTransient()) {
            throw new IOException("KeyProvider " + keyProvider.toString() + " was found but it is a transient provider.");
        }
        return keyProvider;
    }
}

