/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.record.compiler;

import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.record.compiler.CodeBuffer;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.record.compiler.JType;

@Deprecated
@InterfaceAudience.Public
@InterfaceStability.Stable
public class JDouble
extends JType {
    public JDouble() {
        this.setJavaType(new JavaDouble());
        this.setCppType(new CppDouble());
        this.setCType(new JType.CType(this));
    }

    @Override
    String getSignature() {
        return "d";
    }

    class CppDouble
    extends JType.CppType {
        CppDouble() {
            super(JDouble.this, "double");
        }

        @Override
        String getTypeIDObjectString() {
            return "new ::hadoop::TypeID(::hadoop::RIOTYPE_DOUBLE)";
        }
    }

    class JavaDouble
    extends JType.JavaType {
        JavaDouble() {
            super(JDouble.this, "double", "Double", "Double", "TypeID.RIOType.DOUBLE");
        }

        @Override
        String getTypeIDObjectString() {
            return "org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.record.meta.TypeID.DoubleTypeID";
        }

        @Override
        void genHashCode(CodeBuffer cb, String fname) {
            String tmp = "Double.doubleToLongBits(" + fname + ")";
            cb.append("_rio_ret = (int)(" + tmp + "^(" + tmp + ">>>32));\n");
        }

        @Override
        void genSlurpBytes(CodeBuffer cb, String b, String s, String l) {
            cb.append("{\n");
            cb.append("if (" + l + "<8) {\n");
            cb.append("throw new java.io.IOException(\"Double is exactly 8 bytes. Provided buffer is smaller.\");\n");
            cb.append("}\n");
            cb.append(s + "+=8; " + l + "-=8;\n");
            cb.append("}\n");
        }

        @Override
        void genCompareBytes(CodeBuffer cb) {
            cb.append("{\n");
            cb.append("if (l1<8 || l2<8) {\n");
            cb.append("throw new java.io.IOException(\"Double is exactly 8 bytes. Provided buffer is smaller.\");\n");
            cb.append("}\n");
            cb.append("double d1 = org.apache.hadoop.record.Utils.readDouble(b1, s1);\n");
            cb.append("double d2 = org.apache.hadoop.record.Utils.readDouble(b2, s2);\n");
            cb.append("if (d1 != d2) {\n");
            cb.append("return ((d1-d2) < 0) ? -1 : 0;\n");
            cb.append("}\n");
            cb.append("s1+=8; s2+=8; l1-=8; l2-=8;\n");
            cb.append("}\n");
        }
    }
}

