/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.log.metrics;

import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class EventCounter
extends AppenderSkeleton {
    private static final int FATAL = 0;
    private static final int ERROR = 1;
    private static final int WARN = 2;
    private static final int INFO = 3;
    private static EventCounts counts = new EventCounts();

    @InterfaceAudience.Private
    public static long getFatal() {
        return EventCounter.counts.get(0);
    }

    @InterfaceAudience.Private
    public static long getError() {
        return EventCounter.counts.get(1);
    }

    @InterfaceAudience.Private
    public static long getWarn() {
        return EventCounter.counts.get(2);
    }

    @InterfaceAudience.Private
    public static long getInfo() {
        return EventCounter.counts.get(3);
    }

    public void append(LoggingEvent event) {
        Level level = event.getLevel();
        if (level.equals((Object)Level.INFO)) {
            EventCounter.counts.incr(3);
        } else if (level.equals((Object)Level.WARN)) {
            EventCounter.counts.incr(2);
        } else if (level.equals((Object)Level.ERROR)) {
            EventCounter.counts.incr(1);
        } else if (level.equals((Object)Level.FATAL)) {
            EventCounter.counts.incr(0);
        }
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }

    private static class EventCounts {
        private final long[] counts = new long[]{0L, 0L, 0L, 0L};

        private EventCounts() {
        }

        private synchronized void incr(int i) {
            int n = i;
            this.counts[n] = this.counts[n] + 1L;
        }

        private synchronized long get(int i) {
            return this.counts[i];
        }
    }
}

