/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.namenode;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.util.IntrusiveCollection;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.util.LightWeightGSet;

@InterfaceAudience.LimitedPrivate(value={"HDFS"})
public final class CachedBlock
implements IntrusiveCollection.Element,
LightWeightGSet.LinkedElement {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final long blockId;
    private LightWeightGSet.LinkedElement nextElement;
    private short replicationAndMark;
    private Object[] triplets;

    public CachedBlock(long blockId, short replication, boolean mark) {
        this.blockId = blockId;
        this.triplets = EMPTY_ARRAY;
        this.setReplicationAndMark(replication, mark);
    }

    public long getBlockId() {
        return this.blockId;
    }

    public int hashCode() {
        return (int)(this.blockId ^ this.blockId >>> 32);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        CachedBlock other = (CachedBlock)o;
        return other.blockId == this.blockId;
    }

    public void setReplicationAndMark(short replication, boolean mark) {
        assert (replication >= 0);
        this.replicationAndMark = (short)(replication << 1 | (mark ? 1 : 0));
    }

    public boolean getMark() {
        return (this.replicationAndMark & 1) != 0;
    }

    public short getReplication() {
        return (short)(this.replicationAndMark >>> 1);
    }

    public boolean isPresent(DatanodeDescriptor.CachedBlocksList cachedBlocksList) {
        for (int i = 0; i < this.triplets.length; i += 3) {
            DatanodeDescriptor.CachedBlocksList list = (DatanodeDescriptor.CachedBlocksList)this.triplets[i];
            if (list != cachedBlocksList) continue;
            return true;
        }
        return false;
    }

    public List<DatanodeDescriptor> getDatanodes(DatanodeDescriptor.CachedBlocksList.Type type) {
        LinkedList<DatanodeDescriptor> nodes = new LinkedList<DatanodeDescriptor>();
        for (int i = 0; i < this.triplets.length; i += 3) {
            DatanodeDescriptor.CachedBlocksList list = (DatanodeDescriptor.CachedBlocksList)this.triplets[i];
            if (type != null && list.getType() != type) continue;
            nodes.add(list.getDatanode());
        }
        return nodes;
    }

    @Override
    public void insertInternal(IntrusiveCollection<? extends IntrusiveCollection.Element> list, IntrusiveCollection.Element prev, IntrusiveCollection.Element next) {
        for (int i = 0; i < this.triplets.length; i += 3) {
            if (this.triplets[i] != list) continue;
            throw new RuntimeException("Trying to re-insert an element that is already in the list.");
        }
        Object[] newTriplets = Arrays.copyOf(this.triplets, this.triplets.length + 3);
        newTriplets[this.triplets.length] = list;
        newTriplets[this.triplets.length + 1] = prev;
        newTriplets[this.triplets.length + 2] = next;
        this.triplets = newTriplets;
    }

    @Override
    public void setPrev(IntrusiveCollection<? extends IntrusiveCollection.Element> list, IntrusiveCollection.Element prev) {
        for (int i = 0; i < this.triplets.length; i += 3) {
            if (this.triplets[i] != list) continue;
            this.triplets[i + 1] = prev;
            return;
        }
        throw new RuntimeException("Called setPrev on an element that wasn't in the list.");
    }

    @Override
    public void setNext(IntrusiveCollection<? extends IntrusiveCollection.Element> list, IntrusiveCollection.Element next) {
        for (int i = 0; i < this.triplets.length; i += 3) {
            if (this.triplets[i] != list) continue;
            this.triplets[i + 2] = next;
            return;
        }
        throw new RuntimeException("Called setNext on an element that wasn't in the list.");
    }

    @Override
    public void removeInternal(IntrusiveCollection<? extends IntrusiveCollection.Element> list) {
        for (int i = 0; i < this.triplets.length; i += 3) {
            if (this.triplets[i] != list) continue;
            Object[] newTriplets = new Object[this.triplets.length - 3];
            System.arraycopy(this.triplets, 0, newTriplets, 0, i);
            System.arraycopy(this.triplets, i + 3, newTriplets, i, this.triplets.length - (i + 3));
            this.triplets = newTriplets;
            return;
        }
        throw new RuntimeException("Called remove on an element that wasn't in the list.");
    }

    @Override
    public IntrusiveCollection.Element getPrev(IntrusiveCollection<? extends IntrusiveCollection.Element> list) {
        for (int i = 0; i < this.triplets.length; i += 3) {
            if (this.triplets[i] != list) continue;
            return (IntrusiveCollection.Element)this.triplets[i + 1];
        }
        throw new RuntimeException("Called getPrev on an element that wasn't in the list.");
    }

    @Override
    public IntrusiveCollection.Element getNext(IntrusiveCollection<? extends IntrusiveCollection.Element> list) {
        for (int i = 0; i < this.triplets.length; i += 3) {
            if (this.triplets[i] != list) continue;
            return (IntrusiveCollection.Element)this.triplets[i + 2];
        }
        throw new RuntimeException("Called getNext on an element that wasn't in the list.");
    }

    @Override
    public boolean isInList(IntrusiveCollection<? extends IntrusiveCollection.Element> list) {
        for (int i = 0; i < this.triplets.length; i += 3) {
            if (this.triplets[i] != list) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "{" + "blockId=" + this.blockId + ", " + "replication=" + this.getReplication() + ", " + "mark=" + this.getMark() + "}";
    }

    @Override
    public void setNext(LightWeightGSet.LinkedElement next) {
        this.nextElement = next;
    }

    @Override
    public LightWeightGSet.LinkedElement getNext() {
        return this.nextElement;
    }
}

