/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.datanode.web;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.logging.Log;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.datanode.web.DatanodeHttpServer;

class SimpleHttpProxyHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private String uri;
    private Channel proxiedChannel;
    private final InetSocketAddress host;
    static final Log LOG = DatanodeHttpServer.LOG;

    SimpleHttpProxyHandler(InetSocketAddress host) {
        this.host = host;
    }

    public void channelRead0(final ChannelHandlerContext ctx, final HttpRequest req) {
        this.uri = req.getUri();
        final Channel client = ctx.channel();
        Bootstrap proxiedServer = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)client.eventLoop())).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{new HttpRequestEncoder(), new Forwarder(SimpleHttpProxyHandler.this.uri, client)});
            }
        });
        ChannelFuture f = proxiedServer.connect((SocketAddress)this.host);
        this.proxiedChannel = f.channel();
        f.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    ctx.channel().pipeline().remove(HttpResponseEncoder.class);
                    DefaultFullHttpRequest newReq = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, req.getMethod(), req.getUri());
                    newReq.headers().add(req.headers());
                    newReq.headers().set("Connection", (Object)"close");
                    future.channel().writeAndFlush((Object)newReq);
                } else {
                    DefaultHttpResponse resp = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR);
                    resp.headers().set("Connection", (Object)"close");
                    LOG.info("Proxy " + SimpleHttpProxyHandler.this.uri + " failed. Cause: ", future.cause());
                    ctx.writeAndFlush((Object)resp).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    client.close();
                }
            }
        });
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.proxiedChannel != null) {
            this.proxiedChannel.close();
            this.proxiedChannel = null;
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOG.info("Proxy for " + this.uri + " failed. cause: ", cause);
        if (this.proxiedChannel != null) {
            this.proxiedChannel.close();
            this.proxiedChannel = null;
        }
        ctx.close();
    }

    private static void closeOnFlush(Channel ch) {
        if (ch.isActive()) {
            ch.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private static class Forwarder
    extends ChannelInboundHandlerAdapter {
        private final String uri;
        private final Channel client;

        private Forwarder(String uri, Channel client) {
            this.uri = uri;
            this.client = client;
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            SimpleHttpProxyHandler.closeOnFlush(this.client);
        }

        public void channelRead(final ChannelHandlerContext ctx, Object msg) {
            this.client.writeAndFlush(msg).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) {
                    if (future.isSuccess()) {
                        ctx.channel().read();
                    } else {
                        LOG.debug("Proxy failed. Cause: ", future.cause());
                        future.channel().close();
                    }
                }
            });
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            LOG.debug("Proxy for " + this.uri + " failed. cause: ", cause);
            SimpleHttpProxyHandler.closeOnFlush(ctx.channel());
        }
    }
}

