/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.nio.channels.ServerSocketChannel;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.logging.Log;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.logging.LogFactory;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.net.Peer;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.net.PeerServer;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.datanode.SecureDataNodeStarter;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.ipc.Server;

@InterfaceAudience.Private
public class TcpPeerServer
implements PeerServer {
    static final Log LOG = LogFactory.getLog(TcpPeerServer.class);
    private final ServerSocket serverSocket;

    public TcpPeerServer(int socketWriteTimeout, InetSocketAddress bindAddr, int backlogLength) throws IOException {
        this.serverSocket = socketWriteTimeout > 0 ? ServerSocketChannel.open().socket() : new ServerSocket();
        Server.bind(this.serverSocket, bindAddr, backlogLength);
    }

    public TcpPeerServer(SecureDataNodeStarter.SecureResources secureResources) {
        this.serverSocket = secureResources.getStreamingSocket();
    }

    public InetSocketAddress getStreamingAddr() {
        return new InetSocketAddress(this.serverSocket.getInetAddress().getHostAddress(), this.serverSocket.getLocalPort());
    }

    @Override
    public void setReceiveBufferSize(int size) throws IOException {
        this.serverSocket.setReceiveBufferSize(size);
    }

    @Override
    public int getReceiveBufferSize() throws IOException {
        return this.serverSocket.getReceiveBufferSize();
    }

    @Override
    public Peer accept() throws IOException, SocketTimeoutException {
        Peer peer = DFSUtilClient.peerFromSocket(this.serverSocket.accept());
        return peer;
    }

    @Override
    public String getListeningString() {
        return this.serverSocket.getLocalSocketAddress().toString();
    }

    @Override
    public void close() throws IOException {
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            LOG.error("error closing TcpPeerServer: ", e);
        }
    }

    public String toString() {
        return "TcpPeerServer(" + this.getListeningString() + ")";
    }
}

