/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.crypto.key.kms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import javax.net.ssl.HttpsURLConnection;
import org.apache.flink.fs.openstackhadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.fs.openstackhadoop.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.openstackhadoop.shaded.com.google.common.base.Strings;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.codec.binary.Base64;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.crypto.key.KeyProviderDelegationTokenExtension;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.crypto.key.KeyProviderFactory;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.crypto.key.kms.KMSDelegationToken;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.crypto.key.kms.LoadBalancingKMSClientProvider;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.crypto.key.kms.ValueQueue;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.io.IOUtils;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.io.Text;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.security.Credentials;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.security.ProviderUtils;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.security.SecurityUtil;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.security.UserGroupInformation;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.security.token.Token;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.security.token.TokenRenewer;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticatedURL;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.util.HttpExceptionUtils;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.util.KMSUtil;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.http.client.utils.URIBuilder;
import org.apache.flink.fs.openstackhadoop.shaded.org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class KMSClientProvider
extends KeyProvider
implements KeyProviderCryptoExtension.CryptoExtension,
KeyProviderDelegationTokenExtension.DelegationTokenExtension {
    private static final Logger LOG = LoggerFactory.getLogger(KMSClientProvider.class);
    private static final String INVALID_SIGNATURE = "Invalid signature";
    private static final String ANONYMOUS_REQUESTS_DISALLOWED = "Anonymous requests are disallowed";
    public static final String TOKEN_KIND_STR = "kms-dt";
    public static final Text TOKEN_KIND = KMSDelegationToken.TOKEN_KIND;
    public static final String SCHEME_NAME = "kms";
    private static final String UTF8 = "UTF-8";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String APPLICATION_JSON_MIME = "application/json";
    private static final String HTTP_GET = "GET";
    private static final String HTTP_POST = "POST";
    private static final String HTTP_PUT = "PUT";
    private static final String HTTP_DELETE = "DELETE";
    private static final String CONFIG_PREFIX = "hadoop.security.kms.client.";
    public static final String TIMEOUT_ATTR = "hadoop.security.kms.client.timeout";
    public static final int DEFAULT_TIMEOUT = 60;
    public static final String AUTH_RETRY = "hadoop.security.kms.client.authentication.retry-count";
    public static final int DEFAULT_AUTH_RETRY = 1;
    private final ValueQueue<KeyProviderCryptoExtension.EncryptedKeyVersion> encKeyVersionQueue;
    private String kmsUrl;
    private SSLFactory sslFactory;
    private ConnectionConfigurator configurator;
    private DelegationTokenAuthenticatedURL.Token authToken;
    private final int authRetry;

    private static List<KeyProviderCryptoExtension.EncryptedKeyVersion> parseJSONEncKeyVersion(String keyName, List valueList) {
        LinkedList<KeyProviderCryptoExtension.EncryptedKeyVersion> ekvs = new LinkedList<KeyProviderCryptoExtension.EncryptedKeyVersion>();
        if (!valueList.isEmpty()) {
            for (Object values : valueList) {
                Map valueMap = (Map)values;
                String versionName = KMSClientProvider.checkNotNull((String)valueMap.get("versionName"), "versionName");
                byte[] iv = Base64.decodeBase64(KMSClientProvider.checkNotNull((String)valueMap.get("iv"), "iv"));
                Map encValueMap = KMSClientProvider.checkNotNull((Map)valueMap.get("encryptedKeyVersion"), "encryptedKeyVersion");
                String encVersionName = KMSClientProvider.checkNotNull((String)encValueMap.get("versionName"), "versionName");
                byte[] encKeyMaterial = Base64.decodeBase64(KMSClientProvider.checkNotNull((String)encValueMap.get("material"), "material"));
                ekvs.add(new KMSEncryptedKeyVersion(keyName, versionName, iv, encVersionName, encKeyMaterial));
            }
        }
        return ekvs;
    }

    private static KeyProvider.KeyVersion parseJSONKeyVersion(Map valueMap) {
        KMSKeyVersion keyVersion = null;
        if (!valueMap.isEmpty()) {
            byte[] material = valueMap.containsKey("material") ? Base64.decodeBase64((String)valueMap.get("material")) : null;
            String versionName = (String)valueMap.get("versionName");
            String keyName = (String)valueMap.get("name");
            keyVersion = new KMSKeyVersion(keyName, versionName, material);
        }
        return keyVersion;
    }

    private static KeyProvider.Metadata parseJSONMetadata(Map valueMap) {
        KMSMetadata metadata = null;
        if (!valueMap.isEmpty()) {
            metadata = new KMSMetadata((String)valueMap.get("cipher"), (Integer)valueMap.get("length"), (String)valueMap.get("description"), (Map)valueMap.get("attributes"), new Date((Long)valueMap.get("created")), (Integer)valueMap.get("versions"));
        }
        return metadata;
    }

    private static void writeJson(Map map, OutputStream os) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(os, StandardCharsets.UTF_8);
        ObjectMapper jsonMapper = new ObjectMapper();
        jsonMapper.writerWithDefaultPrettyPrinter().writeValue(writer, (Object)map);
    }

    public static <T> T checkNotNull(T o, String name) throws IllegalArgumentException {
        if (o == null) {
            throw new IllegalArgumentException("Parameter '" + name + "' cannot be null");
        }
        return o;
    }

    public static String checkNotEmpty(String s, String name) throws IllegalArgumentException {
        KMSClientProvider.checkNotNull(s, name);
        if (s.isEmpty()) {
            throw new IllegalArgumentException("Parameter '" + name + "' cannot be empty");
        }
        return s;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("KMSClientProvider[");
        sb.append(this.kmsUrl).append("]");
        return sb.toString();
    }

    public KMSClientProvider(URI uri, Configuration conf) throws IOException {
        super(conf);
        this.kmsUrl = KMSClientProvider.createServiceURL(KMSClientProvider.extractKMSPath(uri));
        if ("https".equalsIgnoreCase(new URL(this.kmsUrl).getProtocol())) {
            this.sslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
            try {
                this.sslFactory.init();
            }
            catch (GeneralSecurityException ex) {
                throw new IOException(ex);
            }
        }
        int timeout = conf.getInt(TIMEOUT_ATTR, 60);
        this.authRetry = conf.getInt(AUTH_RETRY, 1);
        this.configurator = new TimeoutConnConfigurator(timeout, this.sslFactory);
        this.encKeyVersionQueue = new ValueQueue<KeyProviderCryptoExtension.EncryptedKeyVersion>(conf.getInt("hadoop.security.kms.client.encrypted.key.cache.size", 500), conf.getFloat("hadoop.security.kms.client.encrypted.key.cache.low-watermark", 0.3f), conf.getInt("hadoop.security.kms.client.encrypted.key.cache.expiry", 43200000), conf.getInt("hadoop.security.kms.client.encrypted.key.cache.num.refill.threads", 2), new EncryptedQueueRefiller());
        this.authToken = new DelegationTokenAuthenticatedURL.Token();
    }

    private static Path extractKMSPath(URI uri) throws MalformedURLException, IOException {
        return ProviderUtils.unnestUri(uri);
    }

    private static String createServiceURL(Path path) throws IOException {
        String str = new URL(path.toString()).toExternalForm();
        if (str.endsWith("/")) {
            str = str.substring(0, str.length() - 1);
        }
        return new URL(str + "/v1" + "/").toExternalForm();
    }

    private URL createURL(String collection, String resource, String subResource, Map<String, ?> parameters) throws IOException {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(this.kmsUrl);
            if (collection != null) {
                sb.append(collection);
                if (resource != null) {
                    sb.append("/").append(URLEncoder.encode(resource, UTF8));
                    if (subResource != null) {
                        sb.append("/").append(subResource);
                    }
                }
            }
            URIBuilder uriBuilder = new URIBuilder(sb.toString());
            if (parameters != null) {
                for (Map.Entry<String, ?> param : parameters.entrySet()) {
                    Object value = param.getValue();
                    if (value instanceof String) {
                        uriBuilder.addParameter(param.getKey(), (String)value);
                        continue;
                    }
                    for (String s : (String[])value) {
                        uriBuilder.addParameter(param.getKey(), s);
                    }
                }
            }
            return uriBuilder.build().toURL();
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
    }

    private HttpURLConnection configureConnection(HttpURLConnection conn) throws IOException {
        if (this.sslFactory != null) {
            HttpsURLConnection httpsConn = (HttpsURLConnection)conn;
            try {
                httpsConn.setSSLSocketFactory(this.sslFactory.createSSLSocketFactory());
            }
            catch (GeneralSecurityException ex) {
                throw new IOException(ex);
            }
            httpsConn.setHostnameVerifier(this.sslFactory.getHostnameVerifier());
        }
        return conn;
    }

    private HttpURLConnection createConnection(final URL url, String method) throws IOException {
        HttpURLConnection conn;
        try {
            final String doAsUser = this.getDoAsUser();
            conn = this.getActualUgi().doAs(new PrivilegedExceptionAction<HttpURLConnection>(){

                @Override
                public HttpURLConnection run() throws Exception {
                    DelegationTokenAuthenticatedURL authUrl = new DelegationTokenAuthenticatedURL(KMSClientProvider.this.configurator);
                    return authUrl.openConnection(url, KMSClientProvider.this.authToken, doAsUser);
                }
            });
        }
        catch (IOException ex) {
            if (ex instanceof SocketTimeoutException) {
                LOG.warn("Failed to connect to {}:{}", (Object)url.getHost(), (Object)url.getPort());
            }
            throw ex;
        }
        catch (UndeclaredThrowableException ex) {
            throw new IOException(ex.getUndeclaredThrowable());
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        conn.setUseCaches(false);
        conn.setRequestMethod(method);
        if (method.equals(HTTP_POST) || method.equals(HTTP_PUT)) {
            conn.setDoOutput(true);
        }
        conn = this.configureConnection(conn);
        return conn;
    }

    private <T> T call(HttpURLConnection conn, Map jsonOutput, int expectedResponse, Class<T> klass) throws IOException {
        return this.call(conn, jsonOutput, expectedResponse, klass, this.authRetry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T call(HttpURLConnection conn, Map jsonOutput, int expectedResponse, Class<T> klass, int authRetryCount) throws IOException {
        T ret = null;
        try {
            if (jsonOutput != null) {
                KMSClientProvider.writeJson(jsonOutput, conn.getOutputStream());
            }
        }
        catch (IOException ex) {
            IOUtils.closeStream(conn.getInputStream());
            throw ex;
        }
        if (conn.getResponseCode() == 403 && (conn.getResponseMessage().equals(ANONYMOUS_REQUESTS_DISALLOWED) || conn.getResponseMessage().contains(INVALID_SIGNATURE)) || conn.getResponseCode() == 401) {
            this.authToken = new DelegationTokenAuthenticatedURL.Token();
            if (authRetryCount > 0) {
                String contentType = conn.getRequestProperty(CONTENT_TYPE);
                String requestMethod = conn.getRequestMethod();
                URL url = conn.getURL();
                conn = this.createConnection(url, requestMethod);
                conn.setRequestProperty(CONTENT_TYPE, contentType);
                return this.call(conn, jsonOutput, expectedResponse, klass, authRetryCount - 1);
            }
        }
        try {
            AuthenticatedURL.extractToken(conn, this.authToken);
        }
        catch (AuthenticationException contentType) {
            // empty catch block
        }
        HttpExceptionUtils.validateResponse(conn, expectedResponse);
        if (conn.getContentType() != null && conn.getContentType().trim().toLowerCase().startsWith(APPLICATION_JSON_MIME) && klass != null) {
            ObjectMapper mapper = new ObjectMapper();
            InputStream is = null;
            try {
                is = conn.getInputStream();
                ret = mapper.readValue(is, klass);
            }
            finally {
                IOUtils.closeStream(is);
            }
        }
        return ret;
    }

    @Override
    public KeyProvider.KeyVersion getKeyVersion(String versionName) throws IOException {
        KMSClientProvider.checkNotEmpty(versionName, "versionName");
        URL url = this.createURL("keyversion", versionName, null, null);
        HttpURLConnection conn = this.createConnection(url, HTTP_GET);
        Map response = this.call(conn, null, 200, Map.class);
        return KMSClientProvider.parseJSONKeyVersion(response);
    }

    @Override
    public KeyProvider.KeyVersion getCurrentKey(String name) throws IOException {
        KMSClientProvider.checkNotEmpty(name, "name");
        URL url = this.createURL("key", name, "_currentversion", null);
        HttpURLConnection conn = this.createConnection(url, HTTP_GET);
        Map response = this.call(conn, null, 200, Map.class);
        return KMSClientProvider.parseJSONKeyVersion(response);
    }

    @Override
    public List<String> getKeys() throws IOException {
        URL url = this.createURL("keys/names", null, null, null);
        HttpURLConnection conn = this.createConnection(url, HTTP_GET);
        List response = this.call(conn, null, 200, List.class);
        return response;
    }

    private List<String[]> createKeySets(String[] keyNames) {
        ArrayList<String[]> list = new ArrayList<String[]>();
        ArrayList<String> batch = new ArrayList<String>();
        int batchLen = 0;
        for (String name : keyNames) {
            int additionalLen = "key".length() + 1 + name.length();
            if ((batchLen += additionalLen) > 1500) {
                list.add(batch.toArray(new String[batch.size()]));
                batch = new ArrayList();
                batchLen = additionalLen;
            }
            batch.add(name);
        }
        if (!batch.isEmpty()) {
            list.add(batch.toArray(new String[batch.size()]));
        }
        return list;
    }

    @Override
    public KeyProvider.Metadata[] getKeysMetadata(String ... keyNames) throws IOException {
        ArrayList<KeyProvider.Metadata> keysMetadata = new ArrayList<KeyProvider.Metadata>();
        List<String[]> keySets = this.createKeySets(keyNames);
        for (String[] keySet : keySets) {
            if (keyNames.length <= 0) continue;
            HashMap<String, String[]> queryStr = new HashMap<String, String[]>();
            queryStr.put("key", keySet);
            URL url = this.createURL("keys/metadata", null, null, queryStr);
            HttpURLConnection conn = this.createConnection(url, HTTP_GET);
            List list = this.call(conn, null, 200, List.class);
            for (Map map : list) {
                keysMetadata.add(KMSClientProvider.parseJSONMetadata(map));
            }
        }
        return keysMetadata.toArray(new KeyProvider.Metadata[keysMetadata.size()]);
    }

    private KeyProvider.KeyVersion createKeyInternal(String name, byte[] material, KeyProvider.Options options) throws NoSuchAlgorithmException, IOException {
        KMSClientProvider.checkNotEmpty(name, "name");
        KMSClientProvider.checkNotNull(options, "options");
        HashMap<String, Object> jsonKey = new HashMap<String, Object>();
        jsonKey.put("name", name);
        jsonKey.put("cipher", options.getCipher());
        jsonKey.put("length", options.getBitLength());
        if (material != null) {
            jsonKey.put("material", Base64.encodeBase64String(material));
        }
        if (options.getDescription() != null) {
            jsonKey.put("description", options.getDescription());
        }
        if (options.getAttributes() != null && !options.getAttributes().isEmpty()) {
            jsonKey.put("attributes", options.getAttributes());
        }
        URL url = this.createURL("keys", null, null, null);
        HttpURLConnection conn = this.createConnection(url, HTTP_POST);
        conn.setRequestProperty(CONTENT_TYPE, APPLICATION_JSON_MIME);
        Map response = this.call(conn, jsonKey, 201, Map.class);
        return KMSClientProvider.parseJSONKeyVersion(response);
    }

    @Override
    public KeyProvider.KeyVersion createKey(String name, KeyProvider.Options options) throws NoSuchAlgorithmException, IOException {
        return this.createKeyInternal(name, null, options);
    }

    @Override
    public KeyProvider.KeyVersion createKey(String name, byte[] material, KeyProvider.Options options) throws IOException {
        KMSClientProvider.checkNotNull(material, "material");
        try {
            return this.createKeyInternal(name, material, options);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("It should not happen", ex);
        }
    }

    private KeyProvider.KeyVersion rollNewVersionInternal(String name, byte[] material) throws NoSuchAlgorithmException, IOException {
        KMSClientProvider.checkNotEmpty(name, "name");
        HashMap<String, String> jsonMaterial = new HashMap<String, String>();
        if (material != null) {
            jsonMaterial.put("material", Base64.encodeBase64String(material));
        }
        URL url = this.createURL("key", name, null, null);
        HttpURLConnection conn = this.createConnection(url, HTTP_POST);
        conn.setRequestProperty(CONTENT_TYPE, APPLICATION_JSON_MIME);
        Map response = this.call(conn, jsonMaterial, 200, Map.class);
        KeyProvider.KeyVersion keyVersion = KMSClientProvider.parseJSONKeyVersion(response);
        this.encKeyVersionQueue.drain(name);
        return keyVersion;
    }

    @Override
    public KeyProvider.KeyVersion rollNewVersion(String name) throws NoSuchAlgorithmException, IOException {
        return this.rollNewVersionInternal(name, null);
    }

    @Override
    public KeyProvider.KeyVersion rollNewVersion(String name, byte[] material) throws IOException {
        KMSClientProvider.checkNotNull(material, "material");
        try {
            return this.rollNewVersionInternal(name, material);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("It should not happen", ex);
        }
    }

    @Override
    public KeyProviderCryptoExtension.EncryptedKeyVersion generateEncryptedKey(String encryptionKeyName) throws IOException, GeneralSecurityException {
        try {
            return this.encKeyVersionQueue.getNext(encryptionKeyName);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof SocketTimeoutException) {
                throw (SocketTimeoutException)e.getCause();
            }
            throw new IOException(e);
        }
    }

    @Override
    public KeyProvider.KeyVersion decryptEncryptedKey(KeyProviderCryptoExtension.EncryptedKeyVersion encryptedKeyVersion) throws IOException, GeneralSecurityException {
        KMSClientProvider.checkNotNull(encryptedKeyVersion.getEncryptionKeyVersionName(), "versionName");
        KMSClientProvider.checkNotNull(encryptedKeyVersion.getEncryptedKeyIv(), "iv");
        Preconditions.checkArgument(encryptedKeyVersion.getEncryptedKeyVersion().getVersionName().equals("EEK"), "encryptedKey version name must be '%s', is '%s'", "EEK", encryptedKeyVersion.getEncryptedKeyVersion().getVersionName());
        KMSClientProvider.checkNotNull(encryptedKeyVersion.getEncryptedKeyVersion(), "encryptedKey");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("eek_op", "decrypt");
        HashMap<String, String> jsonPayload = new HashMap<String, String>();
        jsonPayload.put("name", encryptedKeyVersion.getEncryptionKeyName());
        jsonPayload.put("iv", Base64.encodeBase64String(encryptedKeyVersion.getEncryptedKeyIv()));
        jsonPayload.put("material", Base64.encodeBase64String(encryptedKeyVersion.getEncryptedKeyVersion().getMaterial()));
        URL url = this.createURL("keyversion", encryptedKeyVersion.getEncryptionKeyVersionName(), "_eek", params);
        HttpURLConnection conn = this.createConnection(url, HTTP_POST);
        conn.setRequestProperty(CONTENT_TYPE, APPLICATION_JSON_MIME);
        Map response = this.call(conn, jsonPayload, 200, Map.class);
        return KMSClientProvider.parseJSONKeyVersion(response);
    }

    @Override
    public List<KeyProvider.KeyVersion> getKeyVersions(String name) throws IOException {
        KMSClientProvider.checkNotEmpty(name, "name");
        URL url = this.createURL("key", name, "_versions", null);
        HttpURLConnection conn = this.createConnection(url, HTTP_GET);
        List response = this.call(conn, null, 200, List.class);
        ArrayList<KeyProvider.KeyVersion> versions = null;
        if (!response.isEmpty()) {
            versions = new ArrayList<KeyProvider.KeyVersion>();
            for (Object obj : response) {
                versions.add(KMSClientProvider.parseJSONKeyVersion((Map)obj));
            }
        }
        return versions;
    }

    @Override
    public KeyProvider.Metadata getMetadata(String name) throws IOException {
        KMSClientProvider.checkNotEmpty(name, "name");
        URL url = this.createURL("key", name, "_metadata", null);
        HttpURLConnection conn = this.createConnection(url, HTTP_GET);
        Map response = this.call(conn, null, 200, Map.class);
        return KMSClientProvider.parseJSONMetadata(response);
    }

    @Override
    public void deleteKey(String name) throws IOException {
        KMSClientProvider.checkNotEmpty(name, "name");
        URL url = this.createURL("key", name, null, null);
        HttpURLConnection conn = this.createConnection(url, HTTP_DELETE);
        this.call(conn, null, 200, null);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void warmUpEncryptedKeys(String ... keyNames) throws IOException {
        try {
            this.encKeyVersionQueue.initializeQueuesForKeys(keyNames);
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void drain(String keyName) {
        this.encKeyVersionQueue.drain(keyName);
    }

    @VisibleForTesting
    public int getEncKeyQueueSize(String keyName) {
        return this.encKeyVersionQueue.getSize(keyName);
    }

    @Override
    public long renewDelegationToken(Token<?> dToken) throws IOException {
        try {
            final String doAsUser = this.getDoAsUser();
            final DelegationTokenAuthenticatedURL.Token token = this.generateDelegationToken(dToken);
            final URL url = this.createURL(null, null, null, null);
            LOG.debug("Renewing delegation token {} with url:{}, as:{}", new Object[]{token, url, doAsUser});
            final DelegationTokenAuthenticatedURL authUrl = new DelegationTokenAuthenticatedURL(this.configurator);
            return this.getActualUgi().doAs(new PrivilegedExceptionAction<Long>(){

                @Override
                public Long run() throws Exception {
                    return authUrl.renewDelegationToken(url, token, doAsUser);
                }
            });
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException(ex);
        }
    }

    @Override
    public Void cancelDelegationToken(final Token<?> dToken) throws IOException {
        try {
            final String doAsUser = this.getDoAsUser();
            final DelegationTokenAuthenticatedURL.Token token = this.generateDelegationToken(dToken);
            return this.getActualUgi().doAs(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    URL url = KMSClientProvider.this.createURL(null, null, null, null);
                    LOG.debug("Cancelling delegation token {} with url:{}, as:{}", new Object[]{dToken, url, doAsUser});
                    DelegationTokenAuthenticatedURL authUrl = new DelegationTokenAuthenticatedURL(KMSClientProvider.this.configurator);
                    authUrl.cancelDelegationToken(url, token, doAsUser);
                    return null;
                }
            });
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException(ex);
        }
    }

    private String getDoAsUser() throws IOException {
        UserGroupInformation currentUgi = UserGroupInformation.getCurrentUser();
        return currentUgi.getAuthenticationMethod() == UserGroupInformation.AuthenticationMethod.PROXY ? currentUgi.getShortUserName() : null;
    }

    private DelegationTokenAuthenticatedURL.Token generateDelegationToken(Token<?> dToken) {
        DelegationTokenAuthenticatedURL.Token token = new DelegationTokenAuthenticatedURL.Token();
        Token<AbstractDelegationTokenIdentifier> dt = new Token<AbstractDelegationTokenIdentifier>(dToken.getIdentifier(), dToken.getPassword(), dToken.getKind(), dToken.getService());
        token.setDelegationToken(dt);
        return token;
    }

    @Override
    public Token<?>[] addDelegationTokens(final String renewer, Credentials credentials) throws IOException {
        Token[] tokens = null;
        Text dtService = this.getDelegationTokenService();
        Token token = credentials.getToken(dtService);
        if (token == null) {
            final URL url = this.createURL(null, null, null, null);
            final DelegationTokenAuthenticatedURL authUrl = new DelegationTokenAuthenticatedURL(this.configurator);
            try {
                final String doAsUser = this.getDoAsUser();
                token = (Token)this.getActualUgi().doAs(new PrivilegedExceptionAction<Token<?>>(){

                    @Override
                    public Token<?> run() throws Exception {
                        return authUrl.getDelegationToken(url, new DelegationTokenAuthenticatedURL.Token(), renewer, doAsUser);
                    }
                });
                if (token == null) {
                    throw new IOException("Got NULL as delegation token");
                }
                credentials.addToken(token.getService(), token);
                tokens = new Token[]{token};
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return tokens;
    }

    private Text getDelegationTokenService() throws IOException {
        URL url = new URL(this.kmsUrl);
        InetSocketAddress addr = new InetSocketAddress(url.getHost(), url.getPort());
        Text dtService = SecurityUtil.buildTokenService(addr);
        return dtService;
    }

    private boolean currentUgiContainsKmsDt() throws IOException {
        Token<? extends TokenIdentifier> dToken;
        Credentials creds = UserGroupInformation.getCurrentUser().getCredentials();
        return !creds.getAllTokens().isEmpty() && (dToken = creds.getToken(this.getDelegationTokenService())) != null;
    }

    private UserGroupInformation getActualUgi() throws IOException {
        UserGroupInformation currentUgi = UserGroupInformation.getCurrentUser();
        if (LOG.isDebugEnabled()) {
            UserGroupInformation.logAllUserInfo(currentUgi);
        }
        UserGroupInformation actualUgi = currentUgi;
        if (currentUgi.getRealUser() != null) {
            actualUgi = currentUgi.getRealUser();
        } else if (!this.currentUgiContainsKmsDt() && !currentUgi.hasKerberosCredentials()) {
            actualUgi = currentUgi.getLoginUser();
        }
        return actualUgi;
    }

    @Override
    public void close() throws IOException {
        try {
            this.encKeyVersionQueue.shutdown();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            if (this.sslFactory != null) {
                this.sslFactory.destroy();
                this.sslFactory = null;
            }
        }
    }

    @VisibleForTesting
    String getKMSUrl() {
        return this.kmsUrl;
    }

    public static class KMSMetadata
    extends KeyProvider.Metadata {
        public KMSMetadata(String cipher, int bitLength, String description, Map<String, String> attributes, Date created, int versions) {
            super(cipher, bitLength, description, attributes, created, versions);
        }
    }

    public static class KMSKeyVersion
    extends KeyProvider.KeyVersion {
        public KMSKeyVersion(String keyName, String versionName, byte[] material) {
            super(keyName, versionName, material);
        }
    }

    private static class TimeoutConnConfigurator
    implements ConnectionConfigurator {
        private ConnectionConfigurator cc;
        private int timeout;

        public TimeoutConnConfigurator(int timeout, ConnectionConfigurator cc) {
            this.timeout = timeout;
            this.cc = cc;
        }

        @Override
        public HttpURLConnection configure(HttpURLConnection conn) throws IOException {
            if (this.cc != null) {
                conn = this.cc.configure(conn);
            }
            conn.setConnectTimeout(this.timeout * 1000);
            conn.setReadTimeout(this.timeout * 1000);
            return conn;
        }
    }

    public static class Factory
    extends KeyProviderFactory {
        @Override
        public KeyProvider createProvider(URI providerUri, Configuration conf) throws IOException {
            if (KMSClientProvider.SCHEME_NAME.equals(providerUri.getScheme())) {
                URL origUrl = new URL(KMSClientProvider.extractKMSPath(providerUri).toString());
                String authority = origUrl.getAuthority();
                if (Strings.isNullOrEmpty(authority)) {
                    throw new IOException("No valid authority in kms uri [" + origUrl + "]");
                }
                int port = -1;
                String hostsPart = authority;
                if (authority.contains(":")) {
                    String[] t = authority.split(":");
                    try {
                        port = Integer.parseInt(t[1]);
                    }
                    catch (Exception e) {
                        throw new IOException("Could not parse port in kms uri [" + origUrl + "]");
                    }
                    hostsPart = t[0];
                }
                return this.createProvider(providerUri, conf, origUrl, port, hostsPart);
            }
            return null;
        }

        private KeyProvider createProvider(URI providerUri, Configuration conf, URL origUrl, int port, String hostsPart) throws IOException {
            String[] hosts = hostsPart.split(";");
            if (hosts.length == 1) {
                return new KMSClientProvider(providerUri, conf);
            }
            KMSClientProvider[] providers = new KMSClientProvider[hosts.length];
            for (int i = 0; i < hosts.length; ++i) {
                try {
                    providers[i] = new KMSClientProvider(new URI(KMSClientProvider.SCHEME_NAME, origUrl.getProtocol(), hosts[i], port, origUrl.getPath(), null, null), conf);
                    continue;
                }
                catch (URISyntaxException e) {
                    throw new IOException("Could not instantiate KMSProvider..", e);
                }
            }
            return new LoadBalancingKMSClientProvider(providers, conf);
        }
    }

    public static class KMSEncryptedKeyVersion
    extends KeyProviderCryptoExtension.EncryptedKeyVersion {
        public KMSEncryptedKeyVersion(String keyName, String keyVersionName, byte[] iv, String encryptedVersionName, byte[] keyMaterial) {
            super(keyName, keyVersionName, iv, new KMSKeyVersion(null, encryptedVersionName, keyMaterial));
        }
    }

    public static class KMSTokenRenewer
    extends TokenRenewer {
        private static final Logger LOG = LoggerFactory.getLogger(KMSTokenRenewer.class);

        @Override
        public boolean handleKind(Text kind) {
            return kind.equals(TOKEN_KIND);
        }

        @Override
        public boolean isManaged(Token<?> token) throws IOException {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long renew(Token<?> token, Configuration conf) throws IOException {
            LOG.debug("Renewing delegation token {}", token);
            try (KeyProvider keyProvider = KMSUtil.createKeyProvider(conf, "hadoop.security.key.provider.path");){
                if (!(keyProvider instanceof KeyProviderDelegationTokenExtension.DelegationTokenExtension)) {
                    LOG.warn("keyProvider {} cannot renew dt.", keyProvider == null ? "null" : keyProvider.getClass());
                    long l = 0L;
                    return l;
                }
                long l = ((KeyProviderDelegationTokenExtension.DelegationTokenExtension)((Object)keyProvider)).renewDelegationToken(token);
                return l;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel(Token<?> token, Configuration conf) throws IOException {
            LOG.debug("Canceling delegation token {}", token);
            try (KeyProvider keyProvider = KMSUtil.createKeyProvider(conf, "hadoop.security.key.provider.path");){
                if (!(keyProvider instanceof KeyProviderDelegationTokenExtension.DelegationTokenExtension)) {
                    LOG.warn("keyProvider {} cannot cancel dt.", keyProvider == null ? "null" : keyProvider.getClass());
                    return;
                }
                ((KeyProviderDelegationTokenExtension.DelegationTokenExtension)((Object)keyProvider)).cancelDelegationToken(token);
            }
        }
    }

    private class EncryptedQueueRefiller
    implements ValueQueue.QueueRefiller<KeyProviderCryptoExtension.EncryptedKeyVersion> {
        private EncryptedQueueRefiller() {
        }

        @Override
        public void fillQueueForKey(String keyName, Queue<KeyProviderCryptoExtension.EncryptedKeyVersion> keyQueue, int numEKVs) throws IOException {
            KMSClientProvider.checkNotNull(keyName, "keyName");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("eek_op", "generate");
            params.put("num_keys", "" + numEKVs);
            URL url = KMSClientProvider.this.createURL("key", keyName, "_eek", params);
            HttpURLConnection conn = KMSClientProvider.this.createConnection(url, KMSClientProvider.HTTP_GET);
            conn.setRequestProperty(KMSClientProvider.CONTENT_TYPE, KMSClientProvider.APPLICATION_JSON_MIME);
            List response = (List)KMSClientProvider.this.call(conn, null, 200, List.class);
            List ekvs = KMSClientProvider.parseJSONEncKeyVersion(keyName, response);
            keyQueue.addAll(ekvs);
        }
    }
}

