/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.flink.runtime.util;

import java.io.File;
import java.util.Collection;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.io.Text;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.security.UserGroupInformation;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.security.token.Token;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.util.VersionInfo;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopUtils.class);
    private static final Text HDFS_DELEGATION_TOKEN_KIND = new Text("HDFS_DELEGATION_TOKEN");

    public static org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.conf.Configuration getHadoopConfiguration(Configuration flinkConfiguration) {
        String hadoopConfDir;
        String hadoopConfigPath;
        String hdfsSitePath;
        HdfsConfiguration result = new HdfsConfiguration();
        boolean foundHadoopConfiguration = false;
        String[] possibleHadoopConfPaths = new String[2];
        String hadoopHome = System.getenv("HADOOP_HOME");
        if (hadoopHome != null) {
            LOG.debug("Searching Hadoop configuration files in HADOOP_HOME: {}", (Object)hadoopHome);
            possibleHadoopConfPaths[0] = hadoopHome + "/conf";
            possibleHadoopConfPaths[1] = hadoopHome + "/etc/hadoop";
        }
        for (String possibleHadoopConfPath : possibleHadoopConfPaths) {
            if (possibleHadoopConfPath == null) continue;
            foundHadoopConfiguration = HadoopUtils.addHadoopConfIfFound(result, possibleHadoopConfPath);
        }
        String hdfsDefaultPath = flinkConfiguration.getString("fs.hdfs.hdfsdefault", null);
        if (hdfsDefaultPath != null) {
            result.addResource(new Path(hdfsDefaultPath));
            LOG.debug("Using hdfs-default configuration-file path from Flink config: {}", (Object)hdfsDefaultPath);
            foundHadoopConfiguration = true;
        }
        if ((hdfsSitePath = flinkConfiguration.getString("fs.hdfs.hdfssite", null)) != null) {
            result.addResource(new Path(hdfsSitePath));
            LOG.debug("Using hdfs-site configuration-file path from Flink config: {}", (Object)hdfsSitePath);
            foundHadoopConfiguration = true;
        }
        if ((hadoopConfigPath = flinkConfiguration.getString("fs.hdfs.hadoopconf", null)) != null) {
            LOG.debug("Searching Hadoop configuration files in Flink config: {}", (Object)hadoopConfigPath);
            boolean bl = foundHadoopConfiguration = HadoopUtils.addHadoopConfIfFound(result, hadoopConfigPath) || foundHadoopConfiguration;
        }
        if ((hadoopConfDir = System.getenv("HADOOP_CONF_DIR")) != null) {
            LOG.debug("Searching Hadoop configuration files in HADOOP_CONF_DIR: {}", (Object)hadoopConfDir);
            boolean bl = foundHadoopConfiguration = HadoopUtils.addHadoopConfIfFound(result, hadoopConfDir) || foundHadoopConfiguration;
        }
        if (!foundHadoopConfiguration) {
            LOG.warn("Could not find Hadoop configuration via any of the supported methods (Flink configuration, environment variables).");
        }
        return result;
    }

    public static boolean hasHDFSDelegationToken() throws Exception {
        UserGroupInformation loginUser = UserGroupInformation.getCurrentUser();
        Collection<Token<? extends TokenIdentifier>> usrTok = loginUser.getTokens();
        for (Token<? extends TokenIdentifier> token : usrTok) {
            if (!token.getKind().equals(HDFS_DELEGATION_TOKEN_KIND)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMinHadoopVersion(int major, int minor) throws FlinkRuntimeException {
        String versionString = VersionInfo.getVersion();
        String[] versionParts = versionString.split("\\.");
        if (versionParts.length < 2) {
            throw new FlinkRuntimeException("Cannot determine version of Hadoop, unexpected version string: " + versionString);
        }
        int maj = Integer.parseInt(versionParts[0]);
        int min = Integer.parseInt(versionParts[1]);
        return maj > major || maj == major && min >= minor;
    }

    private static boolean addHadoopConfIfFound(org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.conf.Configuration configuration, String possibleHadoopConfPath) {
        boolean foundHadoopConfiguration = false;
        if (new File(possibleHadoopConfPath).exists()) {
            if (new File(possibleHadoopConfPath + "/core-site.xml").exists()) {
                configuration.addResource(new Path(possibleHadoopConfPath + "/core-site.xml"));
                LOG.debug("Adding " + possibleHadoopConfPath + "/core-site.xml to hadoop configuration");
                foundHadoopConfiguration = true;
            }
            if (new File(possibleHadoopConfPath + "/hdfs-site.xml").exists()) {
                configuration.addResource(new Path(possibleHadoopConfPath + "/hdfs-site.xml"));
                LOG.debug("Adding " + possibleHadoopConfPath + "/hdfs-site.xml to hadoop configuration");
                foundHadoopConfiguration = true;
            }
        }
        return foundHadoopConfiguration;
    }
}

