/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.com.nimbusds.jose.crypto;

import java.security.Provider;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.flink.fs.openstackhadoop.shaded.com.nimbusds.jose.JOSEException;
import org.apache.flink.fs.openstackhadoop.shaded.com.nimbusds.jose.crypto.CipherHelper;
import org.apache.flink.fs.openstackhadoop.shaded.net.jcip.annotations.ThreadSafe;

@ThreadSafe
class RSA1_5 {
    public static byte[] encryptCEK(RSAPublicKey pub, SecretKey cek, Provider provider) throws JOSEException {
        try {
            Cipher cipher = CipherHelper.getInstance("RSA/ECB/PKCS1Padding", provider);
            cipher.init(1, pub);
            return cipher.doFinal(cek.getEncoded());
        }
        catch (Exception e) {
            throw new JOSEException("Couldn't encrypt Content Encryption Key (CEK): " + e.getMessage(), e);
        }
    }

    public static SecretKey decryptCEK(RSAPrivateKey priv, byte[] encryptedCEK, int keyLength, Provider provider) throws JOSEException {
        try {
            Cipher cipher = CipherHelper.getInstance("RSA/ECB/PKCS1Padding", provider);
            cipher.init(2, priv);
            byte[] secretKeyBytes = cipher.doFinal(encryptedCEK);
            if (8 * secretKeyBytes.length != keyLength) {
                return null;
            }
            return new SecretKeySpec(secretKeyBytes, "AES");
        }
        catch (Exception e) {
            throw new JOSEException("Couldn't decrypt Content Encryption Key (CEK): " + e.getMessage(), e);
        }
    }

    private RSA1_5() {
    }
}

