/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.com.nimbusds.jose;

import org.apache.flink.fs.openstackhadoop.shaded.com.nimbusds.jose.Requirement;
import org.apache.flink.fs.openstackhadoop.shaded.net.jcip.annotations.Immutable;
import org.apache.flink.fs.openstackhadoop.shaded.net.minidev.json.JSONAware;
import org.apache.flink.fs.openstackhadoop.shaded.net.minidev.json.JSONObject;

@Immutable
public class Algorithm
implements JSONAware {
    public static final Algorithm NONE = new Algorithm("none", Requirement.REQUIRED);
    private final String name;
    private final Requirement requirement;

    public Algorithm(String name, Requirement req) {
        if (name == null) {
            throw new IllegalArgumentException("The algorithm name must not be null");
        }
        this.name = name;
        this.requirement = req;
    }

    public Algorithm(String name) {
        this(name, null);
    }

    public final String getName() {
        return this.name;
    }

    public final Requirement getRequirement() {
        return this.requirement;
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Algorithm && this.toString().equals(object.toString());
    }

    public final String toString() {
        return this.name;
    }

    @Override
    public final String toJSONString() {
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        sb.append(JSONObject.escape(this.name));
        sb.append('\"');
        return sb.toString();
    }
}

