/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.core.fs.FileSystemFactory;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.flink.runtime.fs.hdfs.HadoopFileSystem;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.flink.runtime.util.HadoopUtils;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.swift.snative.SwiftNativeFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwiftFileSystemFactory
implements FileSystemFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SwiftFileSystemFactory.class);
    private static final String CONFIG_PREFIX = "swift.";
    private org.apache.flink.configuration.Configuration flinkConfig;
    private Configuration hadoopConfig;

    public String getScheme() {
        return "swift";
    }

    public void configure(org.apache.flink.configuration.Configuration config) {
        this.flinkConfig = config;
        this.hadoopConfig = null;
    }

    public org.apache.flink.core.fs.FileSystem create(URI fsUri) throws IOException {
        LOG.debug("Creating swift file system (backed by a Hadoop native swift file system)");
        try {
            URI defaultUri;
            Configuration hadoopConfig = this.hadoopConfig;
            if (hadoopConfig == null) {
                if (this.flinkConfig != null) {
                    LOG.debug("Loading Hadoop configuration for swift native file system");
                    hadoopConfig = HadoopUtils.getHadoopConfiguration(this.flinkConfig);
                    if (hadoopConfig.get("hadoop.tmp.dir") == null) {
                        String[] tmpDirPaths = ConfigurationUtils.parseTempDirectories((org.apache.flink.configuration.Configuration)this.flinkConfig);
                        File tmpDir = new File((String)tmpDirPaths[0], "hadoop-" + System.getProperty("user.name"));
                        hadoopConfig.set("hadoop.tmp.dir", tmpDir.getPath());
                    }
                    for (String key : this.flinkConfig.keySet()) {
                        if (!key.startsWith(CONFIG_PREFIX)) continue;
                        String value = this.flinkConfig.getString(key, null);
                        String newKey = "fs.swift." + key.substring(CONFIG_PREFIX.length());
                        hadoopConfig.set(newKey, value);
                        LOG.debug("Adding Flink config entry for {} as {}={} to Hadoop config for Swift native File System", new Object[]{key, newKey, value});
                    }
                    this.hadoopConfig = hadoopConfig;
                } else {
                    LOG.warn("The factory has not been configured prior to loading the Swift native file system. Using Hadoop configuration from the classpath.");
                    this.hadoopConfig = hadoopConfig = new Configuration();
                }
            }
            String scheme = fsUri.getScheme();
            String authority = fsUri.getAuthority();
            if (scheme == null && authority == null) {
                fsUri = FileSystem.getDefaultUri(hadoopConfig);
            } else if (scheme != null && authority == null && scheme.equals((defaultUri = FileSystem.getDefaultUri(hadoopConfig)).getScheme()) && defaultUri.getAuthority() != null) {
                fsUri = defaultUri;
            }
            LOG.debug("Using scheme {} for swift file system backing the Swift Native File System", (Object)fsUri);
            SwiftNativeFileSystem fs = new SwiftNativeFileSystem();
            fs.initialize(fsUri, hadoopConfig);
            return new HadoopFileSystem(fs);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

