/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.scala;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Arrays;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.functions.AssignerWithPunctuatedWatermarks;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.api.scala.OutputTag;
import org.apache.flink.streaming.api.scala.OutputTag$;
import org.apache.flink.streaming.api.scala.SideOutputITCase$;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.streaming.api.scala.TestAssigner;
import org.apache.flink.streaming.api.scala.function.ProcessAllWindowFunction;
import org.apache.flink.streaming.api.scala.function.ProcessWindowFunction;
import org.apache.flink.streaming.api.windowing.assigners.TumblingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.test.streaming.runtime.util.TestListResultSink;
import org.apache.flink.test.util.AbstractTestBase;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001y2A!\u0001\u0002\u0001\u001f\t\u00012+\u001b3f\u001fV$\b/\u001e;J)\u000e\u000b7/\u001a\u0006\u0003\u0007\u0011\tQa]2bY\u0006T!!\u0002\u0004\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\b\u0011\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u0013)\tQA\u001a7j].T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0001\u0001\u0011!\t\tb#D\u0001\u0013\u0015\t\u0019B#\u0001\u0003vi&d'BA\u000b\t\u0003\u0011!Xm\u001d;\n\u0005]\u0011\"\u0001E!cgR\u0014\u0018m\u0019;UKN$()Y:f\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\t!\u0001C\u0003\u001f\u0001\u0011\u0005q$A\u000fuKN$\bK]8dKN\u001ch)\u001e8di&|gnU5eK>+H\u000f];u)\u0005\u0001\u0003CA\u0011$\u001b\u0005\u0011#\"A\u0002\n\u0005\u0011\u0012#\u0001B+oSRD#!\b\u0014\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0005%b\u0011!\u00026v]&$\u0018BA\u0016)\u0005\u0011!Vm\u001d;\t\u000b5\u0002A\u0011A\u0010\u0002EQ,7\u000f^&fs\u0016$\u0007K]8dKN\u001ch)\u001e8di&|gnU5eK>+H\u000f];uQ\tac\u0005C\u00031\u0001\u0011\u0005q$A\u0015uKN$\bK]8dKN\u001ch)\u001e8di&|gnU5eK>+H\u000f];u/&$\bn\u0016:p]\u001e$\u0016m\u001a\u0015\u0003_\u0019BQa\r\u0001\u0005\u0002}\tq\u0004^3ti\u0006cGnV5oI><H*\u0019;f\u0003J\u0014\u0018N^5oO\u00163XM\u001c;tQ\t\u0011d\u0005C\u00037\u0001\u0011\u0005q$A\u0011uKN$8*Z=fI^Kg\u000eZ8x\u0019\u0006$X-\u0011:sSZLgnZ#wK:$8\u000f\u000b\u00026M!)\u0011\b\u0001C\u0001?\u0005\u0019C/Z:u!J|7-Z:t/&tGm\\<Gk:\u001cG/[8o'&$WmT;uaV$\bF\u0001\u001d'\u0011\u0015a\u0004\u0001\"\u0001 \u0003\u0019\"Xm\u001d;Qe>\u001cWm]:BY2<\u0016N\u001c3po\u001a+hn\u0019;j_:\u001c\u0016\u000eZ3PkR\u0004X\u000f\u001e\u0015\u0003w\u0019\u0002")
public class SideOutputITCase
extends AbstractTestBase {
    @Test
    public void testProcessFunctionSideOutput() {
        TestListResultSink sideOutputResultSink = new TestListResultSink();
        TestListResultSink resultSink = new TestListResultSink();
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setParallelism(3);
        DataStream dataStream = env.fromElements((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 5, 3, 4}), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        OutputTag outputTag = OutputTag$.MODULE$.apply("side", (TypeInformation)BasicTypeInfo.getInfoFor(String.class));
        DataStream passThroughtStream = dataStream.process((ProcessFunction)new ProcessFunction<Object, Object>(null, outputTag){
            private final OutputTag outputTag$1;

            public void processElement(int value, ProcessFunction.Context ctx, Collector<Object> out) {
                out.collect((Object)BoxesRunTime.boxToInteger((int)value));
                ctx.output((org.apache.flink.util.OutputTag)this.outputTag$1, (Object)new StringBuilder(8).append("sideout-").append(String.valueOf(value)).toString());
            }
            {
                this.outputTag$1 = outputTag$1;
            }
        }, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        passThroughtStream.getSideOutput(outputTag, (TypeInformation)BasicTypeInfo.getInfoFor(String.class)).addSink((SinkFunction)sideOutputResultSink);
        passThroughtStream.addSink((SinkFunction)resultSink);
        env.execute();
        Assert.assertEquals(Arrays.asList((Object[])new String[]{"sideout-1", "sideout-2", "sideout-3", "sideout-4", "sideout-5"}), (Object)sideOutputResultSink.getSortedResult());
        Assert.assertEquals(Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)new int[]{1, 2, 3, 4, 5})), (Object)resultSink.getSortedResult());
    }

    @Test
    public void testKeyedProcessFunctionSideOutput() {
        TestListResultSink sideOutputResultSink = new TestListResultSink();
        TestListResultSink resultSink = new TestListResultSink();
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setParallelism(3);
        DataStream dataStream = env.fromElements((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 5, 3, 4}), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        OutputTag outputTag = OutputTag$.MODULE$.apply("side", (TypeInformation)BasicTypeInfo.getInfoFor(String.class));
        DataStream passThroughtStream = dataStream.keyBy((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x -> x, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE)).process((ProcessFunction)new ProcessFunction<Object, Object>(null, outputTag){
            private final OutputTag outputTag$2;

            public void processElement(int value, ProcessFunction.Context ctx, Collector<Object> out) {
                out.collect((Object)BoxesRunTime.boxToInteger((int)value));
                ctx.output((org.apache.flink.util.OutputTag)this.outputTag$2, (Object)new StringBuilder(8).append("sideout-").append(String.valueOf(value)).toString());
            }
            {
                this.outputTag$2 = outputTag$2;
            }
        }, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        passThroughtStream.getSideOutput(outputTag, (TypeInformation)BasicTypeInfo.getInfoFor(String.class)).addSink((SinkFunction)sideOutputResultSink);
        passThroughtStream.addSink((SinkFunction)resultSink);
        env.execute();
        Assert.assertEquals(Arrays.asList((Object[])new String[]{"sideout-1", "sideout-2", "sideout-3", "sideout-4", "sideout-5"}), (Object)sideOutputResultSink.getSortedResult());
        Assert.assertEquals(Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)new int[]{1, 2, 3, 4, 5})), (Object)resultSink.getSortedResult());
    }

    @Test
    public void testProcessFunctionSideOutputWithWrongTag() {
        TestListResultSink sideOutputResultSink = new TestListResultSink();
        TestListResultSink resultSink = new TestListResultSink();
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setParallelism(3);
        DataStream dataStream = env.fromElements((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 5, 3, 4}), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        OutputTag outputTag = OutputTag$.MODULE$.apply("side", (TypeInformation)BasicTypeInfo.getInfoFor(String.class));
        OutputTag otherOutputTag = OutputTag$.MODULE$.apply("other-side", (TypeInformation)BasicTypeInfo.getInfoFor(String.class));
        DataStream passThroughtStream = dataStream.process((ProcessFunction)new ProcessFunction<Object, Object>(null, otherOutputTag){
            private final OutputTag otherOutputTag$1;

            public void processElement(int value, ProcessFunction.Context ctx, Collector<Object> out) {
                ctx.output((org.apache.flink.util.OutputTag)this.otherOutputTag$1, (Object)new StringBuilder(8).append("sideout-").append(String.valueOf(value)).toString());
            }
            {
                this.otherOutputTag$1 = otherOutputTag$1;
            }
        }, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        passThroughtStream.getSideOutput(outputTag, (TypeInformation)BasicTypeInfo.getInfoFor(String.class)).addSink((SinkFunction)sideOutputResultSink);
        env.execute();
        Assert.assertTrue((boolean)sideOutputResultSink.getSortedResult().isEmpty());
    }

    @Test
    public void testAllWindowLateArrivingEvents() {
        TestListResultSink resultSink = new TestListResultSink();
        TestListResultSink lateResultSink = new TestListResultSink();
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setParallelism(1);
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        DataStream dataStream = env.fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"1", (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple2((Object)"2", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"5", (Object)BoxesRunTime.boxToInteger((int)5)), new Tuple2((Object)"3", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"4", (Object)BoxesRunTime.boxToInteger((int)4))}), (TypeInformation)new CaseClassTypeInfo<Tuple2<String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$12 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<String, Object>> unused = new ScalaCaseClassSerializer<Tuple2<String, Object>>(this, fieldSerializers){

                    public Tuple2<String, Object> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.streaming.api.scala.SideOutputITCase$$anon$12 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        OutputTag lateDataTag = OutputTag$.MODULE$.apply("late", (TypeInformation)new CaseClassTypeInfo<Tuple2<String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$13 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<String, Object>> unused = new ScalaCaseClassSerializer<Tuple2<String, Object>>(this, fieldSerializers){

                    public Tuple2<String, Object> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.streaming.api.scala.SideOutputITCase$$anon$13 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        DataStream windowOperator = dataStream.assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new TestAssigner()).windowAll((WindowAssigner)TumblingEventTimeWindows.of((Time)Time.milliseconds((long)1L))).sideOutputLateData(lateDataTag).process((ProcessAllWindowFunction)new ProcessAllWindowFunction<Tuple2<String, Object>, String, TimeWindow>(null){

            public void process(ProcessAllWindowFunction.Context context, Iterable<Tuple2<String, Object>> elements, Collector<String> out) {
                elements.foreach((Function1 & Serializable & scala.Serializable)in -> {
                    $anon$14.$anonfun$process$1(out, in);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$process$1(Collector out$1, Tuple2 in) {
                out$1.collect(in._1());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$process$1$adapted(org.apache.flink.util.Collector scala.Tuple2 )}, serializedLambda);
            }
        }, (TypeInformation)BasicTypeInfo.getInfoFor(String.class));
        windowOperator.getSideOutput(lateDataTag, (TypeInformation)new CaseClassTypeInfo<Tuple2<String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$15 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<String, Object>> unused = new ScalaCaseClassSerializer<Tuple2<String, Object>>(this, fieldSerializers){

                    public Tuple2<String, Object> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.streaming.api.scala.SideOutputITCase$$anon$15 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).addSink((SinkFunction)lateResultSink);
        windowOperator.addSink((SinkFunction)resultSink);
        env.execute();
        Assert.assertEquals(Arrays.asList((Object[])new String[]{"1", "2", "5"}), (Object)resultSink.getResult());
        Assert.assertEquals(Arrays.asList((Object[])new Tuple2[]{new Tuple2((Object)"3", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"4", (Object)BoxesRunTime.boxToInteger((int)4))}), (Object)lateResultSink.getResult());
    }

    @Test
    public void testKeyedWindowLateArrivingEvents() {
        TestListResultSink resultSink = new TestListResultSink();
        TestListResultSink lateResultSink = new TestListResultSink();
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setParallelism(1);
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        DataStream dataStream = env.fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"1", (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple2((Object)"2", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"5", (Object)BoxesRunTime.boxToInteger((int)5)), new Tuple2((Object)"3", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"4", (Object)BoxesRunTime.boxToInteger((int)4))}), (TypeInformation)new CaseClassTypeInfo<Tuple2<String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$16 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<String, Object>> unused = new ScalaCaseClassSerializer<Tuple2<String, Object>>(this, fieldSerializers){

                    public Tuple2<String, Object> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.streaming.api.scala.SideOutputITCase$$anon$16 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        OutputTag lateDataTag = OutputTag$.MODULE$.apply("late", (TypeInformation)new CaseClassTypeInfo<Tuple2<String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$17 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<String, Object>> unused = new ScalaCaseClassSerializer<Tuple2<String, Object>>(this, fieldSerializers){

                    public Tuple2<String, Object> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.streaming.api.scala.SideOutputITCase$$anon$17 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        DataStream windowOperator = dataStream.assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new TestAssigner()).keyBy((Function1 & Serializable & scala.Serializable)i -> (String)i._1(), (TypeInformation)BasicTypeInfo.getInfoFor(String.class)).window((WindowAssigner)TumblingEventTimeWindows.of((Time)Time.milliseconds((long)1L))).sideOutputLateData(lateDataTag).process((ProcessWindowFunction)new ProcessWindowFunction<Tuple2<String, Object>, String, String, TimeWindow>(null){

            public void process(String key, ProcessWindowFunction.Context context, Iterable<Tuple2<String, Object>> elements, Collector<String> out) {
                elements.foreach((Function1 & Serializable & scala.Serializable)in -> {
                    $anon$18.$anonfun$process$2(out, in);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$process$2(Collector out$2, Tuple2 in) {
                out$2.collect(in._1());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$process$2$adapted(org.apache.flink.util.Collector scala.Tuple2 )}, serializedLambda);
            }
        }, (TypeInformation)BasicTypeInfo.getInfoFor(String.class));
        windowOperator.getSideOutput(lateDataTag, (TypeInformation)new CaseClassTypeInfo<Tuple2<String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$19 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<String, Object>> unused = new ScalaCaseClassSerializer<Tuple2<String, Object>>(this, fieldSerializers){

                    public Tuple2<String, Object> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.streaming.api.scala.SideOutputITCase$$anon$19 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).addSink((SinkFunction)lateResultSink);
        windowOperator.addSink((SinkFunction)resultSink);
        env.execute();
        Assert.assertEquals(Arrays.asList((Object[])new String[]{"1", "2", "5"}), (Object)resultSink.getResult());
        Assert.assertEquals(Arrays.asList((Object[])new Tuple2[]{new Tuple2((Object)"3", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"4", (Object)BoxesRunTime.boxToInteger((int)4))}), (Object)lateResultSink.getResult());
    }

    @Test
    public void testProcessWindowFunctionSideOutput() {
        TestListResultSink resultSink = new TestListResultSink();
        TestListResultSink sideOutputResultSink = new TestListResultSink();
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setParallelism(1);
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        DataStream dataStream = env.fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"1", (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple2((Object)"2", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"5", (Object)BoxesRunTime.boxToInteger((int)5)), new Tuple2((Object)"3", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"4", (Object)BoxesRunTime.boxToInteger((int)4))}), (TypeInformation)new CaseClassTypeInfo<Tuple2<String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$20 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<String, Object>> unused = new ScalaCaseClassSerializer<Tuple2<String, Object>>(this, fieldSerializers){

                    public Tuple2<String, Object> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.streaming.api.scala.SideOutputITCase$$anon$20 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        OutputTag sideOutputTag = OutputTag$.MODULE$.apply("side", (TypeInformation)BasicTypeInfo.getInfoFor(String.class));
        DataStream windowOperator = dataStream.assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new TestAssigner()).keyBy((Function1 & Serializable & scala.Serializable)i -> (String)i._1(), (TypeInformation)BasicTypeInfo.getInfoFor(String.class)).window((WindowAssigner)TumblingEventTimeWindows.of((Time)Time.milliseconds((long)1L))).process((ProcessWindowFunction)new ProcessWindowFunction<Tuple2<String, Object>, String, String, TimeWindow>(null, sideOutputTag){
            private final OutputTag sideOutputTag$1;

            public void process(String key, ProcessWindowFunction.Context context, Iterable<Tuple2<String, Object>> elements, Collector<String> out) {
                elements.foreach((Function1 & Serializable & scala.Serializable)in -> {
                    $anon$21.$anonfun$process$3(this, context, out, in);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$process$3($anon$21 $this, ProcessWindowFunction.Context context$1, Collector out$3, Tuple2 in) {
                out$3.collect(in._1());
                context$1.output($this.sideOutputTag$1, (Object)new StringBuilder(8).append("sideout-").append(in._1()).toString());
            }
            {
                this.sideOutputTag$1 = sideOutputTag$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$process$3$adapted(org.apache.flink.streaming.api.scala.SideOutputITCase$$anon$21 org.apache.flink.streaming.api.scala.function.ProcessWindowFunction$Context org.apache.flink.util.Collector scala.Tuple2 )}, serializedLambda);
            }
        }, (TypeInformation)BasicTypeInfo.getInfoFor(String.class));
        windowOperator.getSideOutput(sideOutputTag, (TypeInformation)BasicTypeInfo.getInfoFor(String.class)).addSink((SinkFunction)sideOutputResultSink);
        windowOperator.addSink((SinkFunction)resultSink);
        env.execute();
        Assert.assertEquals(Arrays.asList((Object[])new String[]{"1", "2", "5"}), (Object)resultSink.getResult());
        Assert.assertEquals(Arrays.asList((Object[])new String[]{"sideout-1", "sideout-2", "sideout-5"}), (Object)sideOutputResultSink.getResult());
    }

    @Test
    public void testProcessAllWindowFunctionSideOutput() {
        TestListResultSink resultSink = new TestListResultSink();
        TestListResultSink sideOutputResultSink = new TestListResultSink();
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setParallelism(1);
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        DataStream dataStream = env.fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"1", (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple2((Object)"2", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"5", (Object)BoxesRunTime.boxToInteger((int)5)), new Tuple2((Object)"3", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"4", (Object)BoxesRunTime.boxToInteger((int)4))}), (TypeInformation)new CaseClassTypeInfo<Tuple2<String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$22 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$8[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<String, Object>> unused = new ScalaCaseClassSerializer<Tuple2<String, Object>>(this, fieldSerializers){

                    public Tuple2<String, Object> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$8(org.apache.flink.streaming.api.scala.SideOutputITCase$$anon$22 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        OutputTag sideOutputTag = OutputTag$.MODULE$.apply("side", (TypeInformation)BasicTypeInfo.getInfoFor(String.class));
        DataStream windowOperator = dataStream.assignTimestampsAndWatermarks((AssignerWithPunctuatedWatermarks)new TestAssigner()).windowAll((WindowAssigner)TumblingEventTimeWindows.of((Time)Time.milliseconds((long)1L))).process((ProcessAllWindowFunction)new ProcessAllWindowFunction<Tuple2<String, Object>, String, TimeWindow>(null, sideOutputTag){
            private final OutputTag sideOutputTag$2;

            public void process(ProcessAllWindowFunction.Context context, Iterable<Tuple2<String, Object>> elements, Collector<String> out) {
                elements.foreach((Function1 & Serializable & scala.Serializable)in -> {
                    $anon$23.$anonfun$process$4(this, context, out, in);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$process$4($anon$23 $this, ProcessAllWindowFunction.Context context$2, Collector out$4, Tuple2 in) {
                out$4.collect(in._1());
                context$2.output($this.sideOutputTag$2, (Object)new StringBuilder(8).append("sideout-").append(in._1()).toString());
            }
            {
                this.sideOutputTag$2 = sideOutputTag$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$process$4$adapted(org.apache.flink.streaming.api.scala.SideOutputITCase$$anon$23 org.apache.flink.streaming.api.scala.function.ProcessAllWindowFunction$Context org.apache.flink.util.Collector scala.Tuple2 )}, serializedLambda);
            }
        }, (TypeInformation)BasicTypeInfo.getInfoFor(String.class));
        windowOperator.getSideOutput(sideOutputTag, (TypeInformation)BasicTypeInfo.getInfoFor(String.class)).addSink((SinkFunction)sideOutputResultSink);
        windowOperator.addSink((SinkFunction)resultSink);
        env.execute();
        Assert.assertEquals(Arrays.asList((Object[])new String[]{"1", "2", "5"}), (Object)resultSink.getResult());
        Assert.assertEquals(Arrays.asList((Object[])new String[]{"sideout-1", "sideout-2", "sideout-5"}), (Object)sideOutputResultSink.getResult());
    }
}

