/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.scala;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.scala.AsyncDataStream$;
import org.apache.flink.streaming.api.scala.AsyncDataStreamITCase$;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.api.scala.MyAsyncFunction;
import org.apache.flink.streaming.api.scala.MyRichAsyncFunction;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.streaming.api.scala.async.AsyncFunction;
import org.apache.flink.test.util.AbstractTestBase;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function2;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001m<Q!\u0001\u0002\t\u0002=\tQ#Q:z]\u000e$\u0015\r^1TiJ,\u0017-\\%U\u0007\u0006\u001cXM\u0003\u0002\u0004\t\u0005)1oY1mC*\u0011QAB\u0001\u0004CBL'BA\u0004\t\u0003%\u0019HO]3b[&twM\u0003\u0002\n\u0015\u0005)a\r\\5oW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0001\"\u0001E\t\u000e\u0003\t1QA\u0005\u0002\t\u0002M\u0011Q#Q:z]\u000e$\u0015\r^1TiJ,\u0017-\\%U\u0007\u0006\u001cXm\u0005\u0002\u0012)A\u0011QcF\u0007\u0002-)\t1!\u0003\u0002\u0019-\t1\u0011I\\=SK\u001aDQAG\t\u0005\u0002m\ta\u0001P5oSRtD#A\b\t\u000fu\t\"\u0019!C\u0001=\u00059A/[7f_V$X#A\u0010\u0011\u0005U\u0001\u0013BA\u0011\u0017\u0005\u0011auN\\4\t\r\r\n\u0002\u0015!\u0003 \u0003!!\u0018.\\3pkR\u0004\u0003\"C\u0013\u0012\u0001\u0004\u0005\r\u0011\"\u0003'\u0003)!Xm\u001d;SKN,H\u000e^\u000b\u0002OA\u0019\u0001&L\u0018\u000e\u0003%R!AK\u0016\u0002\u000f5,H/\u00192mK*\u0011AFF\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u0018*\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0005U\u0001\u0014BA\u0019\u0017\u0005\rIe\u000e\u001e\u0005\ngE\u0001\r\u00111A\u0005\nQ\na\u0002^3tiJ+7/\u001e7u?\u0012*\u0017\u000f\u0006\u00026qA\u0011QCN\u0005\u0003oY\u0011A!\u00168ji\"9\u0011HMA\u0001\u0002\u00049\u0013a\u0001=%c!I1(\u0005a\u0001\u0002\u0003\u0006KaJ\u0001\fi\u0016\u001cHOU3tk2$\bE\u0002\u0003\u0013\u0005\u0001i4C\u0001\u001f?!\tyD)D\u0001A\u0015\t\t%)\u0001\u0003vi&d'BA\"\t\u0003\u0011!Xm\u001d;\n\u0005\u0015\u0003%\u0001E!cgR\u0014\u0018m\u0019;UKN$()Y:f\u0011\u0015QB\b\"\u0001H)\u0005A\u0005C\u0001\t=\u0011\u0015QE\b\"\u0001L\u0003=!Xm\u001d;Pe\u0012,'/\u001a3XC&$H#A\u001b)\u0005%k\u0005C\u0001(R\u001b\u0005y%B\u0001)\r\u0003\u0015QWO\\5u\u0013\t\u0011vJ\u0001\u0003UKN$\b\"\u0002+=\t\u0003Y\u0015!\u0005;fgR,fn\u001c:eKJ,GmV1ji\"\u00121+\u0014\u0005\u0006/r\"I\u0001W\u0001\u000ei\u0016\u001cH/Q:z]\u000e<\u0016-\u001b;\u0015\u0005UJ\u0006\"\u0002.W\u0001\u0004Y\u0016aB8sI\u0016\u0014X\r\u001a\t\u0003+qK!!\u0018\f\u0003\u000f\t{w\u000e\\3b]\")q\f\u0010C\u0005A\u0006\u0011R\r_3dkR,\u0017I\u001c3WC2LG-\u0019;f)\u0015)\u0014MY4m\u0011\u0015Qf\f1\u0001\\\u0011\u0015\u0019g\f1\u0001e\u0003\r)gN\u001e\t\u0003!\u0015L!A\u001a\u0002\u00035M#(/Z1n\u000bb,7-\u001e;j_:,eN^5s_:lWM\u001c;\t\u000b!t\u0006\u0019A5\u0002\u0015\u0011\fG/Y*ue\u0016\fW\u000eE\u0002\u0011U>J!a\u001b\u0002\u0003\u0015\u0011\u000bG/Y*ue\u0016\fW\u000eC\u0003n=\u0002\u0007q%\u0001\bfqB,7\r^3e%\u0016\u001cX\u000f\u001c;\t\u000b=dD\u0011A&\u0002KQ,7\u000f^(sI\u0016\u0014X\rZ,bSR,6/\u001b8h\u0003:|g._7pkN4UO\\2uS>t\u0007F\u00018N\u0011\u0015\u0011H\b\"\u0001L\u0003\u001d\"Xm\u001d;V]>\u0014H-\u001a:fI^\u000b\u0017\u000e^+tS:<\u0017I\\8os6|Wo\u001d$v]\u000e$\u0018n\u001c8)\u0005El\u0005\"B;=\t\u0003Y\u0015a\t;fgR\u0014\u0016n\u00195Bgft7MR;oGRLwN\u001c*v]RLW.Z\"p]R,\u0007\u0010\u001e\u0015\u0003i6CQ\u0001\u001f\u001f\u0005\ne\f1\u0005^3ti\u0006\u001b\u0018P\\2XC&$Xk]5oO\u0006swN\\=n_V\u001ch)\u001e8di&|g\u000e\u0006\u00026u\")!l\u001ea\u00017\u0002")
public class AsyncDataStreamITCase
extends AbstractTestBase {
    public static long timeout() {
        return AsyncDataStreamITCase$.MODULE$.timeout();
    }

    @Test
    public void testOrderedWait() {
        this.testAsyncWait(true);
    }

    @Test
    public void testUnorderedWait() {
        this.testAsyncWait(false);
    }

    private void testAsyncWait(boolean ordered) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setParallelism(1);
        DataStream source = env.fromElements((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        DataStream asyncMapped = ordered ? AsyncDataStream$.MODULE$.orderedWait(source, (AsyncFunction)new MyAsyncFunction(), AsyncDataStreamITCase$.MODULE$.timeout(), TimeUnit.MILLISECONDS, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE)) : AsyncDataStream$.MODULE$.unorderedWait(source, (AsyncFunction)new MyAsyncFunction(), AsyncDataStreamITCase$.MODULE$.timeout(), TimeUnit.MILLISECONDS, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        this.executeAndValidate(ordered, env, (DataStream<Object>)asyncMapped, (ArrayBuffer<Object>)((ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 6}))));
    }

    private void executeAndValidate(boolean ordered, StreamExecutionEnvironment env, DataStream<Object> dataStream, ArrayBuffer<Object> expectedResult) {
        AsyncDataStreamITCase$.MODULE$.org$apache$flink$streaming$api$scala$AsyncDataStreamITCase$$testResult_$eq((ArrayBuffer<Object>)((ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
        dataStream.addSink((SinkFunction)new SinkFunction<Object>(null){

            public void invoke(Object x$1, SinkFunction.Context x$2) throws Exception {
                super.invoke(x$1, x$2);
            }

            public void invoke(int value) {
                AsyncDataStreamITCase$.MODULE$.org$apache$flink$streaming$api$scala$AsyncDataStreamITCase$$testResult().$plus$eq((Object)BoxesRunTime.boxToInteger((int)value));
            }
        });
        env.execute("testAsyncDataStream");
        if (ordered) {
            Assert.assertEquals(expectedResult, AsyncDataStreamITCase$.MODULE$.org$apache$flink$streaming$api$scala$AsyncDataStreamITCase$$testResult());
        } else {
            Assert.assertEquals(expectedResult, (Object)AsyncDataStreamITCase$.MODULE$.org$apache$flink$streaming$api$scala$AsyncDataStreamITCase$$testResult().sorted((Ordering)Ordering.Int$.MODULE$));
        }
    }

    @Test
    public void testOrderedWaitUsingAnonymousFunction() {
        this.testAsyncWaitUsingAnonymousFunction(true);
    }

    @Test
    public void testUnorderedWaitUsingAnonymousFunction() {
        this.testAsyncWaitUsingAnonymousFunction(false);
    }

    @Test
    public void testRichAsyncFunctionRuntimeContext() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setParallelism(1);
        DataStream source = env.fromElements((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        MyRichAsyncFunction richAsyncFunction = new MyRichAsyncFunction();
        DataStream asyncMapped = AsyncDataStream$.MODULE$.unorderedWait(source, (AsyncFunction)richAsyncFunction, AsyncDataStreamITCase$.MODULE$.timeout(), TimeUnit.MILLISECONDS, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        this.executeAndValidate(false, env, (DataStream<Object>)asyncMapped, (ArrayBuffer<Object>)((ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}))));
    }

    private void testAsyncWaitUsingAnonymousFunction(boolean ordered) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setParallelism(1);
        DataStream source = env.fromElements((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        Function2 & Serializable & scala.Serializable asyncFunction = (Function2 & Serializable & scala.Serializable)(input, collector) -> {
            Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> collector.complete((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{BoxesRunTime.unboxToInt((Object)input) * 2}))), (ExecutionContext)ExecutionContext$.MODULE$.global());
            return BoxedUnit.UNIT;
        };
        DataStream asyncMapped = ordered ? AsyncDataStream$.MODULE$.orderedWait(source, AsyncDataStreamITCase$.MODULE$.timeout(), TimeUnit.MILLISECONDS, (Function2)asyncFunction, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE)) : AsyncDataStream$.MODULE$.unorderedWait(source, AsyncDataStreamITCase$.MODULE$.timeout(), TimeUnit.MILLISECONDS, (Function2)asyncFunction, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        this.executeAndValidate(ordered, env, (DataStream<Object>)asyncMapped, (ArrayBuffer<Object>)((ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}))));
    }
}

