/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.scala;

import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.scala.CoGroupedStreams;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.streaming.api.windowing.assigners.TumblingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001\u001f\t!2i\\$s_V\u0004X\rZ*ue\u0016\fWn\u001d+fgRT!a\u0001\u0003\u0002\u000bM\u001c\u0017\r\\1\u000b\u0005\u00151\u0011aA1qS*\u0011q\u0001C\u0001\ngR\u0014X-Y7j]\u001eT!!\u0003\u0006\u0002\u000b\u0019d\u0017N\\6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012'5\t!CC\u0001\u0004\u0013\t!\"C\u0001\u0004B]f\u0014VM\u001a\u0005\u0006-\u0001!\taF\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003a\u0001\"!\u0007\u0001\u000e\u0003\tAqa\u0007\u0001C\u0002\u0013%A$A\u0002f]Z,\u0012!\b\t\u00033yI!a\b\u0002\u00035M#(/Z1n\u000bb,7-\u001e;j_:,eN^5s_:lWM\u001c;\t\r\u0005\u0002\u0001\u0015!\u0003\u001e\u0003\u0011)gN\u001e\u0011\t\u000f\r\u0002!\u0019!C\u0005I\u0005YA-\u0019;b'R\u0014X-Y72+\u0005)\u0003cA\r'Q%\u0011qE\u0001\u0002\u000b\t\u0006$\u0018m\u0015;sK\u0006l\u0007CA\u0015/\u001b\u0005Q#BA\u0016-\u0003\u0011a\u0017M\\4\u000b\u00035\nAA[1wC&\u0011qF\u000b\u0002\u0007'R\u0014\u0018N\\4\t\rE\u0002\u0001\u0015!\u0003&\u00031!\u0017\r^1TiJ,\u0017-\\\u0019!\u0011\u001d\u0019\u0004A1A\u0005\n\u0011\n1\u0002Z1uCN#(/Z1ne!1Q\u0007\u0001Q\u0001\n\u0015\nA\u0002Z1uCN#(/Z1ne\u0001Bqa\u000e\u0001C\u0002\u0013%\u0001(A\u0006lKf\u001cV\r\\3di>\u0014X#A\u001d\u0011\tEQD\bP\u0005\u0003wI\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0005u\"eB\u0001 C!\ty$#D\u0001A\u0015\t\te\"\u0001\u0004=e>|GOP\u0005\u0003\u0007J\ta\u0001\u0015:fI\u00164\u0017BA\u0018F\u0015\t\u0019%\u0003\u0003\u0004H\u0001\u0001\u0006I!O\u0001\rW\u0016L8+\u001a7fGR|'\u000f\t\u0005\b\u0013\u0002\u0011\r\u0011\"\u0003K\u0003)!8/Q:tS\u001etWM]\u000b\u0002\u0017B\u0011A*U\u0007\u0002\u001b*\u0011ajT\u0001\nCN\u001c\u0018n\u001a8feNT!\u0001\u0015\u0003\u0002\u0013]Lg\u000eZ8xS:<\u0017B\u0001*N\u0005a!V/\u001c2mS:<WI^3oiRKW.Z,j]\u0012|wo\u001d\u0005\u0007)\u0002\u0001\u000b\u0011B&\u0002\u0017Q\u001c\u0018i]:jO:,'\u000f\t\u0005\u0006-\u0002!\taV\u0001\u0017i\u0016\u001cHoU3u\u00032dwn^3e\u0019\u0006$XM\\3tgR\t\u0001\f\u0005\u0002\u00123&\u0011!L\u0005\u0002\u0005+:LG\u000f\u000b\u0002V9B\u0011Q\fY\u0007\u0002=*\u0011q\fD\u0001\u0006UVt\u0017\u000e^\u0005\u0003Cz\u0013A\u0001V3ti\u0002")
public class CoGroupedStreamsTest {
    private final StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
    private final DataStream<String> dataStream1 = this.env().fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a1", "a2", "a3"}), (TypeInformation)BasicTypeInfo.getInfoFor(String.class));
    private final DataStream<String> dataStream2 = this.env().fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a1", "a2"}), (TypeInformation)BasicTypeInfo.getInfoFor(String.class));
    private final Function1<String, String> keySelector = (Function1 & java.io.Serializable & Serializable)s -> s;
    private final TumblingEventTimeWindows tsAssigner = TumblingEventTimeWindows.of((Time)Time.milliseconds((long)1L));

    private StreamExecutionEnvironment env() {
        return this.env;
    }

    private DataStream<String> dataStream1() {
        return this.dataStream1;
    }

    private DataStream<String> dataStream2() {
        return this.dataStream2;
    }

    private Function1<String, String> keySelector() {
        return this.keySelector;
    }

    private TumblingEventTimeWindows tsAssigner() {
        return this.tsAssigner;
    }

    @Test
    public void testSetAllowedLateness() {
        Time lateness = Time.milliseconds((long)42L);
        CoGroupedStreams.Where.EqualTo.WithWindow withLateness = this.dataStream1().coGroup(this.dataStream2()).where(this.keySelector(), (TypeInformation)BasicTypeInfo.getInfoFor(String.class)).equalTo(this.keySelector()).window((WindowAssigner)this.tsAssigner()).allowedLateness(lateness);
        Assert.assertEquals((long)lateness.toMilliseconds(), (long)withLateness.allowedLateness().toMilliseconds());
    }
}

