/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.scala;

import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.api.scala.JoinedStreams;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.streaming.api.windowing.assigners.TumblingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001\u001f\t\t\"j\\5oK\u0012\u001cFO]3b[N$Vm\u001d;\u000b\u0005\r!\u0011!B:dC2\f'BA\u0003\u0007\u0003\r\t\u0007/\u001b\u0006\u0003\u000f!\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005%Q\u0011!\u00024mS:\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011cE\u0007\u0002%)\t1!\u0003\u0002\u0015%\t1\u0011I\\=SK\u001aDQA\u0006\u0001\u0005\u0002]\ta\u0001P5oSRtD#\u0001\r\u0011\u0005e\u0001Q\"\u0001\u0002\t\u000fm\u0001!\u0019!C\u00059\u0005\u0019QM\u001c<\u0016\u0003u\u0001\"!\u0007\u0010\n\u0005}\u0011!AG*ue\u0016\fW.\u0012=fGV$\u0018n\u001c8F]ZL'o\u001c8nK:$\bBB\u0011\u0001A\u0003%Q$\u0001\u0003f]Z\u0004\u0003bB\u0012\u0001\u0005\u0004%I\u0001J\u0001\fI\u0006$\u0018m\u0015;sK\u0006l\u0017'F\u0001&!\rIb\u0005K\u0005\u0003O\t\u0011!\u0002R1uCN#(/Z1n!\tIc&D\u0001+\u0015\tYC&\u0001\u0003mC:<'\"A\u0017\u0002\t)\fg/Y\u0005\u0003_)\u0012aa\u0015;sS:<\u0007BB\u0019\u0001A\u0003%Q%\u0001\u0007eCR\f7\u000b\u001e:fC6\f\u0004\u0005C\u00044\u0001\t\u0007I\u0011\u0002\u0013\u0002\u0017\u0011\fG/Y*ue\u0016\fWN\r\u0005\u0007k\u0001\u0001\u000b\u0011B\u0013\u0002\u0019\u0011\fG/Y*ue\u0016\fWN\r\u0011\t\u000f]\u0002!\u0019!C\u0005q\u0005Y1.Z=TK2,7\r^8s+\u0005I\u0004\u0003B\t;yqJ!a\u000f\n\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CA\u001fE\u001d\tq$\t\u0005\u0002@%5\t\u0001I\u0003\u0002B\u001d\u00051AH]8pizJ!a\u0011\n\u0002\rA\u0013X\rZ3g\u0013\tySI\u0003\u0002D%!1q\t\u0001Q\u0001\ne\nAb[3z'\u0016dWm\u0019;pe\u0002Bq!\u0013\u0001C\u0002\u0013%!*\u0001\u0006ug\u0006\u001b8/[4oKJ,\u0012a\u0013\t\u0003\u0019Fk\u0011!\u0014\u0006\u0003\u001d>\u000b\u0011\"Y:tS\u001etWM]:\u000b\u0005A#\u0011!C<j]\u0012|w/\u001b8h\u0013\t\u0011VJ\u0001\rUk6\u0014G.\u001b8h\u000bZ,g\u000e\u001e+j[\u0016<\u0016N\u001c3poNDa\u0001\u0016\u0001!\u0002\u0013Y\u0015a\u0003;t\u0003N\u001c\u0018n\u001a8fe\u0002BQA\u0016\u0001\u0005\u0002]\u000ba\u0003^3tiN+G/\u00117m_^,G\rT1uK:,7o\u001d\u000b\u00021B\u0011\u0011#W\u0005\u00035J\u0011A!\u00168ji\"\u0012Q\u000b\u0018\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?2\tQA[;oSRL!!\u00190\u0003\tQ+7\u000f\u001e")
public class JoinedStreamsTest {
    private final StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
    private final DataStream<String> dataStream1 = this.env().fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a1", "a2", "a3"}), (TypeInformation)BasicTypeInfo.getInfoFor(String.class));
    private final DataStream<String> dataStream2 = this.env().fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a1", "a2"}), (TypeInformation)BasicTypeInfo.getInfoFor(String.class));
    private final Function1<String, String> keySelector = (Function1 & java.io.Serializable & Serializable)s -> s;
    private final TumblingEventTimeWindows tsAssigner = TumblingEventTimeWindows.of((Time)Time.milliseconds((long)1L));

    private StreamExecutionEnvironment env() {
        return this.env;
    }

    private DataStream<String> dataStream1() {
        return this.dataStream1;
    }

    private DataStream<String> dataStream2() {
        return this.dataStream2;
    }

    private Function1<String, String> keySelector() {
        return this.keySelector;
    }

    private TumblingEventTimeWindows tsAssigner() {
        return this.tsAssigner;
    }

    @Test
    public void testSetAllowedLateness() {
        Time lateness = Time.milliseconds((long)42L);
        JoinedStreams.Where.EqualTo.WithWindow withLateness = this.dataStream1().join(this.dataStream2()).where(this.keySelector(), (TypeInformation)BasicTypeInfo.getInfoFor(String.class)).equalTo(this.keySelector()).window((WindowAssigner)this.tsAssigner()).allowedLateness(lateness);
        Assert.assertEquals((long)lateness.toMilliseconds(), (long)withLateness.allowedLateness().toMilliseconds());
    }
}

