/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.scala;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.io.ParallelIteratorInputFormat;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.functions.co.CoMapFunction;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.KeyedProcessOperator;
import org.apache.flink.streaming.api.operators.LegacyKeyedProcessOperator;
import org.apache.flink.streaming.api.operators.ProcessOperator;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.scala.ConnectedStreams;
import org.apache.flink.streaming.api.scala.CustomCaseClass;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.api.scala.DataStreamTest$;
import org.apache.flink.streaming.api.scala.KeyedStream;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.streaming.api.windowing.assigners.GlobalWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.triggers.CountTrigger;
import org.apache.flink.streaming.api.windowing.triggers.PurgingTrigger;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.windows.GlobalWindow;
import org.apache.flink.streaming.runtime.partitioner.BroadcastPartitioner;
import org.apache.flink.streaming.runtime.partitioner.CustomPartitionerWrapper;
import org.apache.flink.streaming.runtime.partitioner.ForwardPartitioner;
import org.apache.flink.streaming.runtime.partitioner.GlobalPartitioner;
import org.apache.flink.streaming.runtime.partitioner.KeyGroupStreamPartitioner;
import org.apache.flink.streaming.runtime.partitioner.RebalancePartitioner;
import org.apache.flink.streaming.runtime.partitioner.ShufflePartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.test.util.AbstractTestBase;
import org.apache.flink.util.Collector;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple1;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001B\u0001\u0003\u0001=\u0011a\u0002R1uCN#(/Z1n)\u0016\u001cHO\u0003\u0002\u0004\t\u0005)1oY1mC*\u0011QAB\u0001\u0004CBL'BA\u0004\t\u0003%\u0019HO]3b[&twM\u0003\u0002\n\u0015\u0005)a\r\\5oW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E1R\"\u0001\n\u000b\u0005M!\u0012\u0001B;uS2T!!\u0006\u0005\u0002\tQ,7\u000f^\u0005\u0003/I\u0011\u0001#\u00112tiJ\f7\r\u001e+fgR\u0014\u0015m]3\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001b\u0002\u0010\u0001\u0005\u0004%IaH\u0001\u0012Kb\u0004Xm\u0019;fI\u0016C8-\u001a9uS>tW#\u0001\u0011\u0011\u0005\u00052S\"\u0001\u0012\u000b\u0005\r\"\u0013!\u0002:vY\u0016\u001c(BA\u0013\r\u0003\u0015QWO\\5u\u0013\t9#EA\tFqB,7\r^3e\u000bb\u001cW\r\u001d;j_:Da!\u000b\u0001!\u0002\u0013\u0001\u0013AE3ya\u0016\u001cG/\u001a3Fq\u000e,\u0007\u000f^5p]\u0002BQa\u000b\u0001\u0005\u0002}\tq\u0002\u001e5s_^tW\t_2faRLwN\u001c\u0015\u0003U5\u0002\"AL\u0018\u000e\u0003\u0011J!\u0001\r\u0013\u0003\tI+H.\u001a\u0005\u0006e\u0001!\taM\u0001\u000bi\u0016\u001cHOT1nS:<G#\u0001\u001b\u0011\u0005U:T\"\u0001\u001c\u000b\u0003\rI!\u0001\u000f\u001c\u0003\tUs\u0017\u000e\u001e\u0015\u0003ci\u0002\"AL\u001e\n\u0005q\"#\u0001\u0002+fgRDQA\u0010\u0001\u0005\u0002M\n\u0001\u0003^3tiB\u000b'\u000f^5uS>t\u0017N\\4)\u0005uR\u0004\"B!\u0001\t\u0003\u0019\u0014a\u0004;fgR\u0004\u0016M]1mY\u0016d\u0017n]7)\u0005\u0001S\u0004\"\u0002#\u0001\t\u0003\u0019\u0014\u0001\n;fgR\u0004\u0016M]1mY\u0016d\u0017n]7GC&d\u0017I\u001a;feB\u000b'\u000f^5uS>t\u0017N\\4)\u0005\rS\u0004\"B$\u0001\t\u0003\u0019\u0014\u0001\u0004;fgR$\u0016\u0010]3J]\u001a|\u0007F\u0001$;\u0011\u0015Q\u0005\u0001\"\u00014\u0003\u0005\"Xm\u001d;LKf,Gm\u0015;sK\u0006l\u0007K]8dKN\u001cHK]1og2\fG/[8oQ\tI%\bC\u0003N\u0001\u0011\u00051'\u0001\u0014uKN$8*Z=fIN#(/Z1n\u0017\u0016LX\r\u001a)s_\u000e,7o\u001d+sC:\u001cH.\u0019;j_:D#\u0001\u0014\u001e\t\u000bA\u0003A\u0011A\u001a\u0002-Q,7\u000f\u001e)s_\u000e,7o\u001d+sC:\u001cH.\u0019;j_:D#a\u0014\u001e\t\u000bM\u0003A\u0011A\u001a\u0002\u0019=\u0004XM]1u_J$Vm\u001d;)\u0005IS\u0004\"\u0002,\u0001\t\u0003\u0019\u0014\u0001\u0006;fgR\u001c\u0005.\u00198oK2\u001cV\r\\3di>\u00148\u000f\u000b\u0002Vu!)\u0011\f\u0001C\u0001g\u0005qA/Z:u\u0013R,'/\u0019;j_:\u001c\bF\u0001-;\u0011\u0015a\u0006\u0001\"\u00014\u0003}!Xm\u001d;De\u0016\fG/Z%oaV$\b+Y:tKN|e\u000eV=qK&sgm\u001c\u0015\u00037jBQa\u0018\u0001\u0005\n\u0001\f\u0001dZ3u\rVt7\r^5p]\u001a{'\u000fR1uCN#(/Z1n)\t\t'\u000e\u0005\u0002cQ6\t1M\u0003\u0002eK\u0006Ia-\u001e8di&|gn\u001d\u0006\u0003M\u001e\faaY8n[>t'BA\u0003\t\u0013\tI7M\u0001\u0005Gk:\u001cG/[8o\u0011\u0015Yg\f1\u0001m\u0003)!\u0017\r^1TiJ,\u0017-\u001c\u0019\u0003[J\u00042\u0001\b8q\u0013\ty'A\u0001\u0006ECR\f7\u000b\u001e:fC6\u0004\"!\u001d:\r\u0001\u0011I1O[A\u0001\u0002\u0003\u0015\t\u0001\u001e\u0002\u0005?\u0012\"d'\u0005\u0002vqB\u0011QG^\u0005\u0003oZ\u0012qAT8uQ&tw\r\u0005\u00026s&\u0011!P\u000e\u0002\u0004\u0003:L\b\"\u0002?\u0001\t\u0013i\u0018\u0001G4fi>\u0003XM]1u_J4uN\u001d#bi\u0006\u001cFO]3b[R\u0019a0!\u00051\u0007}\fi\u0001\u0005\u0004\u0002\u0002\u0005\u001d\u00111B\u0007\u0003\u0003\u0007Q1!!\u0002\u0005\u0003%y\u0007/\u001a:bi>\u00148/\u0003\u0003\u0002\n\u0005\r!AD*ue\u0016\fWn\u00149fe\u0006$xN\u001d\t\u0004c\u00065AACA\bw\u0006\u0005\t\u0011!B\u0001i\n!q\fJ\u001b1\u0011\u0019Y7\u00101\u0001\u0002\u0014A\"\u0011QCA\r!\u0011ab.a\u0006\u0011\u0007E\fI\u0002B\u0006\u0002\u001c\u0005E\u0011\u0011!A\u0001\u0006\u0003!(\u0001B0%ieBq!a\b\u0001\t\u0013\t\t#\u0001\bhKR\u001cFO]3b[\u001e\u0013\u0018\r\u001d5\u0015\t\u0005\r\u0012q\u0006\t\u0005\u0003K\tY#\u0004\u0002\u0002()\u0019\u0011\u0011\u0006\u0003\u0002\u000b\u001d\u0014\u0018\r\u001d5\n\t\u00055\u0012q\u0005\u0002\f'R\u0014X-Y7He\u0006\u0004\b\u000e\u0003\u0005\u00022\u0005u\u0001\u0019AA\u001a\u0003\u0011\u0019XI\u001c<\u0011\u0007q\t)$C\u0002\u00028\t\u0011!d\u0015;sK\u0006lW\t_3dkRLwN\\#om&\u0014xN\\7f]RDq!a\u000f\u0001\t\u0013\ti$A\u0007jgB\u000b'\u000f^5uS>tW\r\u001a\u000b\u0005\u0003\u007f\t)\u0005E\u00026\u0003\u0003J1!a\u00117\u0005\u001d\u0011un\u001c7fC:D\u0001\"a\u0012\u0002:\u0001\u0007\u0011\u0011J\u0001\u0006K\u0012<Wm\u001d\t\u0007\u0003\u0017\n\u0019&a\u0016\u000e\u0005\u00055#bA\n\u0002P)\u0011\u0011\u0011K\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002V\u00055#\u0001\u0002'jgR\u0004B!!\n\u0002Z%!\u00111LA\u0014\u0005)\u0019FO]3b[\u0016#w-\u001a\u0005\b\u0003?\u0002A\u0011BA1\u0003MI7oQ;ti>l\u0007+\u0019:uSRLwN\\3e)\u0011\ty$a\u0019\t\u0011\u0005\u001d\u0013Q\fa\u0001\u0003\u0013Bq!a\u001a\u0001\t\u0013\tI'\u0001\nde\u0016\fG/\u001a#po:\u001cFO]3b[&#G\u0003BA6\u0003o\u0002B!!\u001c\u0002t5\u0011\u0011q\u000e\u0006\u0005\u0003c\ny%\u0001\u0003mC:<\u0017\u0002BA;\u0003_\u0012q!\u00138uK\u001e,'\u000fC\u0004l\u0003K\u0002\r!!\u001f1\t\u0005m\u0014q\u0010\t\u000599\fi\bE\u0002r\u0003\u007f\"1\"!!\u0002x\u0005\u0005\t\u0011!B\u0001i\n!q\fJ\u001b6\u0011\u001d\t9\u0007\u0001C\u0005\u0003\u000b#B!a\u001b\u0002\b\"91.a!A\u0002\u0005%\u0005GBAF\u0003'\u000bI\nE\u0004\u001d\u0003\u001b\u000b\t*a&\n\u0007\u0005=%A\u0001\tD_:tWm\u0019;fIN#(/Z1ngB\u0019\u0011/a%\u0005\u0017\u0005U\u0015qQA\u0001\u0002\u0003\u0015\t\u0001\u001e\u0002\u0005?\u0012*d\u0007E\u0002r\u00033#1\"a'\u0002\b\u0006\u0005\t\u0011!B\u0001i\n!q\fJ\u001b8\u0001")
public class DataStreamTest
extends AbstractTestBase {
    private final ExpectedException expectedException = ExpectedException.none();

    private ExpectedException expectedException() {
        return this.expectedException;
    }

    @Rule
    public ExpectedException thrownException() {
        return this.expectedException();
    }

    @Test
    public void testNaming() {
        DataStream source1Operator;
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataStream source1 = source1Operator = env.generateSequence(0L, 0L).name("testSource1");
        Predef$.MODULE$.assert("testSource1".equals(source1Operator.getName()));
        DataStream dataStream1 = source1.map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x -> 0L, (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE)).name("testMap");
        Predef$.MODULE$.assert("testMap".equals(dataStream1.getName()));
        DataStream dataStream2 = env.generateSequence(0L, 0L).name("testSource2").keyBy((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x -> x, (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE)).reduce((Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x, y) -> 0L).name("testReduce");
        Predef$.MODULE$.assert("testReduce".equals(dataStream2.getName()));
        DataStream connected = dataStream1.connect(dataStream2).flatMap((Function2 & Serializable & scala.Serializable)(in, out) -> {
            DataStreamTest.$anonfun$testNaming$4(BoxesRunTime.unboxToLong((Object)in), out);
            return BoxedUnit.UNIT;
        }, (Function2 & Serializable & scala.Serializable)(in, out) -> {
            DataStreamTest.$anonfun$testNaming$5(BoxesRunTime.unboxToLong((Object)in), out);
            return BoxedUnit.UNIT;
        }, (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$13 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.streaming.api.scala.DataStreamTest$$anon$13 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).name("testCoFlatMap");
        Predef$.MODULE$.assert("testCoFlatMap".equals(connected.getName()));
        Function2 & Serializable & scala.Serializable func = (Function2 & Serializable & scala.Serializable)(x, y) -> new Tuple2.mcJJ.sp(0L, 0L);
        DataStream windowed = connected.windowAll((WindowAssigner)GlobalWindows.create()).trigger((Trigger)PurgingTrigger.of((Trigger)CountTrigger.of((long)10L))).reduce((Function2)func);
        windowed.name("testWindowReduce");
        Predef$.MODULE$.assert("testWindowReduce".equals(windowed.getName()));
        windowed.print();
        String plan = env.getExecutionPlan();
        Predef$.MODULE$.assert(plan.contains("testSource1"));
        Predef$.MODULE$.assert(plan.contains("testSource2"));
        Predef$.MODULE$.assert(plan.contains("testMap"));
        Predef$.MODULE$.assert(plan.contains("testReduce"));
        Predef$.MODULE$.assert(plan.contains("testCoFlatMap"));
        Predef$.MODULE$.assert(plan.contains("testWindowReduce"));
    }

    @Test
    public void testPartitioning() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataStream src1 = env.fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(0L, 0L)}), (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$14 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.streaming.api.scala.DataStreamTest$$anon$14 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        DataStream src2 = env.fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(0L, 0L)}), (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$15 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.streaming.api.scala.DataStreamTest$$anon$15 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        ConnectedStreams connected = src1.connect(src2);
        KeyedStream group1 = src1.keyBy((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        KeyedStream group2 = src1.keyBy((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0}));
        KeyedStream group3 = src1.keyBy("_1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        KeyedStream group4 = src1.keyBy((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToLong((long)x._1$mcJ$sp()), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE));
        Integer gid1 = this.createDownStreamId((DataStream<?>)group1);
        Integer gid2 = this.createDownStreamId((DataStream<?>)group2);
        Integer gid3 = this.createDownStreamId((DataStream<?>)group3);
        Integer gid4 = this.createDownStreamId((DataStream<?>)group4);
        Predef$.MODULE$.assert(this.isPartitioned(this.getStreamGraph(env).getStreamEdgesOrThrow(src1.getId(), Predef$.MODULE$.Integer2int(gid1))));
        Predef$.MODULE$.assert(this.isPartitioned(this.getStreamGraph(env).getStreamEdgesOrThrow(src1.getId(), Predef$.MODULE$.Integer2int(gid2))));
        Predef$.MODULE$.assert(this.isPartitioned(this.getStreamGraph(env).getStreamEdgesOrThrow(src1.getId(), Predef$.MODULE$.Integer2int(gid3))));
        Predef$.MODULE$.assert(this.isPartitioned(this.getStreamGraph(env).getStreamEdgesOrThrow(src1.getId(), Predef$.MODULE$.Integer2int(gid4))));
        KeyedStream partition1 = src1.keyBy((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        KeyedStream partition2 = src1.keyBy((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0}));
        KeyedStream partition3 = src1.keyBy("_1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        KeyedStream partition4 = src1.keyBy((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToLong((long)x._1$mcJ$sp()), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE));
        Integer pid1 = this.createDownStreamId((DataStream<?>)partition1);
        Integer pid2 = this.createDownStreamId((DataStream<?>)partition2);
        Integer pid3 = this.createDownStreamId((DataStream<?>)partition3);
        Integer pid4 = this.createDownStreamId((DataStream<?>)partition4);
        Predef$.MODULE$.assert(this.isPartitioned(this.getStreamGraph(env).getStreamEdgesOrThrow(src1.getId(), Predef$.MODULE$.Integer2int(pid1))));
        Predef$.MODULE$.assert(this.isPartitioned(this.getStreamGraph(env).getStreamEdgesOrThrow(src1.getId(), Predef$.MODULE$.Integer2int(pid2))));
        Predef$.MODULE$.assert(this.isPartitioned(this.getStreamGraph(env).getStreamEdgesOrThrow(src1.getId(), Predef$.MODULE$.Integer2int(pid3))));
        Predef$.MODULE$.assert(this.isPartitioned(this.getStreamGraph(env).getStreamEdgesOrThrow(src1.getId(), Predef$.MODULE$.Integer2int(pid4))));
        Partitioner<Object> longPartitioner = new Partitioner<Object>(null){

            public int partition(long key, int numPartitions) {
                return 0;
            }
        };
        DataStream customPartition1 = src1.partitionCustom((Partitioner)longPartitioner, 0, (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE));
        DataStream customPartition3 = src1.partitionCustom((Partitioner)longPartitioner, "_1", (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE));
        DataStream customPartition4 = src1.partitionCustom((Partitioner)longPartitioner, (Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToLong((long)x._1$mcJ$sp()), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE));
        Integer cpid1 = this.createDownStreamId(customPartition1);
        Integer cpid2 = this.createDownStreamId(customPartition3);
        Integer cpid3 = this.createDownStreamId(customPartition4);
        Predef$.MODULE$.assert(this.isCustomPartitioned(this.getStreamGraph(env).getStreamEdgesOrThrow(src1.getId(), Predef$.MODULE$.Integer2int(cpid1))));
        Predef$.MODULE$.assert(this.isCustomPartitioned(this.getStreamGraph(env).getStreamEdgesOrThrow(src1.getId(), Predef$.MODULE$.Integer2int(cpid2))));
        Predef$.MODULE$.assert(this.isCustomPartitioned(this.getStreamGraph(env).getStreamEdgesOrThrow(src1.getId(), Predef$.MODULE$.Integer2int(cpid3))));
        ConnectedStreams connectedGroup1 = connected.keyBy(0, 0);
        Integer downStreamId1 = this.createDownStreamId(connectedGroup1);
        ConnectedStreams connectedGroup2 = connected.keyBy((int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}), ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}), ClassTag$.MODULE$.Int()));
        Integer downStreamId2 = this.createDownStreamId(connectedGroup2);
        ConnectedStreams connectedGroup3 = connected.keyBy("_1", "_1");
        Integer downStreamId3 = this.createDownStreamId(connectedGroup3);
        ConnectedStreams connectedGroup4 = connected.keyBy((String[])((Object[])new String[]{"_1"}), (String[])((Object[])new String[]{"_1"}));
        Integer downStreamId4 = this.createDownStreamId(connectedGroup4);
        ConnectedStreams connectedGroup5 = connected.keyBy((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToLong((long)x._1$mcJ$sp()), (Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToLong((long)x._1$mcJ$sp()), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE));
        Integer downStreamId5 = this.createDownStreamId(connectedGroup5);
        Predef$.MODULE$.assert(this.isPartitioned(this.getStreamGraph(env).getStreamEdgesOrThrow(src1.getId(), Predef$.MODULE$.Integer2int(downStreamId1))));
        Predef$.MODULE$.assert(this.isPartitioned(this.getStreamGraph(env).getStreamEdgesOrThrow(src2.getId(), Predef$.MODULE$.Integer2int(downStreamId1))));
        Predef$.MODULE$.assert(this.isPartitioned(this.getStreamGraph(env).getStreamEdgesOrThrow(src1.getId(), Predef$.MODULE$.Integer2int(downStreamId2))));
        Predef$.MODULE$.assert(this.isPartitioned(this.getStreamGraph(env).getStreamEdgesOrThrow(src2.getId(), Predef$.MODULE$.Integer2int(downStreamId2))));
        Predef$.MODULE$.assert(this.isPartitioned(this.getStreamGraph(env).getStreamEdgesOrThrow(src1.getId(), Predef$.MODULE$.Integer2int(downStreamId3))));
        Predef$.MODULE$.assert(this.isPartitioned(this.getStreamGraph(env).getStreamEdgesOrThrow(src2.getId(), Predef$.MODULE$.Integer2int(downStreamId3))));
        Predef$.MODULE$.assert(this.isPartitioned(this.getStreamGraph(env).getStreamEdgesOrThrow(src1.getId(), Predef$.MODULE$.Integer2int(downStreamId4))));
        Predef$.MODULE$.assert(this.isPartitioned(this.getStreamGraph(env).getStreamEdgesOrThrow(src2.getId(), Predef$.MODULE$.Integer2int(downStreamId4))));
        Predef$.MODULE$.assert(this.isPartitioned(this.getStreamGraph(env).getStreamEdgesOrThrow(src1.getId(), Predef$.MODULE$.Integer2int(downStreamId5))));
        Predef$.MODULE$.assert(this.isPartitioned(this.getStreamGraph(env).getStreamEdgesOrThrow(src2.getId(), Predef$.MODULE$.Integer2int(downStreamId5))));
        ConnectedStreams connectedPartition1 = connected.keyBy(0, 0);
        Integer connectDownStreamId1 = this.createDownStreamId(connectedPartition1);
        ConnectedStreams connectedPartition2 = connected.keyBy((int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}), ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}), ClassTag$.MODULE$.Int()));
        Integer connectDownStreamId2 = this.createDownStreamId(connectedPartition2);
        ConnectedStreams connectedPartition3 = connected.keyBy("_1", "_1");
        Integer connectDownStreamId3 = this.createDownStreamId(connectedPartition3);
        ConnectedStreams connectedPartition4 = connected.keyBy((String[])((Object[])new String[]{"_1"}), (String[])((Object[])new String[]{"_1"}));
        Integer connectDownStreamId4 = this.createDownStreamId(connectedPartition4);
        ConnectedStreams connectedPartition5 = connected.keyBy((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToLong((long)x._1$mcJ$sp()), (Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToLong((long)x._1$mcJ$sp()), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE));
        Integer connectDownStreamId5 = this.createDownStreamId(connectedPartition5);
        Predef$.MODULE$.assert(this.isPartitioned(this.getStreamGraph(env).getStreamEdgesOrThrow(src1.getId(), Predef$.MODULE$.Integer2int(connectDownStreamId1))));
        Predef$.MODULE$.assert(this.isPartitioned(this.getStreamGraph(env).getStreamEdgesOrThrow(src2.getId(), Predef$.MODULE$.Integer2int(connectDownStreamId1))));
        Predef$.MODULE$.assert(this.isPartitioned(this.getStreamGraph(env).getStreamEdgesOrThrow(src1.getId(), Predef$.MODULE$.Integer2int(connectDownStreamId2))));
        Predef$.MODULE$.assert(this.isPartitioned(this.getStreamGraph(env).getStreamEdgesOrThrow(src2.getId(), Predef$.MODULE$.Integer2int(connectDownStreamId2))));
        Predef$.MODULE$.assert(this.isPartitioned(this.getStreamGraph(env).getStreamEdgesOrThrow(src1.getId(), Predef$.MODULE$.Integer2int(connectDownStreamId3))));
        Predef$.MODULE$.assert(this.isPartitioned(this.getStreamGraph(env).getStreamEdgesOrThrow(src2.getId(), Predef$.MODULE$.Integer2int(connectDownStreamId3))));
        Predef$.MODULE$.assert(this.isPartitioned(this.getStreamGraph(env).getStreamEdgesOrThrow(src1.getId(), Predef$.MODULE$.Integer2int(connectDownStreamId4))));
        Predef$.MODULE$.assert(this.isPartitioned(this.getStreamGraph(env).getStreamEdgesOrThrow(src2.getId(), Predef$.MODULE$.Integer2int(connectDownStreamId4))));
        Predef$.MODULE$.assert(this.isPartitioned(this.getStreamGraph(env).getStreamEdgesOrThrow(src1.getId(), Predef$.MODULE$.Integer2int(connectDownStreamId5))));
        Predef$.MODULE$.assert(this.isPartitioned(this.getStreamGraph(env).getStreamEdgesOrThrow(src2.getId(), Predef$.MODULE$.Integer2int(connectDownStreamId5))));
    }

    @Test
    public void testParallelism() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        int parallelism = env.getParallelism();
        DataStream src = env.fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(0L, 0L)}), (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$16 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.streaming.api.scala.DataStreamTest$$anon$16 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        DataStream map = src.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2.mcJJ.sp(0L, 0L), (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$17 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.streaming.api.scala.DataStreamTest$$anon$17 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        DataStream windowed = map.windowAll((WindowAssigner)GlobalWindows.create()).trigger((Trigger)PurgingTrigger.of((Trigger)CountTrigger.of((long)10L))).reduce((Function2 & Serializable & scala.Serializable)(x, y) -> new Tuple2.mcJJ.sp(0L, 0L));
        windowed.print();
        DataStreamSink sink = map.addSink((Function1 & Serializable & scala.Serializable)x -> {
            DataStreamTest.$anonfun$testParallelism$3(x);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.assert(1 == this.getStreamGraph(env).getStreamNode(Predef$.MODULE$.int2Integer(src.getId())).getParallelism());
        Predef$.MODULE$.assert(parallelism == this.getStreamGraph(env).getStreamNode(Predef$.MODULE$.int2Integer(map.getId())).getParallelism());
        Predef$.MODULE$.assert(1 == this.getStreamGraph(env).getStreamNode(Predef$.MODULE$.int2Integer(windowed.getId())).getParallelism());
        Predef$.MODULE$.assert(parallelism == this.getStreamGraph(env).getStreamNode(Predef$.MODULE$.int2Integer(sink.getTransformation().getId())).getParallelism());
        try {
            src.setParallelism(3);
            Assert.fail();
        }
        catch (IllegalArgumentException success) {
            // empty catch block
        }
        int newParallelism = parallelism - 1;
        env.setParallelism(newParallelism);
        Predef$.MODULE$.assert(1 == this.getStreamGraph(env).getStreamNode(Predef$.MODULE$.int2Integer(src.getId())).getParallelism());
        Predef$.MODULE$.assert(parallelism == this.getStreamGraph(env).getStreamNode(Predef$.MODULE$.int2Integer(map.getId())).getParallelism());
        Predef$.MODULE$.assert(1 == this.getStreamGraph(env).getStreamNode(Predef$.MODULE$.int2Integer(windowed.getId())).getParallelism());
        Predef$.MODULE$.assert(parallelism == this.getStreamGraph(env).getStreamNode(Predef$.MODULE$.int2Integer(sink.getTransformation().getId())).getParallelism());
        DataStream parallelSource = env.generateSequence(0L, 0L);
        parallelSource.print();
        Predef$.MODULE$.assert(newParallelism == this.getStreamGraph(env).getStreamNode(Predef$.MODULE$.int2Integer(parallelSource.getId())).getParallelism());
        parallelSource.setParallelism(3);
        Predef$.MODULE$.assert(3 == this.getStreamGraph(env).getStreamNode(Predef$.MODULE$.int2Integer(parallelSource.getId())).getParallelism());
        map.setParallelism(2);
        Predef$.MODULE$.assert(2 == this.getStreamGraph(env).getStreamNode(Predef$.MODULE$.int2Integer(map.getId())).getParallelism());
        sink.setParallelism(4);
        Predef$.MODULE$.assert(4 == this.getStreamGraph(env).getStreamNode(Predef$.MODULE$.int2Integer(sink.getTransformation().getId())).getParallelism());
    }

    @Test
    public void testParallelismFailAfterPartitioning() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataStream src = env.fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(0L, 0L)}), (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$18 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.streaming.api.scala.DataStreamTest$$anon$18 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        DataStream map = src.map((Function1 & Serializable & scala.Serializable)x$1 -> new Tuple2.mcJJ.sp(0L, 0L), (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$19 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.streaming.api.scala.DataStreamTest$$anon$19 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        DataStream broadcastStream = map.broadcast();
        this.thrownException().expect(UnsupportedOperationException.class);
        this.thrownException().expectMessage("cannot set the parallelism");
        broadcastStream.setParallelism(1);
    }

    @Test
    public void testTypeInfo() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataStream src1 = env.generateSequence(0L, 0L);
        TypeInformation typeInformation = TypeExtractor.getForClass(Long.TYPE);
        TypeInformation typeInformation2 = src1.getType();
        Predef$.MODULE$.assert(!(typeInformation != null ? !typeInformation.equals(typeInformation2) : typeInformation2 != null));
        DataStream map = src1.map((Function1 & Serializable & scala.Serializable)x -> DataStreamTest.$anonfun$testTypeInfo$1(BoxesRunTime.unboxToLong((Object)x)), (TypeInformation)new CaseClassTypeInfo<Tuple2<Integer, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$20 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Integer, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$8[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Integer, String>> unused = new ScalaCaseClassSerializer<Tuple2<Integer, String>>(this, fieldSerializers){

                    public Tuple2<Integer, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)((Integer)fields[0]), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$8(org.apache.flink.streaming.api.scala.DataStreamTest$$anon$20 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Predef$.MODULE$.assert(Tuple2.class.equals((Object)map.getType().getTypeClass()));
        DataStream window = map.windowAll((WindowAssigner)GlobalWindows.create()).trigger((Trigger)PurgingTrigger.of((Trigger)CountTrigger.of((long)5L))).apply((Function3 & Serializable & scala.Serializable)(w, x, y) -> {
            DataStreamTest.$anonfun$testTypeInfo$2(w, x, y);
            return BoxedUnit.UNIT;
        }, (TypeInformation)BasicTypeInfo.getInfoFor(String.class));
        TypeInformation typeInformation3 = TypeExtractor.getForClass(String.class);
        TypeInformation typeInformation4 = window.getType();
        Predef$.MODULE$.assert(!(typeInformation3 != null ? !typeInformation3.equals(typeInformation4) : typeInformation4 != null));
        DataStream flatten = window.windowAll((WindowAssigner)GlobalWindows.create()).trigger((Trigger)PurgingTrigger.of((Trigger)CountTrigger.of((long)5L))).aggregate((AggregateFunction)new AggregateFunction<String, CustomCaseClass, CustomCaseClass>(null){

            public CustomCaseClass createAccumulator() {
                return new CustomCaseClass(0, "");
            }

            public CustomCaseClass add(String value, CustomCaseClass accumulator) {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public CustomCaseClass getResult(CustomCaseClass accumulator) {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public CustomCaseClass merge(CustomCaseClass a, CustomCaseClass b) {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }
        }, (TypeInformation)new CaseClassTypeInfo<CustomCaseClass>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$21 x$1) {
                return x$1.types;
            }

            public TypeSerializer<CustomCaseClass> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$9[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<CustomCaseClass> unused = new ScalaCaseClassSerializer<CustomCaseClass>(this, fieldSerializers){

                    public CustomCaseClass createInstance(Object[] fields) {
                        return new CustomCaseClass(BoxesRunTime.unboxToInt((Object)fields[0]), (String)fields[1]);
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$9(org.apache.flink.streaming.api.scala.DataStreamTest$$anon$21 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, (TypeInformation)new CaseClassTypeInfo<CustomCaseClass>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$22 x$1) {
                return x$1.types;
            }

            public TypeSerializer<CustomCaseClass> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$10[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<CustomCaseClass> unused = new ScalaCaseClassSerializer<CustomCaseClass>(this, fieldSerializers){

                    public CustomCaseClass createInstance(Object[] fields) {
                        return new CustomCaseClass(BoxesRunTime.unboxToInt((Object)fields[0]), (String)fields[1]);
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$10(org.apache.flink.streaming.api.scala.DataStreamTest$$anon$22 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        TypeInformation typeInfo = (TypeInformation)Predef$.MODULE$.implicitly((Object)new CaseClassTypeInfo<CustomCaseClass>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$23 x$1) {
                return x$1.types;
            }

            public TypeSerializer<CustomCaseClass> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$11[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<CustomCaseClass> unused = new ScalaCaseClassSerializer<CustomCaseClass>(this, fieldSerializers){

                    public CustomCaseClass createInstance(Object[] fields) {
                        return new CustomCaseClass(BoxesRunTime.unboxToInt((Object)fields[0]), (String)fields[1]);
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$11(org.apache.flink.streaming.api.scala.DataStreamTest$$anon$23 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Assert.assertThat((Object)flatten.getType(), (Matcher)CoreMatchers.equalTo((Object)typeInfo));
    }

    @Test
    public void testKeyedStreamProcessTranslation() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataStream src = env.generateSequence(0L, 0L);
        ProcessFunction<Object, Object> processFunction = new ProcessFunction<Object, Object>(null){

            public void processElement(long value, ProcessFunction.Context ctx, Collector<Object> out) {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }
        };
        DataStream flatMapped = src.keyBy((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x -> x, (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE)).process((ProcessFunction)processFunction, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        ProcessFunction<Object, Object> processFunction2 = processFunction;
        Function function = this.getFunctionForDataStream(flatMapped);
        Predef$.MODULE$.assert(!(processFunction2 != null ? !processFunction2.equals((Object)function) : function != null));
        Predef$.MODULE$.assert(this.getOperatorForDataStream(flatMapped) instanceof LegacyKeyedProcessOperator);
    }

    @Test
    public void testKeyedStreamKeyedProcessTranslation() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataStream src = env.generateSequence(0L, 0L);
        KeyedProcessFunction<Object, Object, Object> keyedProcessFunction = new KeyedProcessFunction<Object, Object, Object>(null){

            public void processElement(long value, KeyedProcessFunction.Context ctx, Collector<Object> out) {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }
        };
        DataStream flatMapped = src.keyBy((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x -> x, (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE)).process((KeyedProcessFunction)keyedProcessFunction, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        KeyedProcessFunction<Object, Object, Object> keyedProcessFunction2 = keyedProcessFunction;
        Function function = this.getFunctionForDataStream(flatMapped);
        Predef$.MODULE$.assert(!(keyedProcessFunction2 != null ? !keyedProcessFunction2.equals((Object)function) : function != null));
        Predef$.MODULE$.assert(this.getOperatorForDataStream(flatMapped) instanceof KeyedProcessOperator);
    }

    @Test
    public void testProcessTranslation() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataStream src = env.generateSequence(0L, 0L);
        ProcessFunction<Object, Object> processFunction = new ProcessFunction<Object, Object>(null){

            public void processElement(long value, ProcessFunction.Context ctx, Collector<Object> out) {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }
        };
        DataStream flatMapped = src.process((ProcessFunction)processFunction, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        ProcessFunction<Object, Object> processFunction2 = processFunction;
        Function function = this.getFunctionForDataStream(flatMapped);
        Predef$.MODULE$.assert(!(processFunction2 != null ? !processFunction2.equals((Object)function) : function != null));
        Predef$.MODULE$.assert(this.getOperatorForDataStream(flatMapped) instanceof ProcessOperator);
    }

    @Test
    public void operatorTest() {
        Object object;
        Object object2;
        Object object3;
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataStream src = env.generateSequence(0L, 0L);
        MapFunction<Object, Object> mapFunction = new MapFunction<Object, Object>(null){

            public int map(long value) {
                return 0;
            }
        };
        DataStream map = src.map((MapFunction)mapFunction, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        MapFunction<Object, Object> mapFunction2 = mapFunction;
        Function function = this.getFunctionForDataStream(map);
        Predef$.MODULE$.assert(!(mapFunction2 != null ? !mapFunction2.equals((Object)function) : function != null));
        Predef$.MODULE$.assert(this.getFunctionForDataStream(map.map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x -> 0, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE))) instanceof MapFunction);
        DataStream statefulMap2 = src.keyBy((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x -> x, (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE)).mapWithState((Function2 & Serializable & scala.Serializable)(in, state) -> DataStreamTest.$anonfun$operatorTest$3(BoxesRunTime.unboxToLong((Object)in), state), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE));
        FlatMapFunction<Object, Object> flatMapFunction = new FlatMapFunction<Object, Object>(null){

            public void flatMap(long value, Collector<Object> out) {
            }
        };
        DataStream flatMap = src.flatMap((FlatMapFunction)flatMapFunction, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        FlatMapFunction<Object, Object> flatMapFunction2 = flatMapFunction;
        Function function2 = this.getFunctionForDataStream(flatMap);
        Predef$.MODULE$.assert(!(flatMapFunction2 != null ? !flatMapFunction2.equals((Object)function2) : function2 != null));
        Predef$.MODULE$.assert(this.getFunctionForDataStream(flatMap.flatMap((Function2 & Serializable & scala.Serializable)(x, out) -> {
            DataStreamTest.$anonfun$operatorTest$4(BoxesRunTime.unboxToInt((Object)x), out);
            return BoxedUnit.UNIT;
        }, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE))) instanceof FlatMapFunction);
        DataStream statefulfMap2 = src.keyBy((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x -> x, (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE)).flatMapWithState((Function2 & Serializable & scala.Serializable)(in, state) -> DataStreamTest.$anonfun$operatorTest$6(BoxesRunTime.unboxToLong((Object)in), state), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE));
        FilterFunction<Object> filterFunction = new FilterFunction<Object>(null){

            public boolean filter(int value) {
                return false;
            }
        };
        DataStream unionFilter = map.union((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataStream[]{flatMap})).filter((FilterFunction)filterFunction);
        FilterFunction<Object> filterFunction2 = filterFunction;
        Function function3 = this.getFunctionForDataStream(unionFilter);
        Predef$.MODULE$.assert(!(filterFunction2 != null ? !filterFunction2.equals((Object)function3) : function3 != null));
        Predef$.MODULE$.assert(this.getFunctionForDataStream(map.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x -> true)) instanceof FilterFunction);
        DataStream statefulFilter2 = src.keyBy((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x -> x, (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE)).filterWithState((Function2 & Serializable & scala.Serializable)(in, state) -> DataStreamTest.$anonfun$operatorTest$9(BoxesRunTime.unboxToLong((Object)in), state), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE));
        try {
            object3 = this.getStreamGraph(env).getStreamEdgesOrThrow(map.getId(), unionFilter.getId());
        }
        catch (Throwable e) {
            Assert.fail((String)e.getMessage());
            object3 = BoxedUnit.UNIT;
        }
        try {
            object2 = this.getStreamGraph(env).getStreamEdgesOrThrow(flatMap.getId(), unionFilter.getId());
        }
        catch (Throwable e) {
            Assert.fail((String)e.getMessage());
            object2 = BoxedUnit.UNIT;
        }
        ConnectedStreams connect = map.connect(flatMap);
        CoMapFunction<Object, Object, String> coMapFunction = new CoMapFunction<Object, Object, String>(null){

            public String map1(int value) {
                return "";
            }

            public String map2(int value) {
                return "";
            }
        };
        DataStream coMap = connect.map((CoMapFunction)coMapFunction, (TypeInformation)BasicTypeInfo.getInfoFor(String.class));
        CoMapFunction<Object, Object, String> coMapFunction2 = coMapFunction;
        Function function4 = this.getFunctionForDataStream(coMap);
        Predef$.MODULE$.assert(!(coMapFunction2 != null ? !coMapFunction2.equals((Object)function4) : function4 != null));
        try {
            object = this.getStreamGraph(env).getStreamEdgesOrThrow(map.getId(), coMap.getId());
        }
        catch (Throwable e) {
            Assert.fail((String)e.getMessage());
            object = BoxedUnit.UNIT;
        }
        try {
            this.getStreamGraph(env).getStreamEdgesOrThrow(flatMap.getId(), coMap.getId());
        }
        catch (Throwable e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testChannelSelectors() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataStream src = env.generateSequence(0L, 0L);
        DataStream broadcast = src.broadcast();
        DataStreamSink broadcastSink = broadcast.print();
        StreamPartitioner broadcastPartitioner = ((StreamEdge)this.getStreamGraph(env).getStreamEdgesOrThrow(src.getId(), broadcastSink.getTransformation().getId()).get(0)).getPartitioner();
        Predef$.MODULE$.assert(broadcastPartitioner instanceof BroadcastPartitioner);
        DataStream shuffle = src.shuffle();
        DataStreamSink shuffleSink = shuffle.print();
        StreamPartitioner shufflePartitioner = ((StreamEdge)this.getStreamGraph(env).getStreamEdgesOrThrow(src.getId(), shuffleSink.getTransformation().getId()).get(0)).getPartitioner();
        Predef$.MODULE$.assert(shufflePartitioner instanceof ShufflePartitioner);
        DataStream forward = src.forward();
        DataStreamSink forwardSink = forward.print();
        StreamPartitioner forwardPartitioner = ((StreamEdge)this.getStreamGraph(env).getStreamEdgesOrThrow(src.getId(), forwardSink.getTransformation().getId()).get(0)).getPartitioner();
        Predef$.MODULE$.assert(forwardPartitioner instanceof ForwardPartitioner);
        DataStream rebalance = src.rebalance();
        DataStreamSink rebalanceSink = rebalance.print();
        StreamPartitioner rebalancePartitioner = ((StreamEdge)this.getStreamGraph(env).getStreamEdgesOrThrow(src.getId(), rebalanceSink.getTransformation().getId()).get(0)).getPartitioner();
        Predef$.MODULE$.assert(rebalancePartitioner instanceof RebalancePartitioner);
        DataStream global = src.global();
        DataStreamSink globalSink = global.print();
        StreamPartitioner globalPartitioner = ((StreamEdge)this.getStreamGraph(env).getStreamEdgesOrThrow(src.getId(), globalSink.getTransformation().getId()).get(0)).getPartitioner();
        Predef$.MODULE$.assert(globalPartitioner instanceof GlobalPartitioner);
    }

    @Test
    public void testIterations() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataStream source = env.fromElements((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE)).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)t -> t, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        DataStreamSink iterated = source.iterate((Function1 & Serializable & scala.Serializable)input -> {
            DataStream head = input.map((Function1 & Serializable & scala.Serializable)i -> DataStreamTest.$anonfun$testIterations$3(BoxesRunTime.unboxToInt((Object)i)), (Function1 & Serializable & scala.Serializable)s -> s, (TypeInformation)BasicTypeInfo.getInfoFor(String.class));
            return new Tuple2((Object)head.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DataStreamTest.$anonfun$testIterations$5(x$2))), (Object)head.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DataStreamTest.$anonfun$testIterations$6(x$3))));
        }, 1000L, (TypeInformation)BasicTypeInfo.getInfoFor(String.class)).print();
        DataStream iterated2 = source.iterate((Function1 & Serializable & scala.Serializable)input -> new Tuple2((Object)input.map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$4 -> x$4 + 1, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE)), (Object)input.map((Function1 & Serializable & scala.Serializable)x$5 -> DataStreamTest.$anonfun$testIterations$9(BoxesRunTime.unboxToInt((Object)x$5)), (TypeInformation)BasicTypeInfo.getInfoFor(String.class))), 2000L);
        StreamGraph sg = this.getStreamGraph(env);
        Predef$.MODULE$.assert(sg.getIterationSourceSinkPairs().size() == 2);
    }

    @Test
    public void testCreateInputPassesOnTypeInfo() {
        StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment().createInput((InputFormat)new ParallelIteratorInputFormat(null), (TypeInformation)new CaseClassTypeInfo<Tuple1<Integer>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$27 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple1<Integer>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$12[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple1<Integer>> unused = new ScalaCaseClassSerializer<Tuple1<Integer>>(this, fieldSerializers){

                    public Tuple1<Integer> createInstance(Object[] fields) {
                        return new Tuple1((Object)((Integer)fields[0]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$12(org.apache.flink.streaming.api.scala.DataStreamTest$$anon$27 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    private Function getFunctionForDataStream(DataStream<?> dataStream) {
        dataStream.print();
        AbstractUdfStreamOperator operator = (AbstractUdfStreamOperator)this.getOperatorForDataStream(dataStream);
        return operator.getUserFunction();
    }

    private StreamOperator<?> getOperatorForDataStream(DataStream<?> dataStream) {
        dataStream.print();
        org.apache.flink.streaming.api.environment.StreamExecutionEnvironment env = dataStream.javaStream().getExecutionEnvironment();
        StreamGraph streamGraph = env.getStreamGraph("Flink Streaming Job", false);
        return streamGraph.getStreamNode(Predef$.MODULE$.int2Integer(dataStream.getId())).getOperator();
    }

    private StreamGraph getStreamGraph(StreamExecutionEnvironment sEnv) {
        return sEnv.getStreamGraph("Flink Streaming Job", false);
    }

    private boolean isPartitioned(List<StreamEdge> edges) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(edges).asScala()).forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DataStreamTest.$anonfun$isPartitioned$1(x$6)));
    }

    private boolean isCustomPartitioned(List<StreamEdge> edges) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(edges).asScala()).forall((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DataStreamTest.$anonfun$isCustomPartitioned$1(x$7)));
    }

    private Integer createDownStreamId(DataStream<?> dataStream) {
        return Predef$.MODULE$.int2Integer(dataStream.print().getTransformation().getId());
    }

    private Integer createDownStreamId(ConnectedStreams<?, ?> dataStream) {
        DataStream m = dataStream.map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger((int)DataStreamTest.$anonfun$createDownStreamId$1(x)), (Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger((int)DataStreamTest.$anonfun$createDownStreamId$2(x)), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        m.print();
        return Predef$.MODULE$.int2Integer(m.getId());
    }

    public static final /* synthetic */ void $anonfun$testNaming$4(long in, Collector out) {
    }

    public static final /* synthetic */ void $anonfun$testNaming$5(long in, Collector out) {
    }

    public static final /* synthetic */ void $anonfun$testParallelism$3(Tuple2 x) {
    }

    public static final /* synthetic */ Null$ $anonfun$testTypeInfo$1(long x) {
        return null;
    }

    public static final /* synthetic */ void $anonfun$testTypeInfo$2(GlobalWindow w, Iterable x, Collector y) {
    }

    public static final /* synthetic */ Tuple2 $anonfun$operatorTest$3(long in, Option state) {
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)in), (Object)None$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$operatorTest$4(int x, Collector out) {
    }

    public static final /* synthetic */ Tuple2 $anonfun$operatorTest$6(long in, Option state) {
        return new Tuple2((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{in})), (Object)None$.MODULE$);
    }

    public static final /* synthetic */ Tuple2 $anonfun$operatorTest$9(long in, Option state) {
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)None$.MODULE$);
    }

    public static final /* synthetic */ String $anonfun$testIterations$3(int i) {
        return ((Object)BoxesRunTime.boxToInteger((int)(i + 1))).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testIterations$5(String x$2) {
        String string = x$2;
        String string2 = "2";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testIterations$6(String x$3) {
        String string = x$3;
        String string2 = "2";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ String $anonfun$testIterations$9(int x$5) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$5)).toString();
    }

    public static final /* synthetic */ boolean $anonfun$isPartitioned$1(StreamEdge x$6) {
        return x$6.getPartitioner() instanceof KeyGroupStreamPartitioner;
    }

    public static final /* synthetic */ boolean $anonfun$isCustomPartitioned$1(StreamEdge x$7) {
        return x$7.getPartitioner() instanceof CustomPartitionerWrapper;
    }

    public static final /* synthetic */ int $anonfun$createDownStreamId$1(Object x) {
        return 0;
    }

    public static final /* synthetic */ int $anonfun$createDownStreamId$2(Object x) {
        return 0;
    }
}

