/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.scala;

import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.scala.AsyncDataStream$;
import org.apache.flink.streaming.api.scala.AsyncDataStreamITCase$;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.api.scala.MyAsyncFunction;
import org.apache.flink.streaming.api.scala.MyRichAsyncFunction;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.streaming.api.scala.async.AsyncFunction;
import org.apache.flink.streaming.api.scala.async.ResultFuture;
import org.apache.flink.test.util.AbstractTestBase;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001m<Q!\u0001\u0002\t\u0002=\tQ#Q:z]\u000e$\u0015\r^1TiJ,\u0017-\\%U\u0007\u0006\u001cXM\u0003\u0002\u0004\t\u0005)1oY1mC*\u0011QAB\u0001\u0004CBL'BA\u0004\t\u0003%\u0019HO]3b[&twM\u0003\u0002\n\u0015\u0005)a\r\\5oW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0001\"\u0001E\t\u000e\u0003\t1QA\u0005\u0002\t\u0002M\u0011Q#Q:z]\u000e$\u0015\r^1TiJ,\u0017-\\%U\u0007\u0006\u001cXm\u0005\u0002\u0012)A\u0011QcF\u0007\u0002-)\t1!\u0003\u0002\u0019-\t1\u0011I\\=SK\u001aDQAG\t\u0005\u0002m\ta\u0001P5oSRtD#A\b\t\u000fu\t\"\u0019!C\u0001=\u00059A/[7f_V$X#A\u0010\u0011\u0005U\u0001\u0013BA\u0011\u0017\u0005\u0011auN\\4\t\r\r\n\u0002\u0015!\u0003 \u0003!!\u0018.\\3pkR\u0004\u0003\"C\u0013\u0012\u0001\u0004\u0005\r\u0011\"\u0003'\u0003)!Xm\u001d;SKN,H\u000e^\u000b\u0002OA\u0019\u0001&L\u0018\u000e\u0003%R!AK\u0016\u0002\u000f5,H/\u00192mK*\u0011AFF\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u0018*\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0005U\u0001\u0014BA\u0019\u0017\u0005\rIe\u000e\u001e\u0005\ngE\u0001\r\u00111A\u0005\nQ\na\u0002^3tiJ+7/\u001e7u?\u0012*\u0017\u000f\u0006\u00026qA\u0011QCN\u0005\u0003oY\u0011A!\u00168ji\"9\u0011HMA\u0001\u0002\u00049\u0013a\u0001=%c!11(\u0005Q!\n\u001d\n1\u0002^3tiJ+7/\u001e7uA\u0019!!C\u0001\u0001>'\tad\b\u0005\u0002@\t6\t\u0001I\u0003\u0002B\u0005\u0006!Q\u000f^5m\u0015\t\u0019\u0005\"\u0001\u0003uKN$\u0018BA#A\u0005A\t%m\u001d;sC\u000e$H+Z:u\u0005\u0006\u001cX\rC\u0003\u001by\u0011\u0005q\tF\u0001I!\t\u0001B\bC\u0003Ky\u0011\u00051*A\buKN$xJ\u001d3fe\u0016$w+Y5u)\u0005)\u0004FA%N!\tq\u0015+D\u0001P\u0015\t\u0001F\"A\u0003kk:LG/\u0003\u0002S\u001f\n!A+Z:u\u0011\u0015!F\b\"\u0001L\u0003E!Xm\u001d;V]>\u0014H-\u001a:fI^\u000b\u0017\u000e\u001e\u0015\u0003'6CQa\u0016\u001f\u0005\na\u000bQ\u0002^3ti\u0006\u001b\u0018P\\2XC&$HCA\u001bZ\u0011\u0015Qf\u000b1\u0001\\\u0003\u001dy'\u000fZ3sK\u0012\u0004\"!\u0006/\n\u0005u3\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006?r\"I\u0001Y\u0001\u0013Kb,7-\u001e;f\u0003:$g+\u00197jI\u0006$X\rF\u00036C\n<G\u000eC\u0003[=\u0002\u00071\fC\u0003d=\u0002\u0007A-A\u0002f]Z\u0004\"\u0001E3\n\u0005\u0019\u0014!AG*ue\u0016\fW.\u0012=fGV$\u0018n\u001c8F]ZL'o\u001c8nK:$\b\"\u00025_\u0001\u0004I\u0017A\u00033bi\u0006\u001cFO]3b[B\u0019\u0001C[\u0018\n\u0005-\u0014!A\u0003#bi\u0006\u001cFO]3b[\")QN\u0018a\u0001O\u0005qQ\r\u001f9fGR,GMU3tk2$\b\"B8=\t\u0003Y\u0015!\n;fgR|%\u000fZ3sK\u0012<\u0016-\u001b;Vg&tw-\u00118p]flw.^:Gk:\u001cG/[8oQ\tqW\nC\u0003sy\u0011\u00051*A\u0014uKN$XK\\8sI\u0016\u0014X\rZ,bSR,6/\u001b8h\u0003:|g._7pkN4UO\\2uS>t\u0007FA9N\u0011\u0015)H\b\"\u0001L\u0003\r\"Xm\u001d;SS\u000eD\u0017i]=oG\u001a+hn\u0019;j_:\u0014VO\u001c;j[\u0016\u001cuN\u001c;fqRD#\u0001^'\t\u000badD\u0011B=\u0002GQ,7\u000f^!ts:\u001cw+Y5u+NLgnZ!o_:LXn\\;t\rVt7\r^5p]R\u0011QG\u001f\u0005\u00065^\u0004\ra\u0017")
public class AsyncDataStreamITCase
extends AbstractTestBase {
    public static long timeout() {
        return AsyncDataStreamITCase$.MODULE$.timeout();
    }

    @Test
    public void testOrderedWait() {
        this.testAsyncWait(true);
    }

    @Test
    public void testUnorderedWait() {
        this.testAsyncWait(false);
    }

    private void testAsyncWait(boolean ordered) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setParallelism(1);
        DataStream source = env.fromElements((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        DataStream asyncMapped = ordered ? AsyncDataStream$.MODULE$.orderedWait(source, (AsyncFunction)new MyAsyncFunction(), AsyncDataStreamITCase$.MODULE$.timeout(), TimeUnit.MILLISECONDS, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE)) : AsyncDataStream$.MODULE$.unorderedWait(source, (AsyncFunction)new MyAsyncFunction(), AsyncDataStreamITCase$.MODULE$.timeout(), TimeUnit.MILLISECONDS, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        this.executeAndValidate(ordered, env, (DataStream<Object>)asyncMapped, (ArrayBuffer<Object>)((ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 6}))));
    }

    private void executeAndValidate(boolean ordered, StreamExecutionEnvironment env, DataStream<Object> dataStream, ArrayBuffer<Object> expectedResult) {
        AsyncDataStreamITCase$.MODULE$.org$apache$flink$streaming$api$scala$AsyncDataStreamITCase$$testResult_$eq((ArrayBuffer<Object>)((ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
        dataStream.addSink((SinkFunction)new SinkFunction<Object>(this){

            public void invoke(int value) {
                AsyncDataStreamITCase$.MODULE$.org$apache$flink$streaming$api$scala$AsyncDataStreamITCase$$testResult().$plus$eq((Object)BoxesRunTime.boxToInteger((int)value));
            }
        });
        env.execute("testAsyncDataStream");
        if (ordered) {
            Assert.assertEquals(expectedResult, AsyncDataStreamITCase$.MODULE$.org$apache$flink$streaming$api$scala$AsyncDataStreamITCase$$testResult());
        } else {
            Assert.assertEquals(expectedResult, (Object)AsyncDataStreamITCase$.MODULE$.org$apache$flink$streaming$api$scala$AsyncDataStreamITCase$$testResult().sorted((Ordering)Ordering.Int$.MODULE$));
        }
    }

    @Test
    public void testOrderedWaitUsingAnonymousFunction() {
        this.testAsyncWaitUsingAnonymousFunction(true);
    }

    @Test
    public void testUnorderedWaitUsingAnonymousFunction() {
        this.testAsyncWaitUsingAnonymousFunction(false);
    }

    @Test
    public void testRichAsyncFunctionRuntimeContext() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setParallelism(1);
        DataStream source = env.fromElements((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        MyRichAsyncFunction richAsyncFunction = new MyRichAsyncFunction();
        DataStream asyncMapped = AsyncDataStream$.MODULE$.unorderedWait(source, (AsyncFunction)richAsyncFunction, AsyncDataStreamITCase$.MODULE$.timeout(), TimeUnit.MILLISECONDS, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        this.executeAndValidate(false, env, (DataStream<Object>)asyncMapped, (ArrayBuffer<Object>)((ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}))));
    }

    private void testAsyncWaitUsingAnonymousFunction(boolean ordered) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setParallelism(1);
        DataStream source = env.fromElements((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        Serializable asyncFunction = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(int input, ResultFuture<Object> collector) {
                Future$.MODULE$.apply((Function0)new Serializable(this, input, collector){
                    public static final long serialVersionUID = 0L;
                    private final int input$3;
                    private final ResultFuture collector$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.collector$1.complete((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.input$3 * 2})));
                    }
                    {
                        this.input$3 = input$3;
                        this.collector$1 = collector$1;
                    }
                }, (ExecutionContext)ExecutionContext$.MODULE$.global());
            }
        };
        DataStream asyncMapped = ordered ? AsyncDataStream$.MODULE$.orderedWait(source, AsyncDataStreamITCase$.MODULE$.timeout(), TimeUnit.MILLISECONDS, (Function2)asyncFunction, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE)) : AsyncDataStream$.MODULE$.unorderedWait(source, AsyncDataStreamITCase$.MODULE$.timeout(), TimeUnit.MILLISECONDS, (Function2)asyncFunction, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        this.executeAndValidate(ordered, env, (DataStream<Object>)asyncMapped, (ArrayBuffer<Object>)((ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}))));
    }
}

