/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.scala;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.scala.AsyncDataStream$;
import org.apache.flink.streaming.api.scala.AsyncDataStreamITCase$;
import org.apache.flink.streaming.api.scala.AsyncFunctionWithTimeoutExpired;
import org.apache.flink.streaming.api.scala.AsyncFunctionWithoutTimeoutExpired;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.api.scala.MyRichAsyncFunction;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.streaming.api.scala.async.AsyncFunction;
import org.apache.flink.streaming.api.scala.async.ResultFuture;
import org.apache.flink.test.util.AbstractTestBase;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function0;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005=r!B\u0001\u0003\u0011\u0003y\u0011!F!ts:\u001cG)\u0019;b'R\u0014X-Y7J)\u000e\u000b7/\u001a\u0006\u0003\u0007\u0011\tQa]2bY\u0006T!!\u0002\u0004\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\b\u0011\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u0013)\tQA\u001a7j].T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u0001\u0001C\u0001\t\u0012\u001b\u0005\u0011a!\u0002\n\u0003\u0011\u0003\u0019\"!F!ts:\u001cG)\u0019;b'R\u0014X-Y7J)\u000e\u000b7/Z\n\u0003#Q\u0001\"!F\f\u000e\u0003YQ\u0011aA\u0005\u00031Y\u0011a!\u00118z%\u00164\u0007\"\u0002\u000e\u0012\t\u0003Y\u0012A\u0002\u001fj]&$h\bF\u0001\u0010\u0011%i\u0012\u00031AA\u0002\u0013%a$\u0001\u0006uKN$(+Z:vYR,\u0012a\b\t\u0004A\u0015:S\"A\u0011\u000b\u0005\t\u001a\u0013aB7vi\u0006\u0014G.\u001a\u0006\u0003IY\t!bY8mY\u0016\u001cG/[8o\u0013\t1\u0013EA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bCA\u000b)\u0013\tIcCA\u0002J]RD\u0011bK\tA\u0002\u0003\u0007I\u0011\u0002\u0017\u0002\u001dQ,7\u000f\u001e*fgVdGo\u0018\u0013fcR\u0011Q\u0006\r\t\u0003+9J!a\f\f\u0003\tUs\u0017\u000e\u001e\u0005\bc)\n\t\u00111\u0001 \u0003\rAH%\r\u0005\u0007gE\u0001\u000b\u0015B\u0010\u0002\u0017Q,7\u000f\u001e*fgVdG\u000f\t\u0005\u0006kE!\tAN\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001cX#A\u001c\u0011\u0007ajt(D\u0001:\u0015\tQ4(\u0001\u0003vi&d'\"\u0001\u001f\u0002\t)\fg/Y\u0005\u0003}e\u0012!bQ8mY\u0016\u001cG/[8o!\t)\u0002)\u0003\u0002B-\t9!i\\8mK\u0006t\u0007\u0006\u0002\u001bD/b\u0003\"\u0001\u0012+\u000f\u0005\u0015\u000bfB\u0001$O\u001d\t9EJ\u0004\u0002I\u00176\t\u0011J\u0003\u0002K\u001d\u00051AH]8pizJ\u0011!D\u0005\u0003\u001b2\tQA[;oSRL!a\u0014)\u0002\u000fI,hN\\3sg*\u0011Q\nD\u0005\u0003%N\u000bQ\u0002U1sC6,G/\u001a:ju\u0016$'BA(Q\u0013\t)fK\u0001\u0006QCJ\fW.\u001a;feNT!AU*\u0002\t9\fW.Z\u0011\u00023\u0006iqN\u001d3fe\u0016$\u0007%\u0010\u0011|au4AA\u0005\u0002\u00017N\u0011!\f\u0018\t\u0003;\u0006l\u0011A\u0018\u0006\u0003u}S!\u0001\u0019\u0005\u0002\tQ,7\u000f^\u0005\u0003Ez\u0013\u0001#\u00112tiJ\f7\r\u001e+fgR\u0014\u0015m]3\t\u0011\u0011T&\u0011!Q\u0001\n}\nqa\u001c:eKJ,G\rC\u0003\u001b5\u0012\u0005a\r\u0006\u0002hQB\u0011\u0001C\u0017\u0005\u0006I\u0016\u0004\ra\u0010\u0005\u0006Uj#\ta[\u0001\u0015i\u0016\u001cH/Q:z]\u000e<\u0016\u000e\u001e5US6,w.\u001e;\u0015\u00035B#![7\u0011\u00059|W\"\u0001)\n\u0005A\u0004&\u0001\u0002+fgRDQA\u001d.\u0005\u0002-\fq\u0003^3ti\u0006\u001b\u0018P\\2XSRDw.\u001e;US6,w.\u001e;)\u0005El\u0007\"B;[\t\u00131\u0018AE3yK\u000e,H/Z!oIZ\u000bG.\u001b3bi\u0016$b!L<y{\u0006\u0015\u0001\"\u00023u\u0001\u0004y\u0004\"B=u\u0001\u0004Q\u0018aA3omB\u0011\u0001c_\u0005\u0003y\n\u0011!d\u0015;sK\u0006lW\t_3dkRLwN\\#om&\u0014xN\\7f]RDQA ;A\u0002}\f!\u0002Z1uCN#(/Z1n!\u0011\u0001\u0012\u0011A\u0014\n\u0007\u0005\r!A\u0001\u0006ECR\f7\u000b\u001e:fC6Da!a\u0002u\u0001\u0004y\u0012AD3ya\u0016\u001cG/\u001a3SKN,H\u000e\u001e\u0005\u0007\u0003\u0017QF\u0011A6\u0002GQ,7\u000f\u001e*jG\"\f5/\u001f8d\rVt7\r^5p]J+h\u000e^5nK\u000e{g\u000e^3yi\"\u001a\u0011\u0011B7\t\r\u0005E!\f\"\u0001l\u0003\r\"Xm\u001d;Bgft7mV1jiV\u001b\u0018N\\4B]>t\u00170\\8vg\u001a+hn\u0019;j_:D3!a\u0004nQ\u001dQ\u0016qCA\u0012\u0003K\u0001B!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0004\u0003;\u0001\u0016A\u0002:v]:,'/\u0003\u0003\u0002\"\u0005m!a\u0002*v]^KG\u000f[\u0001\u0006m\u0006dW/Z\u0012\u0003\u0003O\u0001B!!\u000b\u0002,5\t1+C\u0002\u0002.M\u0013Q\u0002U1sC6,G/\u001a:ju\u0016$\u0007")
public class AsyncDataStreamITCase
extends AbstractTestBase {
    private final boolean ordered;

    @Parameterized.Parameters(name="ordered = {0}")
    public static Collection<Object> parameters() {
        return AsyncDataStreamITCase$.MODULE$.parameters();
    }

    @Test
    public void testAsyncWithTimeout() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setParallelism(1);
        DataStream source = env.fromElements((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        long timeout = 1L;
        DataStream asyncMapped = this.ordered ? AsyncDataStream$.MODULE$.orderedWait(source, (AsyncFunction)new AsyncFunctionWithTimeoutExpired(), timeout, TimeUnit.MILLISECONDS, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE)) : AsyncDataStream$.MODULE$.unorderedWait(source, (AsyncFunction)new AsyncFunctionWithTimeoutExpired(), timeout, TimeUnit.MILLISECONDS, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        this.executeAndValidate(this.ordered, env, (DataStream<Object>)asyncMapped, (ArrayBuffer<Object>)((ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3}))));
    }

    @Test
    public void testAsyncWithoutTimeout() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setParallelism(1);
        DataStream source = env.fromElements((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        long timeout = 1L;
        DataStream asyncMapped = this.ordered ? AsyncDataStream$.MODULE$.orderedWait(source, (AsyncFunction)new AsyncFunctionWithoutTimeoutExpired(), timeout, TimeUnit.MILLISECONDS, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE)) : AsyncDataStream$.MODULE$.unorderedWait(source, (AsyncFunction)new AsyncFunctionWithoutTimeoutExpired(), timeout, TimeUnit.MILLISECONDS, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        this.executeAndValidate(this.ordered, env, (DataStream<Object>)asyncMapped, (ArrayBuffer<Object>)((ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}))));
    }

    private void executeAndValidate(boolean ordered, StreamExecutionEnvironment env, DataStream<Object> dataStream, ArrayBuffer<Object> expectedResult) {
        AsyncDataStreamITCase$.MODULE$.org$apache$flink$streaming$api$scala$AsyncDataStreamITCase$$testResult_$eq((ArrayBuffer<Object>)((ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
        dataStream.addSink((SinkFunction)new SinkFunction<Object>(this){

            public void invoke(int value) {
                AsyncDataStreamITCase$.MODULE$.org$apache$flink$streaming$api$scala$AsyncDataStreamITCase$$testResult().$plus$eq((Object)BoxesRunTime.boxToInteger((int)value));
            }
        });
        env.execute("testAsyncDataStream");
        if (ordered) {
            Assert.assertEquals(expectedResult, AsyncDataStreamITCase$.MODULE$.org$apache$flink$streaming$api$scala$AsyncDataStreamITCase$$testResult());
        } else {
            Assert.assertEquals(expectedResult, (Object)AsyncDataStreamITCase$.MODULE$.org$apache$flink$streaming$api$scala$AsyncDataStreamITCase$$testResult().sorted((Ordering)Ordering.Int$.MODULE$));
        }
    }

    @Test
    public void testRichAsyncFunctionRuntimeContext() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setParallelism(1);
        DataStream source = env.fromElements((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        long timeout = 10000L;
        MyRichAsyncFunction richAsyncFunction = new MyRichAsyncFunction();
        DataStream asyncMapped = this.ordered ? AsyncDataStream$.MODULE$.orderedWait(source, (AsyncFunction)richAsyncFunction, timeout, TimeUnit.MILLISECONDS, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE)) : AsyncDataStream$.MODULE$.unorderedWait(source, (AsyncFunction)richAsyncFunction, timeout, TimeUnit.MILLISECONDS, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        this.executeAndValidate(false, env, (DataStream<Object>)asyncMapped, (ArrayBuffer<Object>)((ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}))));
    }

    @Test
    public void testAsyncWaitUsingAnonymousFunction() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setParallelism(1);
        DataStream source = env.fromElements((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        Serializable asyncFunction = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(int input, ResultFuture<Object> collector) {
                Future$.MODULE$.apply((Function0)new Serializable(this, input, collector){
                    public static final long serialVersionUID = 0L;
                    private final int input$4;
                    private final ResultFuture collector$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.collector$1.complete((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.input$4 * 2})));
                    }
                    {
                        this.input$4 = input$4;
                        this.collector$1 = collector$1;
                    }
                }, (ExecutionContext)ExecutionContext$.MODULE$.global());
            }
        };
        long timeout = 10000L;
        DataStream asyncMapped = this.ordered ? AsyncDataStream$.MODULE$.orderedWait(source, timeout, TimeUnit.MILLISECONDS, (Function2)asyncFunction, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE)) : AsyncDataStream$.MODULE$.unorderedWait(source, timeout, TimeUnit.MILLISECONDS, (Function2)asyncFunction, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        this.executeAndValidate(this.ordered, env, (DataStream<Object>)asyncMapped, (ArrayBuffer<Object>)((ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}))));
    }

    public AsyncDataStreamITCase(boolean ordered) {
        this.ordered = ordered;
    }
}

