/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.python.api.functions;

import java.io.IOException;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.python.api.functions.AbstractPythonUDF;
import org.apache.flink.streaming.python.api.functions.PyKey;
import org.apache.flink.streaming.python.util.serialization.SerializationUtils;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonKeySelector
implements KeySelector<PyObject, PyKey> {
    private static final long serialVersionUID = 7403775239671366607L;
    private static final Logger LOG = LoggerFactory.getLogger(PythonKeySelector.class);
    private final byte[] serFun;
    private transient KeySelector<PyObject, Object> fun;

    public PythonKeySelector(KeySelector<PyObject, PyKey> fun) throws IOException {
        this.serFun = SerializationUtils.serializeObject(fun);
    }

    public PyKey getKey(PyObject value) throws Exception {
        if (this.fun == null) {
            this.fun = (KeySelector)SerializationUtils.deserializeObject(this.serFun);
        }
        try {
            Object key = this.fun.getKey((Object)value);
            return new PyKey(key);
        }
        catch (PyException pe) {
            throw AbstractPythonUDF.createAndLogException(pe, LOG);
        }
    }
}

