/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.python.api.environment;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.environment.LocalStreamEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.python.api.environment.PythonStreamExecutionEnvironment;

public class PythonEnvironmentFactory {
    private final String localTmpPath;
    private final String scriptName;

    public PythonEnvironmentFactory(String localTmpPath, String scriptName) {
        this.localTmpPath = localTmpPath;
        this.scriptName = scriptName;
    }

    public PythonStreamExecutionEnvironment get_execution_environment() {
        return new PythonStreamExecutionEnvironment(StreamExecutionEnvironment.getExecutionEnvironment(), new Path(this.localTmpPath), this.scriptName);
    }

    public PythonStreamExecutionEnvironment create_local_execution_environment(Configuration config2) {
        return new PythonStreamExecutionEnvironment((StreamExecutionEnvironment)new LocalStreamEnvironment(config2), new Path(this.localTmpPath), this.scriptName);
    }

    public PythonStreamExecutionEnvironment create_local_execution_environment(int parallelism, Configuration config2) {
        return new PythonStreamExecutionEnvironment((StreamExecutionEnvironment)StreamExecutionEnvironment.createLocalEnvironment((int)parallelism, (Configuration)config2), new Path(this.localTmpPath), this.scriptName);
    }

    public PythonStreamExecutionEnvironment create_remote_execution_environment(String host, int port, String ... jar_files) {
        return new PythonStreamExecutionEnvironment(StreamExecutionEnvironment.createRemoteEnvironment((String)host, (int)port, (String[])jar_files), new Path(this.localTmpPath), this.scriptName);
    }

    public PythonStreamExecutionEnvironment create_remote_execution_environment(String host, int port, Configuration config2, String ... jar_files) {
        return new PythonStreamExecutionEnvironment(StreamExecutionEnvironment.createRemoteEnvironment((String)host, (int)port, (Configuration)config2, (String[])jar_files), new Path(this.localTmpPath), this.scriptName);
    }

    public PythonStreamExecutionEnvironment create_remote_execution_environment(String host, int port, int parallelism, String ... jar_files) {
        return new PythonStreamExecutionEnvironment(StreamExecutionEnvironment.createRemoteEnvironment((String)host, (int)port, (int)parallelism, (String[])jar_files), new Path(this.localTmpPath), this.scriptName);
    }
}

