/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl.number.formatters;

import java.util.Deque;
import org.python.icu.impl.number.Format;
import org.python.icu.impl.number.FormatQuantity;
import org.python.icu.impl.number.ModifierHolder;
import org.python.icu.impl.number.NumberStringBuilder;

public class RangeFormat
extends Format {
    private final String separator;
    private final Format left;
    private final Format right;

    public RangeFormat(Format left, Format right, String separator) {
        this.separator = separator;
        this.left = left;
        this.right = right;
        if (left == null || right == null) {
            throw new IllegalArgumentException("Both child formatters are required for RangeFormat");
        }
    }

    @Override
    public int process(Deque<FormatQuantity> inputs, ModifierHolder mods, NumberStringBuilder string2, int startIndex) {
        ModifierHolder lMods = new ModifierHolder();
        ModifierHolder rMods = new ModifierHolder();
        int lLen = this.left.process(inputs, lMods, string2, startIndex);
        int rLen = this.right.process(inputs, rMods, string2, startIndex + lLen);
        while (lMods.peekLast() != null && lMods.peekLast() == rMods.peekLast()) {
            mods.add(lMods.removeLast());
            rMods.removeLast();
        }
        lLen += lMods.applyAll(string2, startIndex, startIndex + lLen);
        rLen += rMods.applyAll(string2, startIndex + lLen, startIndex + lLen + rLen);
        int sLen = string2.insert(startIndex + lLen, this.separator, null);
        return lLen + sLen + rLen;
    }
}

