/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.python.api.functions;

import java.io.IOException;
import org.apache.flink.streaming.api.collector.selector.OutputSelector;
import org.apache.flink.streaming.python.api.functions.AbstractPythonUDF;
import org.apache.flink.streaming.python.util.serialization.SerializationUtils;
import org.apache.flink.util.FlinkRuntimeException;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonOutputSelector
implements OutputSelector<PyObject> {
    private static final long serialVersionUID = 909266346633598177L;
    private static final Logger LOG = LoggerFactory.getLogger(PythonOutputSelector.class);
    private final byte[] serFun;
    private transient OutputSelector<PyObject> fun;

    public PythonOutputSelector(OutputSelector<PyObject> fun) throws IOException {
        this.serFun = SerializationUtils.serializeObject(fun);
    }

    public Iterable<String> select(PyObject value) {
        if (this.fun == null) {
            try {
                this.fun = (OutputSelector)SerializationUtils.deserializeObject(this.serFun);
            }
            catch (Exception e) {
                throw new FlinkRuntimeException("Failed to deserialize user-defined function.", (Throwable)e);
            }
        }
        try {
            return this.fun.select((Object)value);
        }
        catch (PyException pe) {
            throw new FlinkRuntimeException((Throwable)AbstractPythonUDF.createAndLogException(pe, LOG));
        }
    }
}

