/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.python.api;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.UUID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.python.PythonOptions;
import org.apache.flink.streaming.python.api.environment.PythonEnvironmentFactory;
import org.apache.flink.streaming.python.util.InterpreterUtils;
import org.apache.flink.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonStreamBinder {
    private static final Logger LOG = LoggerFactory.getLogger(PythonStreamBinder.class);
    private final String localTmpPath;
    private Path tmpDistributedDir;

    PythonStreamBinder(Configuration globalConfig) {
        String configuredLocalTmpPath = globalConfig.getString(PythonOptions.PLAN_TMP_DIR);
        this.localTmpPath = configuredLocalTmpPath != null ? configuredLocalTmpPath : System.getProperty("java.io.tmpdir") + File.separator + "flink_streaming_plan_" + UUID.randomUUID();
        this.tmpDistributedDir = new Path(globalConfig.getString(PythonOptions.DC_TMP_DIR));
    }

    public static void main(String[] args) throws Exception {
        Configuration globalConfig = GlobalConfiguration.loadConfiguration();
        PythonStreamBinder binder = new PythonStreamBinder(globalConfig);
        try {
            binder.runPlan(args);
        }
        catch (Exception e) {
            System.out.println("Failed to run plan: " + e.getMessage());
            e.printStackTrace();
            LOG.error("Failed to run plan.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runPlan(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("Usage: prog <pathToScript> [parameter1]..[parameterX] - [<pathToPackage1> .. [<pathToPackageX]]");
            return;
        }
        int split = 0;
        for (int x = 0; x < args.length; ++x) {
            if (!args[x].equals("-")) continue;
            split = x;
            break;
        }
        try {
            String planFile = args[0];
            String[] filesToCopy = Arrays.copyOfRange(args, 1, split == 0 ? args.length : split);
            String[] planArgumentsArray = Arrays.copyOfRange(args, split == 0 ? args.length : split + 1, args.length);
            Path planPath = new Path(planFile);
            if (!FileSystem.getUnguardedFileSystem((URI)planPath.toUri()).exists(planPath)) {
                throw new FileNotFoundException("Plan file " + planFile + " does not exist.");
            }
            for (String file : filesToCopy) {
                Path filePath = new Path(file);
                if (FileSystem.getUnguardedFileSystem((URI)filePath.toUri()).exists(filePath)) continue;
                throw new FileNotFoundException("Additional file " + file + " does not exist.");
            }
            Path targetDir = new Path(this.localTmpPath);
            PythonStreamBinder.deleteIfExists(targetDir);
            targetDir.getFileSystem().mkdirs(targetDir);
            PythonStreamBinder.copyFile(planPath, targetDir, planPath.getName());
            for (String file : filesToCopy) {
                Path source = new Path(file);
                PythonStreamBinder.copyFile(source, targetDir, source.getName());
            }
            String planNameWithExtension = planPath.getName();
            String planName = planNameWithExtension.substring(0, planNameWithExtension.indexOf(".py"));
            InterpreterUtils.initAndExecPythonScript(new PythonEnvironmentFactory(this.localTmpPath, planName), Paths.get(this.localTmpPath, new String[0]), planName, planArgumentsArray);
        }
        finally {
            try {
                FileSystem local = FileSystem.getLocalFileSystem();
                local.delete(new Path(this.localTmpPath), true);
            }
            catch (IOException ioe) {
                LOG.error("PythonAPI file cleanup failed. {}", (Object)ioe.getMessage());
            }
        }
    }

    private static void deleteIfExists(Path path) throws IOException {
        FileSystem fs = path.getFileSystem();
        if (fs.exists(path)) {
            fs.delete(path, true);
        }
    }

    private static void copyFile(Path source, Path targetDirectory, String name) throws IOException {
        Path targetFilePath = new Path(targetDirectory, name);
        PythonStreamBinder.deleteIfExists(targetFilePath);
        FileUtils.copy((Path)source, (Path)targetFilePath, (boolean)true);
    }
}

