/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.python.util;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.streaming.python.api.environment.PythonEnvironmentFactory;
import org.apache.flink.streaming.python.api.environment.PythonStreamExecutionEnvironment;
import org.apache.flink.streaming.python.util.serialization.SerializationUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.FlinkRuntimeException;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterpreterUtils {
    private static final Logger LOG = LoggerFactory.getLogger(InterpreterUtils.class);
    private static PythonInterpreter pythonInterpreter = null;
    private static boolean jythonInitialized = false;

    private InterpreterUtils() {
    }

    public static <X> X deserializeFunction(RuntimeContext context, byte[] serFun) throws FlinkException {
        if (!jythonInitialized) {
            String path = context.getDistributedCache().getFile("flink").getAbsolutePath();
            String scriptName = PythonStreamExecutionEnvironment.PythonJobParameters.getScriptName(context.getExecutionConfig().getGlobalJobParameters());
            try {
                InterpreterUtils.initPythonInterpreter(new String[]{Paths.get(path, scriptName).toString()}, path, scriptName);
            }
            catch (Exception e) {
                LOG.error("Initialization of jython failed.");
                try {
                    LOG.error("Initialization of jython failed.", (Throwable)e);
                    throw new FlinkRuntimeException("Initialization of jython failed.", (Throwable)e);
                }
                catch (Exception ie) {
                    LOG.error("Initialization of jython failed. Could not print original stacktrace.", (Throwable)ie);
                    throw new FlinkRuntimeException("Initialization of jython failed. Could not print original stacktrace.");
                }
            }
        }
        try {
            return SerializationUtils.deserializeObject(serFun);
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new FlinkException("Deserialization of user-function failed.", (Throwable)ex);
        }
    }

    public static void initAndExecPythonScript(PythonEnvironmentFactory factory, Path scriptDirectory, String scriptName, String[] args) {
        String[] fullArgs = new String[args.length + 1];
        fullArgs[0] = scriptDirectory.resolve(scriptName).toString();
        System.arraycopy(args, 0, fullArgs, 1, args.length);
        PythonInterpreter pythonInterpreter = InterpreterUtils.initPythonInterpreter(fullArgs, scriptDirectory.toUri().getPath(), scriptName);
        pythonInterpreter.set("__flink_env_factory__", factory);
        pythonInterpreter.exec(scriptName + ".main(__flink_env_factory__)");
    }

    private static synchronized PythonInterpreter initPythonInterpreter(String[] args, String pythonPath, String scriptName) {
        if (!jythonInitialized) {
            System.getProperties().put("python.options.includeJavaStackInExceptions", "false");
            PySystemState.initialize(System.getProperties(), new Properties(), args);
            pythonInterpreter = new PythonInterpreter();
            InterpreterUtils.pythonInterpreter.getSystemState().path.add(0, pythonPath);
            pythonInterpreter.setErr(System.err);
            pythonInterpreter.setOut(System.out);
            pythonInterpreter.exec("import " + scriptName);
            jythonInitialized = true;
        }
        return pythonInterpreter;
    }
}

