/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.python.api.functions;

import java.io.IOException;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.streaming.python.api.functions.AbstractPythonUDF;
import org.apache.flink.streaming.python.util.AdapterMap;
import org.apache.flink.streaming.python.util.serialization.SerializationUtils;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonReduceFunction
implements ReduceFunction<PyObject> {
    private static final long serialVersionUID = -9070596504893036458L;
    private static final Logger LOG = LoggerFactory.getLogger(PythonReduceFunction.class);
    private final byte[] serFun;
    private transient ReduceFunction<PyObject> fun;

    public PythonReduceFunction(ReduceFunction<PyObject> fun) throws IOException {
        this.serFun = SerializationUtils.serializeObject(fun);
    }

    public PyObject reduce(PyObject value1, PyObject value2) throws Exception {
        if (this.fun == null) {
            this.fun = (ReduceFunction)SerializationUtils.deserializeObject(this.serFun);
        }
        try {
            return AdapterMap.adapt(this.fun.reduce((Object)value1, (Object)value2));
        }
        catch (PyException pe) {
            throw AbstractPythonUDF.createAndLogException(pe, LOG);
        }
    }
}

