/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.python.api.datastream;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.streaming.api.collector.selector.OutputSelector;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.IterativeStream;
import org.apache.flink.streaming.api.datastream.KeyedStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.datastream.SplitStream;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.python.api.datastream.PythonIterativeStream;
import org.apache.flink.streaming.python.api.datastream.PythonKeyedStream;
import org.apache.flink.streaming.python.api.datastream.PythonSingleOutputStreamOperator;
import org.apache.flink.streaming.python.api.datastream.PythonSplitStream;
import org.apache.flink.streaming.python.api.functions.PyKey;
import org.apache.flink.streaming.python.api.functions.PythonFilterFunction;
import org.apache.flink.streaming.python.api.functions.PythonFlatMapFunction;
import org.apache.flink.streaming.python.api.functions.PythonKeySelector;
import org.apache.flink.streaming.python.api.functions.PythonMapFunction;
import org.apache.flink.streaming.python.api.functions.PythonOutputSelector;
import org.apache.flink.streaming.python.api.functions.PythonSinkFunction;
import org.apache.flink.streaming.python.util.serialization.PythonSerializationSchema;
import org.python.core.PyObject;

@PublicEvolving
public class PythonDataStream<D extends DataStream<PyObject>> {
    protected final D stream;

    public PythonDataStream(D stream) {
        this.stream = stream;
    }

    @SafeVarargs
    public final PythonDataStream union(PythonDataStream ... streams) {
        ArrayList<D> dsList = new ArrayList<D>();
        for (PythonDataStream ps : streams) {
            dsList.add(ps.stream);
        }
        DataStream[] dsArray = new DataStream[dsList.size()];
        return new PythonDataStream<DataStream>(this.stream.union(dsList.toArray(dsArray)));
    }

    public PythonSplitStream split(OutputSelector<PyObject> output_selector) throws IOException {
        return new PythonSplitStream((SplitStream<PyObject>)this.stream.split((OutputSelector)new PythonOutputSelector(output_selector)));
    }

    public PythonSingleOutputStreamOperator filter(FilterFunction<PyObject> filter) throws IOException {
        return new PythonSingleOutputStreamOperator((SingleOutputStreamOperator<PyObject>)this.stream.filter((FilterFunction)new PythonFilterFunction(filter)));
    }

    public PythonDataStream<SingleOutputStreamOperator<PyObject>> map(MapFunction<PyObject, PyObject> mapper) throws IOException {
        return new PythonSingleOutputStreamOperator((SingleOutputStreamOperator<PyObject>)this.stream.map((MapFunction)new PythonMapFunction(mapper)));
    }

    public PythonDataStream<SingleOutputStreamOperator<PyObject>> flat_map(FlatMapFunction<PyObject, Object> flat_mapper) throws IOException {
        return new PythonSingleOutputStreamOperator((SingleOutputStreamOperator<PyObject>)this.stream.flatMap((FlatMapFunction)new PythonFlatMapFunction(flat_mapper)));
    }

    public PythonKeyedStream key_by(KeySelector<PyObject, PyKey> selector) throws IOException {
        return new PythonKeyedStream((KeyedStream<PyObject, PyKey>)this.stream.keyBy((KeySelector)new PythonKeySelector(selector)));
    }

    @PublicEvolving
    public void output() {
        this.stream.print();
    }

    @PublicEvolving
    public void write_as_text(String path) {
        this.stream.writeAsText(path);
    }

    @PublicEvolving
    public void write_as_text(String path, FileSystem.WriteMode mode) {
        this.stream.writeAsText(path, mode);
    }

    @PublicEvolving
    public void write_to_socket(String host, Integer port, SerializationSchema<PyObject> schema) throws IOException {
        this.stream.writeToSocket(host, port.intValue(), (SerializationSchema)new PythonSerializationSchema(schema));
    }

    @PublicEvolving
    public void add_sink(SinkFunction<PyObject> sink_func) throws IOException {
        this.stream.addSink((SinkFunction)new PythonSinkFunction(sink_func));
    }

    @PublicEvolving
    public PythonIterativeStream iterate() {
        return new PythonIterativeStream((IterativeStream<PyObject>)this.stream.iterate());
    }

    @PublicEvolving
    public PythonIterativeStream iterate(Long max_wait_time_ms) {
        return new PythonIterativeStream((IterativeStream<PyObject>)this.stream.iterate(max_wait_time_ms.longValue()));
    }
}

