/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.InputTypeConfigurable;
import org.apache.flink.api.java.typeutils.MissingTypeInfo;
import org.apache.flink.optimizer.plan.StreamingPlan;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.streaming.api.collector.selector.OutputSelector;
import org.apache.flink.streaming.api.environment.CheckpointConfig;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.JSONGenerator;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.streaming.api.graph.StreamingJobGraphGenerator;
import org.apache.flink.streaming.api.operators.OutputTypeConfigurable;
import org.apache.flink.streaming.api.operators.StoppableStreamSource;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamSource;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.runtime.partitioner.ForwardPartitioner;
import org.apache.flink.streaming.runtime.partitioner.RebalancePartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.tasks.OneInputStreamTask;
import org.apache.flink.streaming.runtime.tasks.SourceStreamTask;
import org.apache.flink.streaming.runtime.tasks.StoppableSourceStreamTask;
import org.apache.flink.streaming.runtime.tasks.StreamIterationHead;
import org.apache.flink.streaming.runtime.tasks.StreamIterationTail;
import org.apache.flink.streaming.runtime.tasks.TwoInputStreamTask;
import org.apache.flink.util.OutputTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class StreamGraph
extends StreamingPlan {
    private static final Logger LOG = LoggerFactory.getLogger(StreamGraph.class);
    private String jobName = "Flink Streaming Job";
    private final StreamExecutionEnvironment environment;
    private final ExecutionConfig executionConfig;
    private final CheckpointConfig checkpointConfig;
    private boolean chaining;
    private Map<Integer, StreamNode> streamNodes;
    private Set<Integer> sources;
    private Set<Integer> sinks;
    private Map<Integer, Tuple2<Integer, List<String>>> virtualSelectNodes;
    private Map<Integer, Tuple2<Integer, OutputTag>> virtualSideOutputNodes;
    private Map<Integer, Tuple2<Integer, StreamPartitioner<?>>> virtualPartitionNodes;
    protected Map<Integer, String> vertexIDtoBrokerID;
    protected Map<Integer, Long> vertexIDtoLoopTimeout;
    private StateBackend stateBackend;
    private Set<Tuple2<StreamNode, StreamNode>> iterationSourceSinkPairs;

    public StreamGraph(StreamExecutionEnvironment environment) {
        this.environment = environment;
        this.executionConfig = environment.getConfig();
        this.checkpointConfig = environment.getCheckpointConfig();
        this.clear();
    }

    public void clear() {
        this.streamNodes = new HashMap<Integer, StreamNode>();
        this.virtualSelectNodes = new HashMap<Integer, Tuple2<Integer, List<String>>>();
        this.virtualSideOutputNodes = new HashMap<Integer, Tuple2<Integer, OutputTag>>();
        this.virtualPartitionNodes = new HashMap();
        this.vertexIDtoBrokerID = new HashMap<Integer, String>();
        this.vertexIDtoLoopTimeout = new HashMap<Integer, Long>();
        this.iterationSourceSinkPairs = new HashSet<Tuple2<StreamNode, StreamNode>>();
        this.sources = new HashSet<Integer>();
        this.sinks = new HashSet<Integer>();
    }

    public StreamExecutionEnvironment getEnvironment() {
        return this.environment;
    }

    public ExecutionConfig getExecutionConfig() {
        return this.executionConfig;
    }

    public CheckpointConfig getCheckpointConfig() {
        return this.checkpointConfig;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setChaining(boolean chaining) {
        this.chaining = chaining;
    }

    public void setStateBackend(StateBackend backend) {
        this.stateBackend = backend;
    }

    public StateBackend getStateBackend() {
        return this.stateBackend;
    }

    public boolean isChainingEnabled() {
        return this.chaining;
    }

    public boolean isIterative() {
        return !this.vertexIDtoLoopTimeout.isEmpty();
    }

    public <IN, OUT> void addSource(Integer vertexID, String slotSharingGroup, @Nullable String coLocationGroup, StreamOperator<OUT> operatorObject, TypeInformation<IN> inTypeInfo, TypeInformation<OUT> outTypeInfo, String operatorName) {
        this.addOperator(vertexID, slotSharingGroup, coLocationGroup, operatorObject, inTypeInfo, outTypeInfo, operatorName);
        this.sources.add(vertexID);
    }

    public <IN, OUT> void addSink(Integer vertexID, String slotSharingGroup, @Nullable String coLocationGroup, StreamOperator<OUT> operatorObject, TypeInformation<IN> inTypeInfo, TypeInformation<OUT> outTypeInfo, String operatorName) {
        this.addOperator(vertexID, slotSharingGroup, coLocationGroup, operatorObject, inTypeInfo, outTypeInfo, operatorName);
        this.sinks.add(vertexID);
    }

    public <IN, OUT> void addOperator(Integer vertexID, String slotSharingGroup, @Nullable String coLocationGroup, StreamOperator<OUT> operatorObject, TypeInformation<IN> inTypeInfo, TypeInformation<OUT> outTypeInfo, String operatorName) {
        if (operatorObject instanceof StoppableStreamSource) {
            this.addNode(vertexID, slotSharingGroup, coLocationGroup, StoppableSourceStreamTask.class, operatorObject, operatorName);
        } else if (operatorObject instanceof StreamSource) {
            this.addNode(vertexID, slotSharingGroup, coLocationGroup, SourceStreamTask.class, operatorObject, operatorName);
        } else {
            this.addNode(vertexID, slotSharingGroup, coLocationGroup, OneInputStreamTask.class, operatorObject, operatorName);
        }
        TypeSerializer inSerializer = inTypeInfo != null && !(inTypeInfo instanceof MissingTypeInfo) ? inTypeInfo.createSerializer(this.executionConfig) : null;
        TypeSerializer outSerializer = outTypeInfo != null && !(outTypeInfo instanceof MissingTypeInfo) ? outTypeInfo.createSerializer(this.executionConfig) : null;
        this.setSerializers(vertexID, inSerializer, null, outSerializer);
        if (operatorObject instanceof OutputTypeConfigurable && outTypeInfo != null) {
            OutputTypeConfigurable outputTypeConfigurable = (OutputTypeConfigurable)((Object)operatorObject);
            outputTypeConfigurable.setOutputType(outTypeInfo, this.executionConfig);
        }
        if (operatorObject instanceof InputTypeConfigurable) {
            InputTypeConfigurable inputTypeConfigurable = (InputTypeConfigurable)operatorObject;
            inputTypeConfigurable.setInputType(inTypeInfo, this.executionConfig);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Vertex: {}", (Object)vertexID);
        }
    }

    public <IN1, IN2, OUT> void addCoOperator(Integer vertexID, String slotSharingGroup, @Nullable String coLocationGroup, TwoInputStreamOperator<IN1, IN2, OUT> taskOperatorObject, TypeInformation<IN1> in1TypeInfo, TypeInformation<IN2> in2TypeInfo, TypeInformation<OUT> outTypeInfo, String operatorName) {
        this.addNode(vertexID, slotSharingGroup, coLocationGroup, TwoInputStreamTask.class, taskOperatorObject, operatorName);
        TypeSerializer outSerializer = outTypeInfo != null && !(outTypeInfo instanceof MissingTypeInfo) ? outTypeInfo.createSerializer(this.executionConfig) : null;
        this.setSerializers(vertexID, in1TypeInfo.createSerializer(this.executionConfig), in2TypeInfo.createSerializer(this.executionConfig), outSerializer);
        if (taskOperatorObject instanceof OutputTypeConfigurable) {
            OutputTypeConfigurable outputTypeConfigurable = (OutputTypeConfigurable)((Object)taskOperatorObject);
            outputTypeConfigurable.setOutputType(outTypeInfo, this.executionConfig);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("CO-TASK: {}", (Object)vertexID);
        }
    }

    protected StreamNode addNode(Integer vertexID, String slotSharingGroup, @Nullable String coLocationGroup, Class<? extends AbstractInvokable> vertexClass, StreamOperator<?> operatorObject, String operatorName) {
        if (this.streamNodes.containsKey(vertexID)) {
            throw new RuntimeException("Duplicate vertexID " + vertexID);
        }
        StreamNode vertex = new StreamNode(this.environment, vertexID, slotSharingGroup, coLocationGroup, operatorObject, operatorName, new ArrayList(), vertexClass);
        this.streamNodes.put(vertexID, vertex);
        return vertex;
    }

    public void addVirtualSelectNode(Integer originalId, Integer virtualId, List<String> selectedNames) {
        if (this.virtualSelectNodes.containsKey(virtualId)) {
            throw new IllegalStateException("Already has virtual select node with id " + virtualId);
        }
        this.virtualSelectNodes.put(virtualId, (Tuple2<Integer, List<String>>)new Tuple2((Object)originalId, selectedNames));
    }

    public void addVirtualSideOutputNode(Integer originalId, Integer virtualId, OutputTag outputTag) {
        if (this.virtualSideOutputNodes.containsKey(virtualId)) {
            throw new IllegalStateException("Already has virtual output node with id " + virtualId);
        }
        for (Tuple2<Integer, OutputTag> tag : this.virtualSideOutputNodes.values()) {
            if (!((Integer)tag.f0).equals(originalId) || !((OutputTag)tag.f1).getId().equals(outputTag.getId()) || ((OutputTag)tag.f1).getTypeInfo().equals((Object)outputTag.getTypeInfo())) continue;
            throw new IllegalArgumentException("Trying to add a side output for the same side-output id with a different type. This is not allowed. Side-output ID: " + ((OutputTag)tag.f1).getId());
        }
        this.virtualSideOutputNodes.put(virtualId, (Tuple2<Integer, OutputTag>)new Tuple2((Object)originalId, (Object)outputTag));
    }

    public void addVirtualPartitionNode(Integer originalId, Integer virtualId, StreamPartitioner<?> partitioner) {
        if (this.virtualPartitionNodes.containsKey(virtualId)) {
            throw new IllegalStateException("Already has virtual partition node with id " + virtualId);
        }
        this.virtualPartitionNodes.put(virtualId, new Tuple2((Object)originalId, partitioner));
    }

    public String getSlotSharingGroup(Integer id) {
        if (this.virtualSideOutputNodes.containsKey(id)) {
            Integer mappedId = (Integer)this.virtualSideOutputNodes.get((Object)id).f0;
            return this.getSlotSharingGroup(mappedId);
        }
        if (this.virtualSelectNodes.containsKey(id)) {
            Integer mappedId = (Integer)this.virtualSelectNodes.get((Object)id).f0;
            return this.getSlotSharingGroup(mappedId);
        }
        if (this.virtualPartitionNodes.containsKey(id)) {
            Integer mappedId = (Integer)this.virtualPartitionNodes.get((Object)id).f0;
            return this.getSlotSharingGroup(mappedId);
        }
        StreamNode node = this.getStreamNode(id);
        return node.getSlotSharingGroup();
    }

    public void addEdge(Integer upStreamVertexID, Integer downStreamVertexID, int typeNumber) {
        this.addEdgeInternal(upStreamVertexID, downStreamVertexID, typeNumber, null, new ArrayList<String>(), null);
    }

    private void addEdgeInternal(Integer upStreamVertexID, Integer downStreamVertexID, int typeNumber, StreamPartitioner<?> partitioner, List<String> outputNames, OutputTag outputTag) {
        if (this.virtualSideOutputNodes.containsKey(upStreamVertexID)) {
            int virtualId = upStreamVertexID;
            upStreamVertexID = (Integer)this.virtualSideOutputNodes.get((Object)Integer.valueOf((int)virtualId)).f0;
            if (outputTag == null) {
                outputTag = (OutputTag)this.virtualSideOutputNodes.get((Object)Integer.valueOf((int)virtualId)).f1;
            }
            this.addEdgeInternal(upStreamVertexID, downStreamVertexID, typeNumber, partitioner, null, outputTag);
        } else if (this.virtualSelectNodes.containsKey(upStreamVertexID)) {
            int virtualId = upStreamVertexID;
            upStreamVertexID = (Integer)this.virtualSelectNodes.get((Object)Integer.valueOf((int)virtualId)).f0;
            if (outputNames.isEmpty()) {
                outputNames = (List)this.virtualSelectNodes.get((Object)Integer.valueOf((int)virtualId)).f1;
            }
            this.addEdgeInternal(upStreamVertexID, downStreamVertexID, typeNumber, partitioner, outputNames, outputTag);
        } else if (this.virtualPartitionNodes.containsKey(upStreamVertexID)) {
            int virtualId = upStreamVertexID;
            upStreamVertexID = (Integer)this.virtualPartitionNodes.get((Object)Integer.valueOf((int)virtualId)).f0;
            if (partitioner == null) {
                partitioner = (StreamPartitioner)this.virtualPartitionNodes.get((Object)Integer.valueOf((int)virtualId)).f1;
            }
            this.addEdgeInternal(upStreamVertexID, downStreamVertexID, typeNumber, partitioner, outputNames, outputTag);
        } else {
            StreamNode upstreamNode = this.getStreamNode(upStreamVertexID);
            StreamNode downstreamNode = this.getStreamNode(downStreamVertexID);
            if (partitioner == null && upstreamNode.getParallelism() == downstreamNode.getParallelism()) {
                partitioner = new ForwardPartitioner();
            } else if (partitioner == null) {
                partitioner = new RebalancePartitioner();
            }
            if (partitioner instanceof ForwardPartitioner && upstreamNode.getParallelism() != downstreamNode.getParallelism()) {
                throw new UnsupportedOperationException("Forward partitioning does not allow change of parallelism. Upstream operation: " + upstreamNode + " parallelism: " + upstreamNode.getParallelism() + ", downstream operation: " + downstreamNode + " parallelism: " + downstreamNode.getParallelism() + " You must use another partitioning strategy, such as broadcast, rebalance, shuffle or global.");
            }
            StreamEdge edge = new StreamEdge(upstreamNode, downstreamNode, typeNumber, outputNames, partitioner, outputTag);
            this.getStreamNode(edge.getSourceId()).addOutEdge(edge);
            this.getStreamNode(edge.getTargetId()).addInEdge(edge);
        }
    }

    public <T> void addOutputSelector(Integer vertexID, OutputSelector<T> outputSelector) {
        if (this.virtualPartitionNodes.containsKey(vertexID)) {
            this.addOutputSelector((Integer)this.virtualPartitionNodes.get((Object)vertexID).f0, outputSelector);
        } else if (this.virtualSelectNodes.containsKey(vertexID)) {
            this.addOutputSelector((Integer)this.virtualSelectNodes.get((Object)vertexID).f0, outputSelector);
        } else {
            this.getStreamNode(vertexID).addOutputSelector(outputSelector);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Outputselector set for {}", (Object)vertexID);
            }
        }
    }

    public void setParallelism(Integer vertexID, int parallelism) {
        if (this.getStreamNode(vertexID) != null) {
            this.getStreamNode(vertexID).setParallelism(parallelism);
        }
    }

    public void setMaxParallelism(int vertexID, int maxParallelism) {
        if (this.getStreamNode(vertexID) != null) {
            this.getStreamNode(vertexID).setMaxParallelism(maxParallelism);
        }
    }

    public void setResources(int vertexID, ResourceSpec minResources, ResourceSpec preferredResources) {
        if (this.getStreamNode(vertexID) != null) {
            this.getStreamNode(vertexID).setResources(minResources, preferredResources);
        }
    }

    public void setOneInputStateKey(Integer vertexID, KeySelector<?, ?> keySelector, TypeSerializer<?> keySerializer) {
        StreamNode node = this.getStreamNode(vertexID);
        node.setStatePartitioner1(keySelector);
        node.setStateKeySerializer(keySerializer);
    }

    public void setTwoInputStateKey(Integer vertexID, KeySelector<?, ?> keySelector1, KeySelector<?, ?> keySelector2, TypeSerializer<?> keySerializer) {
        StreamNode node = this.getStreamNode(vertexID);
        node.setStatePartitioner1(keySelector1);
        node.setStatePartitioner2(keySelector2);
        node.setStateKeySerializer(keySerializer);
    }

    public void setBufferTimeout(Integer vertexID, long bufferTimeout) {
        if (this.getStreamNode(vertexID) != null) {
            this.getStreamNode(vertexID).setBufferTimeout(bufferTimeout);
        }
    }

    public void setSerializers(Integer vertexID, TypeSerializer<?> in1, TypeSerializer<?> in2, TypeSerializer<?> out) {
        StreamNode vertex = this.getStreamNode(vertexID);
        vertex.setSerializerIn1(in1);
        vertex.setSerializerIn2(in2);
        vertex.setSerializerOut(out);
    }

    public void setSerializersFrom(Integer from, Integer to) {
        StreamNode fromVertex = this.getStreamNode(from);
        StreamNode toVertex = this.getStreamNode(to);
        toVertex.setSerializerIn1(fromVertex.getTypeSerializerOut());
        toVertex.setSerializerOut(fromVertex.getTypeSerializerIn1());
    }

    public <OUT> void setOutType(Integer vertexID, TypeInformation<OUT> outType) {
        this.getStreamNode(vertexID).setSerializerOut(outType.createSerializer(this.executionConfig));
    }

    public <IN, OUT> void setOperator(Integer vertexID, StreamOperator<OUT> operatorObject) {
        this.getStreamNode(vertexID).setOperator(operatorObject);
    }

    public void setInputFormat(Integer vertexID, InputFormat<?, ?> inputFormat) {
        this.getStreamNode(vertexID).setInputFormat(inputFormat);
    }

    void setTransformationUID(Integer nodeId, String transformationId) {
        StreamNode node = this.streamNodes.get(nodeId);
        if (node != null) {
            node.setTransformationUID(transformationId);
        }
    }

    void setTransformationUserHash(Integer nodeId, String nodeHash) {
        StreamNode node = this.streamNodes.get(nodeId);
        if (node != null) {
            node.setUserHash(nodeHash);
        }
    }

    public StreamNode getStreamNode(Integer vertexID) {
        return this.streamNodes.get(vertexID);
    }

    protected Collection<? extends Integer> getVertexIDs() {
        return this.streamNodes.keySet();
    }

    public List<StreamEdge> getStreamEdges(int sourceId, int targetId) {
        ArrayList<StreamEdge> result = new ArrayList<StreamEdge>();
        for (StreamEdge edge : this.getStreamNode(sourceId).getOutEdges()) {
            if (edge.getTargetId() != targetId) continue;
            result.add(edge);
        }
        if (result.isEmpty()) {
            throw new RuntimeException("No such edge in stream graph: " + sourceId + " -> " + targetId);
        }
        return result;
    }

    public Collection<Integer> getSourceIDs() {
        return this.sources;
    }

    public Collection<Integer> getSinkIDs() {
        return this.sinks;
    }

    public Collection<StreamNode> getStreamNodes() {
        return this.streamNodes.values();
    }

    public Set<Tuple2<Integer, StreamOperator<?>>> getOperators() {
        HashSet operatorSet = new HashSet();
        for (StreamNode vertex : this.streamNodes.values()) {
            operatorSet.add(new Tuple2((Object)vertex.getId(), vertex.getOperator()));
        }
        return operatorSet;
    }

    public String getBrokerID(Integer vertexID) {
        return this.vertexIDtoBrokerID.get(vertexID);
    }

    public long getLoopTimeout(Integer vertexID) {
        return this.vertexIDtoLoopTimeout.get(vertexID);
    }

    public Tuple2<StreamNode, StreamNode> createIterationSourceAndSink(int loopId, int sourceId, int sinkId, long timeout, int parallelism, int maxParallelism, ResourceSpec minResources, ResourceSpec preferredResources) {
        StreamNode source = this.addNode(sourceId, null, null, StreamIterationHead.class, null, "IterationSource-" + loopId);
        this.sources.add(source.getId());
        this.setParallelism(source.getId(), parallelism);
        this.setMaxParallelism(source.getId(), maxParallelism);
        this.setResources(source.getId(), minResources, preferredResources);
        StreamNode sink = this.addNode(sinkId, null, null, StreamIterationTail.class, null, "IterationSink-" + loopId);
        this.sinks.add(sink.getId());
        this.setParallelism(sink.getId(), parallelism);
        this.setMaxParallelism(sink.getId(), parallelism);
        this.iterationSourceSinkPairs.add((Tuple2<StreamNode, StreamNode>)new Tuple2((Object)source, (Object)sink));
        this.vertexIDtoBrokerID.put(source.getId(), "broker-" + loopId);
        this.vertexIDtoBrokerID.put(sink.getId(), "broker-" + loopId);
        this.vertexIDtoLoopTimeout.put(source.getId(), timeout);
        this.vertexIDtoLoopTimeout.put(sink.getId(), timeout);
        return new Tuple2((Object)source, (Object)sink);
    }

    public Set<Tuple2<StreamNode, StreamNode>> getIterationSourceSinkPairs() {
        return this.iterationSourceSinkPairs;
    }

    public StreamNode getSourceVertex(StreamEdge edge) {
        return this.streamNodes.get(edge.getSourceId());
    }

    public StreamNode getTargetVertex(StreamEdge edge) {
        return this.streamNodes.get(edge.getTargetId());
    }

    private void removeEdge(StreamEdge edge) {
        this.getSourceVertex(edge).getOutEdges().remove(edge);
        this.getTargetVertex(edge).getInEdges().remove(edge);
    }

    private void removeVertex(StreamNode toRemove) {
        HashSet<StreamEdge> edgesToRemove = new HashSet<StreamEdge>();
        edgesToRemove.addAll(toRemove.getInEdges());
        edgesToRemove.addAll(toRemove.getOutEdges());
        for (StreamEdge edge : edgesToRemove) {
            this.removeEdge(edge);
        }
        this.streamNodes.remove(toRemove.getId());
    }

    public JobGraph getJobGraph(@Nullable JobID jobID) {
        if (this.isIterative() && this.checkpointConfig.isCheckpointingEnabled() && !this.checkpointConfig.isForceCheckpointing()) {
            throw new UnsupportedOperationException("Checkpointing is currently not supported by default for iterative jobs, as we cannot guarantee exactly once semantics. State checkpoints happen normally, but records in-transit during the snapshot will be lost upon failure. \nThe user can force enable state checkpoints with the reduced guarantees by calling: env.enableCheckpointing(interval,true)");
        }
        return StreamingJobGraphGenerator.createJobGraph(this, jobID);
    }

    public String getStreamingPlanAsJSON() {
        try {
            return new JSONGenerator(this).getJSON();
        }
        catch (Exception e) {
            throw new RuntimeException("JSON plan creation failed", e);
        }
    }

    public void dumpStreamingPlanAsJSON(File file) throws IOException {
        try (PrintWriter pw = null;){
            pw = new PrintWriter(new FileOutputStream(file), false);
            pw.write(this.getStreamingPlanAsJSON());
            pw.flush();
        }
    }
}

