/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.sink.Committer;
import org.apache.flink.api.connector.sink.Sink;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.runtime.operators.sink.AbstractStreamingCommitterOperator;
import org.apache.flink.streaming.runtime.operators.sink.AbstractStreamingCommitterOperatorFactory;
import org.apache.flink.streaming.runtime.operators.sink.StreamingCommitterOperator;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;

@Internal
public class StreamingCommitterOperatorFactory<CommT>
extends AbstractStreamingCommitterOperatorFactory<CommT, CommT> {
    private final Sink<?, CommT, ?, ?> sink;

    public StreamingCommitterOperatorFactory(Sink<?, CommT, ?, ?> sink) {
        this.sink = (Sink)Preconditions.checkNotNull(sink);
    }

    @Override
    AbstractStreamingCommitterOperator<CommT, CommT> createStreamingCommitterOperator() {
        try {
            return new StreamingCommitterOperator((Committer)this.sink.createCommitter().orElseThrow(() -> new IllegalStateException("Could not create committer from the sink")), (SimpleVersionedSerializer)this.sink.getCommittableSerializer().orElseThrow(() -> new IllegalStateException("Could not get committable serializer from the sink")));
        }
        catch (IOException e) {
            throw new FlinkRuntimeException("Could not create the Committer.", (Throwable)e);
        }
    }

    @Override
    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
        return StreamingCommitterOperator.class;
    }
}

