/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.api.connector.sink.Committer;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.streaming.runtime.operators.sink.AbstractStreamingCommitterOperator;
import org.apache.flink.util.Preconditions;

final class StreamingCommitterOperator<CommT>
extends AbstractStreamingCommitterOperator<CommT, CommT> {
    private final List<CommT> recoveredCommittables;
    private final Committer<CommT> committer;

    StreamingCommitterOperator(Committer<CommT> committer, SimpleVersionedSerializer<CommT> committableSerializer) {
        super(committableSerializer);
        this.committer = (Committer)Preconditions.checkNotNull(committer);
        this.recoveredCommittables = new ArrayList<CommT>();
    }

    @Override
    void recoveredCommittables(List<CommT> committables) {
        this.recoveredCommittables.addAll((Collection)Preconditions.checkNotNull(committables));
    }

    @Override
    List<CommT> prepareCommit(List<CommT> input) {
        Preconditions.checkNotNull(input);
        ArrayList<CommT> result = new ArrayList<CommT>(this.recoveredCommittables);
        this.recoveredCommittables.clear();
        result.addAll(input);
        return result;
    }

    @Override
    List<CommT> commit(List<CommT> committables) throws Exception {
        return this.committer.commit((List)Preconditions.checkNotNull(committables));
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.committer.close();
    }
}

