/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.connector.sink.Committer;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.Preconditions;

final class BatchCommitterOperator<CommT>
extends AbstractStreamOperator<CommT>
implements OneInputStreamOperator<CommT, CommT>,
BoundedOneInput {
    private final Committer<CommT> committer;
    private final List<CommT> allCommittables;

    public BatchCommitterOperator(Committer<CommT> committer) {
        this.committer = (Committer)Preconditions.checkNotNull(committer);
        this.allCommittables = new ArrayList<CommT>();
    }

    @Override
    public void processElement(StreamRecord<CommT> element) {
        this.allCommittables.add(element.getValue());
    }

    @Override
    public void endInput() throws Exception {
        if (!this.allCommittables.isEmpty()) {
            List neededRetryCommittables = this.committer.commit(this.allCommittables);
            if (!neededRetryCommittables.isEmpty()) {
                throw new UnsupportedOperationException("Currently does not support the re-commit!");
            }
            for (CommT committable : this.allCommittables) {
                this.output.collect(new StreamRecord<CommT>(committable));
            }
        }
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.committer.close();
    }
}

